/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraintColumn;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.EditVirtualColumnsPage;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.EditVirtualEntityDialog;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

public class VirtualStructureEditor
extends AbstractDatabaseObjectEditor<DBSEntity>
implements DBPEventListener {
    private static final Log log = Log.getLog(VirtualStructureEditor.class);
    private boolean activated;
    private Composite parent;
    private DBSEntity entity;
    private DBVEntity vEntity;
    private EditDictionaryPage editDictionaryPage;
    private DBVEntityConstraint uniqueConstraint;
    private Table ukTable;
    private Table fkTable;
    private Table refTable;
    private EditVirtualColumnsPage columnsPage;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.entity = (DBSEntity)this.getDatabaseObject();
        this.vEntity = DBVUtils.getVirtualEntity((DBSEntity)this.entity, (boolean)true);
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    public void refreshPart(Object source, boolean force) {
        new AbstractJob(DataEditorsMessages.virtual_structure_editor_abstract_job_load_entity){

            protected IStatus run(DBRProgressMonitor monitor) {
                for (DBVEntityForeignKey fk : VirtualStructureEditor.this.vEntity.getForeignKeys()) {
                    try {
                        fk.getRealReferenceConstraint(monitor);
                        fk.getAssociatedEntity(monitor);
                    }
                    catch (DBException e) {
                        log.debug((Object)e);
                    }
                }
                UIUtils.asyncExec(() -> VirtualStructureEditor.this.refreshVisuals());
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void refreshVisuals() {
        this.columnsPage.refreshAttributes();
        this.ukTable.removeAll();
        try {
            for (DBVEntityConstraint uk : this.vEntity.getConstraints()) {
                if (!uk.isUseAllColumns() && CommonUtils.isEmpty((Collection)uk.getAttributes())) continue;
                this.createUniqueKeyItem(this.ukTable, uk);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading virtual unique keys", (Throwable)e);
        }
        UIUtils.packColumns((Table)this.ukTable, (boolean)true);
        this.fkTable.removeAll();
        try {
            for (DBVEntityForeignKey fk : this.vEntity.getForeignKeys()) {
                this.createForeignKeyItem(this.fkTable, fk, false);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading virtual foreign keys", (Throwable)e);
        }
        UIUtils.packColumns((Table)this.fkTable, (boolean)true);
        this.refTable.removeAll();
        try {
            for (DBVEntityForeignKey fk : DBVUtils.getVirtualReferences((DBSEntity)this.entity)) {
                this.createForeignKeyItem(this.refTable, fk, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading virtual foreign keys", (Throwable)e);
        }
        UIUtils.packColumns((Table)this.refTable, (boolean)true);
    }

    public void activatePart() {
        if (!this.activated) {
            this.createEditorUI();
            this.refreshPart((Object)this, true);
            this.activated = true;
        }
    }

    public void dispose() {
        DBSEntity dbObject;
        if (this.activated && (dbObject = (DBSEntity)this.getDatabaseObject()) != null) {
            DBUtils.getObjectRegistry((DBSObject)dbObject).removeDataSourceListener((DBPEventListener)this);
        }
        super.dispose();
    }

    private void createEditorUI() {
        Composite composite = UIUtils.createComposite((Composite)this.parent, (int)1);
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = true;
        Composite keysComposite = UIUtils.createComposite((Composite)composite, (int)2);
        ((GridLayout)keysComposite.getLayout()).makeColumnsEqualWidth = true;
        keysComposite.setLayoutData((Object)new GridData(1808));
        this.createColumnsPage(keysComposite);
        this.createUniqueKeysPage(keysComposite);
        this.createForeignKeysPage(keysComposite);
        this.createReferencesPage(keysComposite);
        UIUtils.createInfoLabel((Composite)composite, (String)DataEditorsMessages.virtual_structure_editor_info_label_entity_structure, (int)768, (int)1);
        this.parent.layout(true, true);
        DBSEntity dbObject = (DBSEntity)this.getDatabaseObject();
        if (dbObject != null) {
            DBUtils.getObjectRegistry((DBSObject)dbObject).addDataSourceListener((DBPEventListener)this);
        }
    }

    private void createDictionaryPage(TabFolder tabFolder) {
        if (this.entity != null) {
            this.editDictionaryPage = new EditDictionaryPage(this.entity);
            this.editDictionaryPage.createControl((Composite)tabFolder);
            TabItem dictItem = new TabItem(tabFolder, 0);
            dictItem.setText(DataEditorsMessages.virtual_structure_editor_dictionary_page_text);
            dictItem.setControl(this.editDictionaryPage.getControl());
            dictItem.setData((Object)EditVirtualEntityDialog.InitPage.DICTIONARY);
        }
    }

    private void createColumnsPage(Composite parent) {
        Group group = UIUtils.createControlGroup((Composite)parent, (String)DataEditorsMessages.virtual_structure_editor_columns_group_virtual, (int)1, (int)1808, (int)-1);
        group.setLayoutData((Object)new GridData(1808));
        this.columnsPage = new EditVirtualColumnsPage(null, this.vEntity);
        this.columnsPage.createControl((Composite)group);
    }

    private void createUniqueKeysPage(final Composite parent) {
        this.uniqueConstraint = this.vEntity.getBestIdentifier();
        if (this.uniqueConstraint == null) {
            return;
        }
        Group group = UIUtils.createControlGroup((Composite)parent, (String)DataEditorsMessages.virtual_structure_editor_columns_group_unique_keys, (int)1, (int)1808, (int)-1);
        this.ukTable = new Table((Composite)group, 67584);
        this.ukTable.setLayoutData((Object)new GridData(1808));
        this.ukTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)this.ukTable, (int)16384, (String)DataEditorsMessages.virtual_structure_editor_table_column_key_name);
        UIUtils.createTableColumn((Table)this.ukTable, (int)16384, (String)DataEditorsMessages.virtual_structure_editor_table_column_columns);
        Composite buttonsPanel = UIUtils.createComposite((Composite)group, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(32));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)DataEditorsMessages.virtual_structure_editor_dialog_button_add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityConstraint newConstraint = new DBVEntityConstraint(VirtualStructureEditor.this.vEntity, DBSEntityConstraintType.VIRTUAL_KEY, String.valueOf(VirtualStructureEditor.this.vEntity.getName()) + "_uk");
                EditConstraintPage editPage = new EditConstraintPage(DataEditorsMessages.virtual_structure_editor_constraint_page_edit_key, (DBSEntityReferrer)newConstraint);
                if (editPage.edit()) {
                    VirtualStructureEditor.this.changeConstraint(newConstraint, editPage);
                    VirtualStructureEditor.this.vEntity.addConstraint(newConstraint);
                    VirtualStructureEditor.this.createUniqueKeyItem(VirtualStructureEditor.this.ukTable, newConstraint);
                    VirtualStructureEditor.this.vEntity.persistConfiguration();
                }
            }
        });
        final SelectionAdapter ukEditListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ukItem = VirtualStructureEditor.this.ukTable.getSelection()[0];
                DBVEntityConstraint virtualUK = (DBVEntityConstraint)ukItem.getData();
                EditConstraintPage editPage = new EditConstraintPage(DataEditorsMessages.virtual_structure_editor_constraint_page_edit_key, (DBSEntityReferrer)virtualUK);
                if (editPage.edit()) {
                    VirtualStructureEditor.this.changeConstraint(virtualUK, editPage);
                    ukItem.setText(0, DBUtils.getObjectFullName((DBPNamedObject)virtualUK, (DBPEvaluationContext)DBPEvaluationContext.UI));
                    ukItem.setText(1, VirtualStructureEditor.this.getConstraintAttrNames(virtualUK));
                    VirtualStructureEditor.this.vEntity.persistConfiguration();
                }
            }
        };
        final Button btnEdit = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DataEditorsMessages.virtual_structure_editor_dialog_button_edit, (SelectionListener)ukEditListener);
        btnEdit.setEnabled(false);
        final Button btnRemove = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DataEditorsMessages.virtual_structure_editor_dialog_button_remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityConstraint virtualUK = (DBVEntityConstraint)VirtualStructureEditor.this.ukTable.getSelection()[0].getData();
                if (!UIUtils.confirmAction((Shell)parent.getShell(), (String)DataEditorsMessages.virtual_structure_editor_confirm_action_delete_key, (String)NLS.bind((String)DataEditorsMessages.virtual_structure_editor_confirm_action_question_delete, (Object)virtualUK.getName()))) {
                    return;
                }
                VirtualStructureEditor.this.vEntity.removeConstraint(virtualUK);
                VirtualStructureEditor.this.ukTable.remove(VirtualStructureEditor.this.ukTable.getSelectionIndices());
                VirtualStructureEditor.this.vEntity.persistConfiguration();
            }
        });
        btnRemove.setEnabled(false);
        this.ukTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                btnRemove.setEnabled(VirtualStructureEditor.this.ukTable.getSelectionIndex() >= 0);
                btnEdit.setEnabled(VirtualStructureEditor.this.ukTable.getSelectionIndex() >= 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ukEditListener.widgetSelected(e);
            }
        });
    }

    private void changeConstraint(DBVEntityConstraint constraint, EditConstraintPage editPage) {
        constraint.setName(editPage.getConstraintName());
        constraint.setAttributes((Collection)editPage.getSelectedAttributes());
        constraint.setUseAllColumns(editPage.isUseAllColumns());
    }

    private void createUniqueKeyItem(Table ukTable, DBVEntityConstraint uk) {
        TableItem item = new TableItem(ukTable, 0);
        item.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.TREE_UNIQUE_KEY));
        item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)uk, (DBPEvaluationContext)DBPEvaluationContext.UI));
        String ownAttrNames = this.getConstraintAttrNames(uk);
        item.setText(1, ownAttrNames);
        item.setData((Object)uk);
    }

    private String getConstraintAttrNames(DBVEntityConstraint uk) {
        return uk.isUseAllColumns() ? "*" : uk.getAttributes().stream().map(DBVEntityConstraintColumn::getAttributeName).collect(Collectors.joining(","));
    }

    private void createForeignKeysPage(final Composite parent) {
        Group group = UIUtils.createControlGroup((Composite)parent, (String)DataEditorsMessages.virtual_structure_editor_control_group_label_foreign_key, (int)1, (int)1808, (int)-1);
        this.fkTable = new Table((Composite)group, 67584);
        this.fkTable.setLayoutData((Object)new GridData(1808));
        this.fkTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)this.fkTable, (int)16384, (String)DataEditorsMessages.virtual_structure_editor_table_column_target_table);
        UIUtils.createTableColumn((Table)this.fkTable, (int)16384, (String)DataEditorsMessages.virtual_structure_editor_table_column_columns);
        UIUtils.createTableColumn((Table)this.fkTable, (int)16384, (String)DataEditorsMessages.virtual_structure_editor_table_column_datasource);
        Composite buttonsPanel = UIUtils.createComposite((Composite)group, (int)2);
        buttonsPanel.setLayoutData((Object)new GridData(32));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)DataEditorsMessages.virtual_structure_editor_dialog_button_add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityForeignKey virtualFK = EditForeignKeyPage.createVirtualForeignKey((DBVEntity)VirtualStructureEditor.this.vEntity);
                if (virtualFK != null) {
                    VirtualStructureEditor.this.createForeignKeyItem(VirtualStructureEditor.this.fkTable, virtualFK, true);
                    VirtualStructureEditor.this.vEntity.persistConfiguration();
                }
            }
        });
        final Button btnRemove = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DataEditorsMessages.virtual_structure_editor_dialog_button_remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityForeignKey virtualFK = (DBVEntityForeignKey)VirtualStructureEditor.this.fkTable.getSelection()[0].getData();
                if (!UIUtils.confirmAction((Shell)parent.getShell(), (String)DataEditorsMessages.virtual_structure_editor_confirm_action_delete_fk, (String)NLS.bind((String)DataEditorsMessages.virtual_structure_editor_confirm_action_question_delete_foreign, (Object)virtualFK.getName()))) {
                    return;
                }
                VirtualStructureEditor.this.vEntity.removeForeignKey(virtualFK);
                VirtualStructureEditor.this.fkTable.remove(VirtualStructureEditor.this.fkTable.getSelectionIndices());
                ((Button)e.widget).setEnabled(false);
                VirtualStructureEditor.this.vEntity.persistConfiguration();
            }
        });
        btnRemove.setEnabled(false);
        this.fkTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                btnRemove.setEnabled(VirtualStructureEditor.this.fkTable.getSelectionIndex() >= 0);
            }
        });
    }

    private void createReferencesPage(Composite parent) {
        Group group = UIUtils.createControlGroup((Composite)parent, (String)DataEditorsMessages.virtual_structure_editor_control_group_references, (int)1, (int)1808, (int)-1);
        this.refTable = new Table((Composite)group, 67584);
        this.refTable.setLayoutData((Object)new GridData(1808));
        this.refTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)this.refTable, (int)16384, (String)DataEditorsMessages.virtual_structure_editor_table_column_source_table);
        UIUtils.createTableColumn((Table)this.refTable, (int)16384, (String)DataEditorsMessages.virtual_structure_editor_table_column_columns);
        UIUtils.createTableColumn((Table)this.refTable, (int)16384, (String)DataEditorsMessages.virtual_structure_editor_table_column_source_datasource);
        Composite buttonsPanel = UIUtils.createComposite((Composite)group, (int)2);
        buttonsPanel.setLayoutData((Object)new GridData(32));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)DataEditorsMessages.virtual_structure_editor_dialog_button_refresh, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        }).setEnabled(false);
    }

    private void createForeignKeyItem(Table fkTable, DBVEntityForeignKey fk, boolean ref) {
        DBSEntityConstraint refConstraint;
        TableItem item = new TableItem(fkTable, 0);
        Object refEntity = ref ? fk.getEntity() : ((refConstraint = fk.getReferencedConstraint()) == null ? null : refConstraint.getParentObject());
        item.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        item.setText(0, refEntity == null ? "?" : DBUtils.getObjectFullName((DBPNamedObject)refEntity, (DBPEvaluationContext)DBPEvaluationContext.UI));
        String ownAttrNames = fk.getAttributes().stream().map(DBVEntityForeignKeyColumn::getAttributeName).collect(Collectors.joining(","));
        String refAttrNames = fk.getAttributes().stream().map(DBVEntityForeignKeyColumn::getRefAttributeName).collect(Collectors.joining(","));
        item.setText(1, "(" + ownAttrNames + ") -> (" + refAttrNames + ")");
        if (refEntity != null) {
            item.setImage(2, DBeaverIcons.getImage((DBPImage)refEntity.getDataSource().getContainer().getDriver().getIcon()));
            item.setText(2, refEntity.getDataSource().getContainer().getName());
        }
        item.setData((Object)fk);
    }

    private void updateColumnItem(TableItem attrItem) {
        DBVTransformSettings transformSettings;
        DBDAttributeBinding attr = (DBDAttributeBinding)attrItem.getData();
        String transformStr = "";
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(attr, false);
        if (vAttr != null && (transformSettings = vAttr.getTransformSettings()) != null) {
            DBDAttributeTransformerDescriptor td;
            if (!CommonUtils.isEmpty((Collection)transformSettings.getIncludedTransformers())) {
                transformStr = String.join((CharSequence)",", transformSettings.getIncludedTransformers());
            } else if (!CommonUtils.isEmpty((String)transformSettings.getCustomTransformer()) && (td = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(transformSettings.getCustomTransformer())) != null) {
                transformStr = td.getName();
            }
        }
        attrItem.setText(1, transformStr);
        String colorSettings = "";
        List coList = this.vEntity.getColorOverrides(attr.getName());
        if (!coList.isEmpty()) {
            ArrayList<String> coStrings = new ArrayList<String>();
            for (DBVColorOverride co : coList) {
                if (co.getAttributeValues() == null) continue;
                Object[] objectArray = co.getAttributeValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    coStrings.add(CommonUtils.toString((Object)value));
                    ++n2;
                }
            }
            colorSettings = String.join((CharSequence)",", coStrings);
        }
        attrItem.setText(2, colorSettings);
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (event.getObject() == this.vEntity) {
            UIUtils.asyncExec(() -> this.refreshPart(event, true));
        }
    }
}

