/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.net.ssh.jsch;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.eclipse.jsch.ui.UserInfoPrompter;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.JSCHUserInfoPromptProvider;
import org.jkiss.utils.CommonUtils;

public class JSCHUIPromptProvider
implements JSCHUserInfoPromptProvider {
    public UserInfo createUserInfoPrompt(DBWHandlerConfiguration configuration, Session session) {
        return new UIPrompter(configuration, session);
    }

    static class UIPrompter
    extends UserInfoPrompter {
        private static final Log log = Log.getLog(JSCHUIPromptProvider.class);
        private final DBWHandlerConfiguration configuration;

        UIPrompter(DBWHandlerConfiguration configuration, Session session) {
            super(session);
            this.configuration = configuration;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (this.shouldUsePassword()) {
                this.setPassword(this.configuration.getPassword());
            }
            return super.promptKeyboardInteractive(destination, name, instruction, prompt, echo);
        }

        public boolean promptPassword(String message) {
            if (this.shouldUsePassword()) {
                this.setPassword(this.configuration.getPassword());
                return true;
            }
            return super.promptPassword(message);
        }

        public boolean promptPassphrase(String message) {
            if (this.shouldUsePassword()) {
                this.setPassphrase(this.configuration.getPassword());
                return true;
            }
            return super.promptPassphrase(message);
        }

        public void showMessage(String message) {
            log.debug((Object)"SSH server message:");
            log.debug((Object)message);
        }

        private boolean shouldUsePassword() {
            return this.configuration.isSavePassword() || CommonUtils.isNotEmpty((String)this.configuration.getPassword());
        }
    }
}

