/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIViewMessages;
import org.jkiss.dbeaver.ui.UIUtils;

public class TaskHandlerDelete
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<DBTTask> tasksToDelete = new ArrayList<DBTTask>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            for (Object element : structSelection) {
                if (!(element instanceof DBTTask)) continue;
                tasksToDelete.add((DBTTask)element);
            }
        }
        if (!tasksToDelete.isEmpty()) {
            if (tasksToDelete.size() == 1 ? !UIUtils.confirmAction((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)TaskUIViewMessages.task_handler_delete_confirm_title_delete_task, (String)NLS.bind((String)TaskUIViewMessages.task_handler_delete_confirm_question_delete_task, (Object)((DBTTask)tasksToDelete.get(0)).getName())) : !UIUtils.confirmAction((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)TaskUIViewMessages.task_handler_delete_confirm_title_delete_tasks, (String)NLS.bind((String)TaskUIViewMessages.task_handler_delete_confirm_question_delete_tasks, (Object)tasksToDelete.size()))) {
                return null;
            }
            for (DBTTask task : tasksToDelete) {
                try {
                    task.getProject().getTaskManager().deleteTaskConfiguration(task);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(TaskUIViewMessages.task_handler_delete_error_deleting_task_from_scheduler_title, NLS.bind((String)TaskUIViewMessages.task_handler_delete_error_deleting_task_from_scheduler_message, (Object)task.getId()), (Throwable)e);
                }
            }
        }
        return null;
    }
}

