/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import javax.crypto.SecretKey;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPProject;

public class ProjectSecureStorage
implements DBASecureStorage {
    private static final Log log = Log.getLog(ProjectSecureStorage.class);
    protected final DBPProject project;
    protected final DBASecureStorage globalStorage;

    public ProjectSecureStorage(DBPProject project) {
        this.project = project;
        this.globalStorage = project.getWorkspace().getPlatform().getApplication().getSecureStorage();
    }

    public DBPProject getProject() {
        return this.project;
    }

    public DBASecureStorage getGlobalStorage() {
        return this.globalStorage;
    }

    public boolean useSecurePreferences() {
        return this.globalStorage.useSecurePreferences();
    }

    public ISecurePreferences getSecurePreferences() {
        return this.project.getWorkspace().getPlatform().getApplication().getSecureStorage().getSecurePreferences().node("projects").node(this.project.getName());
    }

    public SecretKey getLocalSecretKey() {
        return this.globalStorage.getLocalSecretKey();
    }
}

