/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCColumnKeyType;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt3;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class MySQLTableColumn
extends JDBCTableColumn<MySQLTableBase>
implements DBSTableColumn,
DBSTypedObjectExt3,
DBPNamedObject2,
DBPOrderedObject {
    private static final Log log = Log.getLog(MySQLTableColumn.class);
    private String comment;
    private long charLength;
    private MySQLCollation collation;
    private KeyType keyType;
    private String extraInfo;
    private String genExpression;
    private long modifiers;
    private String fullTypeName;
    private List<String> enumValues;

    public MySQLTableColumn(MySQLTableBase table) {
        super((DBSEntity)table, false);
    }

    public MySQLTableColumn(MySQLTableBase table, ResultSet dbResult) throws DBException {
        super((DBSEntity)table, true);
        this.loadInfo(dbResult);
    }

    public MySQLTableColumn(DBRProgressMonitor monitor, MySQLTableBase table, DBSEntityAttribute source) throws DBException {
        super((DBSEntity)table, source, false);
        this.comment = source.getDescription();
        if (source instanceof MySQLTableColumn) {
            MySQLTableColumn mySource = (MySQLTableColumn)source;
            this.charLength = mySource.charLength;
            this.collation = mySource.collation;
            this.keyType = mySource.keyType;
            this.extraInfo = mySource.extraInfo;
            this.genExpression = mySource.genExpression;
            this.fullTypeName = mySource.fullTypeName;
            if (mySource.enumValues != null) {
                this.enumValues = new ArrayList<String>(mySource.enumValues);
            }
        } else {
            this.collation = ((MySQLCatalog)table.getContainer()).getAdditionalInfo(monitor).getDefaultCollation();
            this.fullTypeName = DBUtils.getFullTypeName((DBSTypedObject)this);
        }
    }

    private void loadInfo(ResultSet dbResult) throws DBException {
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
        this.ordinalPosition = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
        String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE");
        assert (typeName != null);
        String keyTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_KEY");
        if (!CommonUtils.isEmpty((String)keyTypeName)) {
            try {
                this.keyType = KeyType.valueOf(keyTypeName);
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)e);
            }
        }
        this.setTypeName(typeName);
        this.setValueType(MySQLUtils.typeNameToValueType(typeName));
        DBSDataType dataType = this.getDataSource().getLocalDataType(typeName);
        this.charLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CHARACTER_MAXIMUM_LENGTH");
        if (this.charLength <= 0L) {
            if (dataType != null) {
                this.setMaxLength(CommonUtils.toInt((Object)dataType.getPrecision()));
            }
        } else {
            this.setMaxLength(this.charLength);
        }
        this.comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_COMMENT");
        this.required = !"YES".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IS_NULLABLE"));
        this.setScale(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"NUMERIC_SCALE"));
        this.setPrecision(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"NUMERIC_PRECISION"));
        String defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_DEFAULT");
        if (defaultValue != null) {
            switch (this.getDataKind()) {
                case STRING: {
                    if ("NULL".equals(defaultValue) || SQLUtils.isStringQuoted((DBSObject)this.getDataSource(), (String)defaultValue)) break;
                    defaultValue = SQLUtils.quoteString((DBPDataSource)this.getDataSource(), (String)defaultValue);
                    break;
                }
                case DATETIME: {
                    if (defaultValue.isEmpty() || !Character.isDigit(defaultValue.charAt(0))) break;
                    defaultValue = "'" + defaultValue + "'";
                }
            }
            this.setDefaultValue(defaultValue);
        }
        this.collation = this.getDataSource().getCollation(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATION_NAME"));
        this.extraInfo = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EXTRA");
        this.autoGenerated = this.extraInfo != null && this.extraInfo.contains("auto_increment");
        this.fullTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_TYPE");
        if (!CommonUtils.isEmpty((String)this.fullTypeName) && (this.isTypeEnum() || this.isTypeSet())) {
            this.enumValues = MySQLTableColumn.parseEnumValues(this.fullTypeName);
        }
        if (!this.getDataSource().isMariaDB() && this.getDataSource().isServerVersionAtLeast(5, 7)) {
            this.genExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"GENERATION_EXPRESSION");
        }
        String[] stringArray = CommonUtils.notEmpty((String)this.fullTypeName).toLowerCase().split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String modifier;
            switch (modifier = stringArray[n2]) {
                case "zerofill": {
                    this.modifiers |= 0x400L;
                    break;
                }
                case "unsigned": {
                    this.modifiers |= 0x20L;
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<String> parseEnumValues(String typeName) {
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder value = new StringBuilder();
        int pos = 0;
        int startPos;
        while ((startPos = typeName.indexOf(39, pos)) >= 0) {
            int endPos = -1;
            int i = startPos + 1;
            while (i < typeName.length()) {
                block7: {
                    char c = typeName.charAt(i);
                    if (c == '\'') {
                        if (i < typeName.length() - 2 && typeName.charAt(i + 1) == '\'') {
                            value.append(c);
                            ++i;
                            break block7;
                        } else {
                            endPos = i;
                            break;
                        }
                    }
                    value.append(c);
                }
                ++i;
            }
            if (endPos < 0) {
                return values;
            }
            values.add(value.toString());
            pos = endPos + 1;
            value.setLength(0);
        }
        return values;
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return (MySQLDataSource)((MySQLTableBase)this.getTable()).getDataSource();
    }

    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=JDBCTableColumn.ColumnTypeNameListProvider.class)
    public String getFullTypeName() {
        return this.fullTypeName;
    }

    public void setFullTypeName(String fullTypeName) throws DBException {
        super.setFullTypeName(fullTypeName);
        this.fullTypeName = fullTypeName;
    }

    public String getTypeName() {
        return super.getTypeName();
    }

    public boolean isTypeSet() {
        return this.typeName.equalsIgnoreCase("set");
    }

    public boolean isTypeEnum() {
        return this.typeName.equalsIgnoreCase("enum");
    }

    public long getTypeModifiers() {
        return super.getTypeModifiers() | this.modifiers;
    }

    public long getMaxLength() {
        return super.getMaxLength();
    }

    public Integer getScale() {
        return super.getScale();
    }

    public Integer getPrecision() {
        return super.getPrecision();
    }

    @Property(viewable=true, editable=true, updatable=true, order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    @Property(viewable=true, editable=true, updatable=true, order=51)
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean autoGenerated) {
        if (autoGenerated) {
            this.extraInfo = (String.valueOf(CommonUtils.notEmpty((String)this.extraInfo)) + " " + "auto_increment").trim();
        } else if (this.extraInfo != null) {
            this.extraInfo = this.extraInfo.replace("auto_increment", " ").trim();
        }
        super.setAutoGenerated(autoGenerated);
    }

    @Property(viewable=true, editable=true, updatable=true, order=70)
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    @Property(viewable=true, editable=true, updatable=true, order=71)
    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Property(viewable=true, editable=true, updatable=true, order=72)
    public String getGenExpression() {
        return this.genExpression;
    }

    public void setGenExpression(String genExpression) {
        this.genExpression = genExpression;
    }

    @Property(viewable=true, order=60)
    public KeyType getKeyType() {
        return this.keyType;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    @Property(viewable=false, editable=true, updatable=true, listProvider=CharsetListProvider.class, order=81)
    public MySQLCharset getCharset() {
        return this.collation == null ? null : this.collation.getCharset();
    }

    public void setCharset(MySQLCharset charset) {
        this.collation = charset == null ? null : charset.getDefaultCollation();
    }

    @Property(viewable=false, editable=true, updatable=true, listProvider=CollationListProvider.class, order=82)
    public MySQLCollation getCollation() {
        return this.collation;
    }

    public void setCollation(MySQLCollation collation) {
        this.collation = collation;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Nullable
    public String getDescription() {
        return this.getComment();
    }

    public static class CharsetListProvider
    implements IPropertyValueListProvider<MySQLTableColumn> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(MySQLTableColumn object) {
            return object.getDataSource().getCharsets().toArray();
        }
    }

    public static class CollationListProvider
    implements IPropertyValueListProvider<MySQLTableColumn> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(MySQLTableColumn object) {
            if (object.getCharset() == null) {
                return new Object[0];
            }
            return object.getCharset().getCollations().toArray();
        }
    }

    public static enum KeyType implements JDBCColumnKeyType
    {
        PRI,
        UNI,
        MUL;


        public boolean isInUniqueKey() {
            return this == PRI || this == UNI;
        }

        public boolean isInReferenceKey() {
            return this == MUL;
        }
    }
}

