/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.BooleanRenderer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseEditors
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.editors";
    private Button keepEditorsOnRestart;
    private Button refreshEditorOnOpen;
    private Button editorFullName;
    private Button showTableGrid;
    private Button showPreviewOnSave;
    private Button syncEditorDataSourceWithNavigator;
    private Combo booleanStyleSelector;

    public PrefPageDatabaseEditors() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group groupEditors = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_editors, (int)1, (int)2, (int)0);
        this.keepEditorsOnRestart = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_keep_database_editors, (boolean)false);
        this.keepEditorsOnRestart.setToolTipText(CoreMessages.pref_page_ui_general_keep_database_editors_tip);
        this.refreshEditorOnOpen = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_refresh_editor_on_open, (boolean)false);
        this.refreshEditorOnOpen.setToolTipText(CoreMessages.pref_page_ui_general_refresh_editor_on_open_tip);
        this.editorFullName = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_full_name_in_editor, (boolean)false);
        this.showTableGrid = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_table_grid, (boolean)false);
        this.showPreviewOnSave = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_preview_on_save, (boolean)false);
        this.syncEditorDataSourceWithNavigator = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator_tip, (boolean)false, (int)2);
        groupEditors = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_connection_wizard_final_group_misc, (int)2, (int)2, (int)0);
        this.booleanStyleSelector = UIUtils.createLabelCombo((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_boolean_style, (String)CoreMessages.pref_page_ui_general_boolean_style_tip, (int)12);
        BooleanRenderer.Style[] styleArray = BooleanRenderer.Style.values();
        int n = styleArray.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanRenderer.Style style = styleArray[n2];
            this.booleanStyleSelector.add(style.getDisplayName());
            ++n2;
        }
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.keepEditorsOnRestart.setSelection(store.getBoolean("ui.editors.reopen-after-restart"));
        this.refreshEditorOnOpen.setSelection(store.getBoolean("navigator.refresh.editor.open"));
        this.editorFullName.setSelection(store.getBoolean("navigator.editor.full-name"));
        this.showTableGrid.setSelection(store.getBoolean("navigator.editor.showGrid"));
        this.showPreviewOnSave.setSelection(store.getBoolean("navigator.editor.show.preview"));
        this.syncEditorDataSourceWithNavigator.setSelection(store.getBoolean("navigator.sync.editor.datasource"));
        this.booleanStyleSelector.select(BooleanRenderer.getDefaultStyle().ordinal());
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ui.editors.reopen-after-restart", this.keepEditorsOnRestart.getSelection());
        store.setValue("navigator.refresh.editor.open", this.refreshEditorOnOpen.getSelection());
        store.setValue("navigator.editor.full-name", this.editorFullName.getSelection());
        store.setValue("navigator.editor.showGrid", this.showTableGrid.getSelection());
        store.setValue("navigator.editor.show.preview", this.showPreviewOnSave.getSelection());
        store.setValue("navigator.sync.editor.datasource", this.syncEditorDataSourceWithNavigator.getSelection());
        BooleanRenderer.setDefaultStyle((BooleanRenderer.Style)((BooleanRenderer.Style)CommonUtils.fromOrdinal(BooleanRenderer.Style.class, (int)this.booleanStyleSelector.getSelectionIndex())));
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

