/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.info.DB2Parameter;
import org.jkiss.dbeaver.ext.db2.info.DB2XMLString;
import org.jkiss.dbeaver.ext.db2.model.DB2Bufferpool;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2MaterializedQueryTable;
import org.jkiss.dbeaver.ext.db2.model.DB2Package;
import org.jkiss.dbeaver.ext.db2.model.DB2Routine;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Sequence;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.DB2Trigger;
import org.jkiss.dbeaver.ext.db2.model.DB2View;
import org.jkiss.dbeaver.ext.db2.model.DB2XMLSchema;
import org.jkiss.dbeaver.ext.db2.model.app.DB2ServerApplication;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablespaceDataType;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2Nickname;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCCallableStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2Utils {
    private static final Log LOG = Log.getLog(DB2Utils.class);
    private static final String LINE_SEP = ";\n";
    private static final String CALL_DB2LK_GEN = "CALL SYSPROC.DB2LK_GENERATE_DDL(?,?)";
    private static final String CALL_DB2LK_CLEAN = "CALL SYSPROC.DB2LK_CLEAN_TABLE(?)";
    private static final String SEL_DB2LK = "SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = ? ORDER BY OP_SEQUENCE WITH UR";
    private static final String DB2LK_COMMAND = "-e -x -xd -td %s -t %s";
    private static final String CALL_INST_OBJ = "CALL SYSPROC.SYSINSTALLOBJECTS(?,?,?,?)";
    private static final int CALL_INST_OBJ_BAD_RC = -438;
    private static final String SEL_LIST_TS_EXPLAIN;
    private static final String CALL_ADMIN_CMD = "CALL SYSPROC.ADMIN_CMD('%s')";
    private static final String SEL_DBCFG = "SELECT * FROM SYSIBMADM.DBCFG ORDER BY NAME  WITH UR";
    private static final String SEL_DBMCFG = "SELECT * FROM SYSIBMADM.DBMCFG ORDER BY NAME WITH UR";
    private static final String SEL_XMLSTRINGS = "SELECT * FROM SYSCAT.XMLSTRINGS ORDER BY STRINGID WITH UR";
    public static final String SEL_APP = "SELECT * FROM SYSIBMADM.APPLICATIONS WITH UR";
    private static final String GET_MSG = "VALUES (SYSPROC.SQLERRM(?))";

    static {
        StringBuilder sb = new StringBuilder(512);
        sb.append("SELECT TA.TBSPACE");
        sb.append("  FROM SYSCAT.TBSPACEAUTH TA");
        sb.append("     , SYSCAT.TABLESPACES T");
        sb.append(" WHERE TA.GRANTEE IN ('PUBLIC',SESSION_USER)");
        sb.append("   AND TA.USEAUTH In ('Y','G')");
        sb.append("   AND T.TBSPACE = TA.TBSPACE");
        sb.append("   AND T.DATATYPE IN (");
        sb.append("                     '").append(DB2TablespaceDataType.A.name()).append("'");
        sb.append("                    ,'").append(DB2TablespaceDataType.L.name()).append("'");
        sb.append("                     )");
        sb.append(" ORDER BY TA.TBSPACE");
        sb.append(" WITH UR");
        SEL_LIST_TS_EXPLAIN = sb.toString();
    }

    public static void callAdminCmd(DBRProgressMonitor monitor, DB2DataSource dataSource, String command) throws SQLException, DBCException {
        LOG.debug((Object)("Call admin_cmd with '" + command + "'"));
        String sql = String.format(CALL_ADMIN_CMD, command);
        monitor.beginTask("Executing command " + command, 1);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)dataSource, (String)"ADMIN_CMD");){
                JDBCUtils.executeProcedure((Connection)session, (String)sql);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static String generateDDLforTable(DBRProgressMonitor monitor, String statementDelimiter, DB2DataSource dataSource, DB2Table db2Table) throws DBException {
        LOG.debug((Object)("Generate DDL for " + db2Table.getFullyQualifiedName(DBPEvaluationContext.DDL)));
        if (db2Table.getSchema().isSystem()) {
            return DB2Messages.no_ddl_for_system_tables;
        }
        if (db2Table.getFullyQualifiedName(DBPEvaluationContext.DDL).contains(" ")) {
            return DB2Messages.no_ddl_for_spaces_in_name;
        }
        monitor.beginTask("Generating DDL", 3);
        StringBuilder sb = new StringBuilder(2048);
        String command = String.format(DB2LK_COMMAND, statementDelimiter, db2Table.getFullyQualifiedName(DBPEvaluationContext.DDL));
        try {
            String string;
            block64: {
                Throwable throwable = null;
                Object var8_9 = null;
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Generate DDL");
                try {
                    int token;
                    LOG.debug((Object)("Calling DB2LK_GENERATE_DDL with command : " + command));
                    Throwable throwable2 = null;
                    Object var11_16 = null;
                    try (JDBCCallableStatement stmtSP = session.prepareCall(CALL_DB2LK_GEN);){
                        stmtSP.registerOutParameter(2, 4);
                        stmtSP.setString(1, command);
                        stmtSP.executeUpdate();
                        token = stmtSP.getInt(2);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    LOG.debug((Object)("Token = " + token));
                    monitor.worked(1);
                    throwable2 = null;
                    var11_16 = null;
                    try (JDBCPreparedStatement stmtSel = session.prepareStatement(SEL_DB2LK);){
                        stmtSel.setInt(1, token);
                        Throwable throwable4 = null;
                        Object var14_24 = null;
                        try (JDBCResultSet dbResult = stmtSel.executeQuery();){
                            Long ddlStart = 1L;
                            while (dbResult.next()) {
                                Clob ddlStmt = dbResult.getClob(1);
                                try {
                                    Long ddlLength = ddlStmt.length() + 1L;
                                    sb.append(ddlStmt.getSubString(ddlStart, ddlLength.intValue()));
                                    sb.append(LINE_SEP);
                                }
                                finally {
                                    try {
                                        ddlStmt.free();
                                    }
                                    catch (Throwable e) {
                                        LOG.debug((Object)("Error freeing CLOB: " + e.getMessage()));
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable4 == null) {
                                throwable4 = throwable5;
                            } else if (throwable4 != throwable5) {
                                throwable4.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                        } else if (throwable2 != throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        throw throwable2;
                    }
                    monitor.worked(2);
                    throwable2 = null;
                    var11_16 = null;
                    try (JDBCCallableStatement stmtSPClean = session.prepareCall(CALL_DB2LK_CLEAN);){
                        stmtSPClean.setInt(1, token);
                        stmtSPClean.executeUpdate();
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                        } else if (throwable2 != throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        throw throwable2;
                    }
                    monitor.worked(3);
                    LOG.debug((Object)"Terminated OK");
                    string = sb.toString();
                    if (session == null) break block64;
                }
                catch (Throwable throwable8) {
                    try {
                        try {
                            if (session != null) {
                                session.close();
                            }
                            throw throwable8;
                        }
                        catch (Throwable throwable9) {
                            if (throwable == null) {
                                throwable = throwable9;
                            } else if (throwable != throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        throw new DBException((Throwable)e, (DBPDataSource)dataSource);
                    }
                }
                session.close();
            }
            return string;
        }
        finally {
            monitor.done();
        }
    }

    public static String getMessageFromCode(DB2DataSource db2DataSource, Integer sqlErrorCode) throws SQLException, DBCException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)db2DataSource, (String)"Get Error Code");){
            return JDBCUtils.queryString((JDBCSession)session, (String)GET_MSG, (Object[])new Object[]{sqlErrorCode});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<String> getListOfUsableTsForExplain(DBRProgressMonitor monitor, JDBCSession session) throws SQLException {
        LOG.debug((Object)"Get List Of Usable Tablespaces For Explain Tables");
        ArrayList<String> listTablespaces = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(SEL_LIST_TS_EXPLAIN);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    listTablespaces.add(dbResult.getString(1));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return listTablespaces;
    }

    /*
     * Exception decompiling
     */
    public static Boolean checkExplainTables(DBRProgressMonitor monitor, DB2DataSource dataSource, String explainTableSchemaName) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void createExplainTables(DBRProgressMonitor monitor, DB2DataSource dataSource, String explainTableSchemaName, String tablespaceName) throws DBCException {
        LOG.debug((Object)("Create EXPLAIN tables in " + explainTableSchemaName));
        monitor.beginTask("Create EXPLAIN Tables", 1);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Create EXPLAIN tables");){
                try {
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCCallableStatement stmtSP = session.prepareCall(CALL_INST_OBJ);){
                        stmtSP.setString(1, "EXPLAIN");
                        stmtSP.setString(2, "C");
                        stmtSP.setString(3, tablespaceName);
                        stmtSP.setString(4, explainTableSchemaName);
                        stmtSP.executeUpdate();
                        LOG.debug((Object)"Creation EXPLAIN Tables : OK");
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    LOG.error((Object)("SQLException occured during EXPLAIN tables creation in schema " + explainTableSchemaName), (Throwable)e);
                    throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static List<DB2ServerApplication> readApplications(DBRProgressMonitor monitor, JDBCSession session) throws SQLException {
        LOG.debug((Object)"readApplications");
        ArrayList<DB2ServerApplication> listApplications = new ArrayList<DB2ServerApplication>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(SEL_APP);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    listApplications.add(new DB2ServerApplication((ResultSet)dbResult));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return listApplications;
    }

    public static List<DB2Parameter> readDBCfg(DBRProgressMonitor monitor, JDBCSession session) throws SQLException {
        LOG.debug((Object)"readDBCfg");
        ArrayList<DB2Parameter> listDBParameters = new ArrayList<DB2Parameter>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(SEL_DBCFG);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    listDBParameters.add(new DB2Parameter((DB2DataSource)session.getDataSource(), (ResultSet)dbResult));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return listDBParameters;
    }

    public static List<DB2Parameter> readDBMCfg(DBRProgressMonitor monitor, JDBCSession session) throws SQLException {
        LOG.debug((Object)"readDBMCfg");
        ArrayList<DB2Parameter> listDBMParameters = new ArrayList<DB2Parameter>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(SEL_DBMCFG);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    listDBMParameters.add(new DB2Parameter((DB2DataSource)session.getDataSource(), (ResultSet)dbResult));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return listDBMParameters;
    }

    public static List<DB2XMLString> readXMLStrings(DBRProgressMonitor monitor, JDBCSession session) throws SQLException {
        LOG.debug((Object)"readXMLStrings");
        ArrayList<DB2XMLString> listXMLStrings = new ArrayList<DB2XMLString>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(SEL_XMLSTRINGS);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    listXMLStrings.add(new DB2XMLString((DB2DataSource)session.getDataSource(), (ResultSet)dbResult));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return listXMLStrings;
    }

    public static DB2Tablespace findTablespaceById(DBRProgressMonitor monitor, DB2DataSource db2DataSource, Integer tablespaceId) throws DBException {
        if (db2DataSource == null) {
            return null;
        }
        for (DB2Tablespace db2Tablespace : db2DataSource.getTablespaces(monitor)) {
            if (!CommonUtils.equalObjects((Object)db2Tablespace.getTbspaceId(), (Object)tablespaceId)) continue;
            return db2Tablespace;
        }
        return null;
    }

    public static DB2Bufferpool findBufferpoolById(DBRProgressMonitor monitor, DB2DataSource db2DataSource, Integer bufferpoolId) throws DBException {
        if (db2DataSource == null) {
            return null;
        }
        for (DB2Bufferpool db2Bufferpool : db2DataSource.getBufferpools(monitor)) {
            if (!CommonUtils.equalObjects((Object)db2Bufferpool.getId(), (Object)bufferpoolId)) continue;
            return db2Bufferpool;
        }
        return null;
    }

    public static DB2TableColumn findColumnBySchemaNameAndTableNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2TableName, String db2ColumnName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        DB2Table db2Table = db2Schema.getTable(monitor, db2TableName);
        if (db2Table == null) {
            return null;
        }
        return db2Table.getAttribute(monitor, db2ColumnName);
    }

    public static DB2Index findIndexBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2IndexName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getIndex(monitor, db2IndexName);
    }

    public static DB2Module findModuleBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2ModuleName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getModule(monitor, db2ModuleName);
    }

    public static DB2Nickname findNicknameBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2NicknameName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getNickname(monitor, db2NicknameName);
    }

    public static DB2MaterializedQueryTable findMaterializedQueryTableBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2NicknameName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getMaterializedQueryTable(monitor, db2NicknameName);
    }

    public static DB2Package findPackageBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2PackageName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getPackage(monitor, db2PackageName);
    }

    public static DB2Routine findMethodBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2MethodName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getMethod(monitor, db2MethodName);
    }

    public static DB2Routine findProcedureBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2ProcedureName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getProcedure(monitor, db2ProcedureName);
    }

    public static DB2Sequence findSequenceBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2SequenceName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getSequence(monitor, db2SequenceName);
    }

    public static DB2Table findTableBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2TableName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getTable(monitor, db2TableName);
    }

    public static DB2Trigger findTriggerBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2TriggerName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getTrigger(monitor, db2TriggerName);
    }

    public static DB2Routine findUDFBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2FunctionName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getUDF(monitor, db2FunctionName);
    }

    public static DB2View findViewBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2ViewName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getView(monitor, db2ViewName);
    }

    public static DB2MaterializedQueryTable findMQTBySchemaNameAndName(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String db2SchemaName, String db2MQTName) throws DBException {
        DB2Schema db2Schema = db2DataSource.getSchema(monitor, db2SchemaName);
        if (db2Schema == null) {
            return null;
        }
        return db2Schema.getMaterializedQueryTable(monitor, db2MQTName);
    }

    public static DB2XMLSchema findXMLSchemaByById(DBRProgressMonitor monitor, DB2DataSource db2DataSource, Long xmlSchemaId) throws DBException {
        if (db2DataSource == null) {
            return null;
        }
        for (DB2Schema db2Schema : db2DataSource.getSchemas(monitor)) {
            for (DB2XMLSchema db2XMLSchema : db2Schema.getXMLSchemas(monitor)) {
                if (!db2XMLSchema.getId().equals(xmlSchemaId)) continue;
                return db2XMLSchema;
            }
        }
        return null;
    }

    public static String formatSQLProcedureDDL(DB2DataSource db2DataSource, String rawText) {
        String result = SQLFormatUtils.formatSQL((DBPDataSource)db2DataSource, (String)rawText);
        result = result.replace("CREATE\r\n    PROCEDURE", "CREATE PROCEDURE");
        result = result.replace("\r\nOR REPLACE", " OR REPLACE");
        result = result.replace(" LANGUAGE ", "\r\nLANGUAGE ");
        result = result.replace(" SPECIFIC ", "\r\nSPECIFIC ");
        result = result.replace(" DYNAMIC RESULT ", "\r\nDYNAMIC RESULT ");
        result = result.replace(" MODIFIES SQL ", "\r\nMODIFIES SQL ");
        result = result.replace(" CONTAINS SQL ", "\r\nCONTAINS SQL ");
        result = result.replace(" READS SQL DATA ", "\r\nREADS SQL DATA ");
        result = result.replace(" NOT DETERMINISTIC ", "\r\nNOT DETERMINISTIC ");
        result = result.replace(" DETERMINISTIC ", "\r\nDETERMINISTIC ");
        result = result.replace(" CALLED ON NULL INPUT ", "\r\nCALLED ON NULL INPUT ");
        result = result.replace(" COMMIT ON RETURN ", "\r\nCOMMIT ON RETURN ");
        result = result.replace(" AUTONOMOUS ", "\r\nAUTONOMOUS ");
        result = result.replace(" INHERIT SPECIAL ", "\r\nINHERIT SPECIAL ");
        result = result.replace(" OLD SAVEPOINT ", "\r\nOLD SAVEPOINT ");
        result = result.replace(" NEW SAVEPOINT ", "\r\nNEW SAVEPOINT ");
        result = result.replace(" EXTERNAL ACTION ", "\r\nEXTERNAL ACTION ");
        result = result.replace(" NO EXTERNAL ", "\r\nNO EXTERNAL ");
        result = result.replace(" PARAMETER CCSID ", "\r\nPARAMETER CCSID ");
        result = result.replace(" BEGIN ", "\r\nBEGIN\r\n");
        result = result.replaceAll(";", ";\r\n");
        result = result.replaceAll("\\r\\n;", ";");
        result = result.replaceAll("\\r\\n ", "\r\n");
        result = result.replaceAll("SET\\r\\n", "SET ");
        result = result.replaceAll("INTO\\r\\n", "INTO ");
        result = result.replaceAll("FROM\\r\\n", "FROM ");
        result = result.replaceAll("FETCH\\r\\n", "FETCH ");
        result = result.replaceAll("WHERE\\r\\n", "WHERE ");
        return result;
    }

    private DB2Utils() {
    }
}

