/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ocient.model.plan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.ocient.model.plan.OcientPlanNodeJson;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class OcientExecutionPlan
extends AbstractExecutionPlan {
    private String query;
    private List<OcientPlanNodeJson> rootNodes;
    private static final Gson gson = new Gson();

    public OcientExecutionPlan(String query) {
        this.query = query;
    }

    public OcientExecutionPlan(String query, List<OcientPlanNodeJson> rootNodes) {
        this.query = query;
        this.rootNodes = rootNodes;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.duration".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "explain json" + this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    public void explain(DBCSession session) throws DBCException {
        String explainString = this.getExplainString(session);
        JsonObject planObject = (JsonObject)gson.fromJson(explainString, JsonObject.class);
        JsonObject planRoot = planObject.getAsJsonObject("rootNode");
        JsonObject planHeader = planObject.getAsJsonObject("header");
        this.rootNodes = new ArrayList<OcientPlanNodeJson>();
        OcientPlanNodeJson headerNode = new OcientPlanNodeJson(null, "header", planHeader);
        OcientPlanNodeJson rootNode = new OcientPlanNodeJson(null, "Root", planRoot);
        this.rootNodes.add(headerNode);
        this.rootNodes.add(rootNode);
    }

    private String getExplainString(DBCSession session) throws DBCException {
        JDBCSession connection = (JDBCSession)session;
        String plan = "";
        try {
            JDBCPreparedStatement dbStat = connection.prepareStatement(this.getPlanQueryString());
            JDBCResultSet dbResult = dbStat.executeQuery();
            while (dbResult.next()) {
                String planLine = dbResult.getString(1);
                plan = String.valueOf(plan) + planLine;
            }
            dbResult.close();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
        return plan;
    }
}

