/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.auth;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OracleAuthModelDatabaseNative
extends AuthModelDatabaseNative {
    public static final String ID = "oracle_native";

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelDatabaseNativeCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        String userName = configuration.getUserName();
        if (!CommonUtils.isEmpty((String)userName) && !userName.contains(" AS ")) {
            String role = configuration.getAuthProperty("oracle.logon-as");
            if (CommonUtils.isEmpty((String)role)) {
                role = configuration.getProviderProperty("oracle.logon-as");
            }
            if (!CommonUtils.isEmpty((String)role)) {
                userName = String.valueOf(userName) + " AS " + role;
            }
        }
        credentials.setUserName(userName);
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

