/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class ERDUIUtils {
    private static final Log log = Log.getLog(ERDUIUtils.class);
    public static final boolean OPEN_OBJECT_PROPERTIES = true;

    public static void openObjectEditor(@NotNull EntityDiagram diagram, @NotNull ERDObject object) {
        Object dbObject = object.getObject();
        if (dbObject instanceof DBSObject) {
            UIUtils.runUIJob((String)"Open object editor", monitor -> {
                if (!(dbObject instanceof DBSEntity)) {
                    try {
                        IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
                        IViewPart propsView = activePage.showView("org.eclipse.ui.views.PropertySheet");
                        if (propsView != null) {
                            propsView.setFocus();
                        }
                    }
                    catch (PartInitException e) {
                        DBWorkbench.getPlatformUI().showError("Object open", "Can't open property view", (Throwable)e);
                    }
                } else {
                    DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)((DBSObject)dbObject), (boolean)true);
                    if (node != null) {
                        NavigatorUtils.openNavigatorNode((Object)node, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
                    }
                }
            });
        }
    }

    public static String getFullAttributeLabel(EntityDiagram diagram, ERDEntityAttribute attribute, boolean includeType) {
        String comment;
        String attributeLabel = attribute.getName();
        if (includeType && diagram.hasAttributeStyle(ERDViewStyle.TYPES)) {
            attributeLabel = String.valueOf(attributeLabel) + ": " + ((DBSEntityAttribute)attribute.getObject()).getFullTypeName();
        }
        if (includeType && diagram.hasAttributeStyle(ERDViewStyle.NULLABILITY) && ((DBSEntityAttribute)attribute.getObject()).isRequired()) {
            attributeLabel = String.valueOf(attributeLabel) + " NOT NULL";
        }
        if (diagram.hasAttributeStyle(ERDViewStyle.COMMENTS) && !CommonUtils.isEmpty((String)(comment = ((DBSEntityAttribute)attribute.getObject()).getDescription()))) {
            attributeLabel = String.valueOf(attributeLabel) + " - " + comment;
        }
        return attributeLabel;
    }
}

