/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorAdapter;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.model.ERDDatabaseObjectModifyCommand;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.navigator.dialogs.ConfirmNavigatorNodesDeleteDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ERDHandlerDelete
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ERDEditorPart editor;
        Control control = (Control)HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeFocusControl");
        if (control != null && (editor = ERDEditorAdapter.getEditor(control)) != null && !editor.isReadOnly()) {
            ERDDeleteAction deleteAction = new ERDDeleteAction(editor);
            deleteAction.update();
            if (deleteAction.isEnabled()) {
                List selectedObjects = deleteAction.getSelectedObjects();
                ArrayList<DBNDatabaseNode> selectedNodes = new ArrayList<DBNDatabaseNode>();
                Command deleteCommand = deleteAction.createDeleteCommand(selectedObjects);
                if (deleteCommand instanceof CompoundCommand) {
                    for (Object nc : ((CompoundCommand)deleteCommand).getCommands()) {
                        DBNDatabaseNode node;
                        DBSObject object;
                        if (!(nc instanceof ERDDatabaseObjectModifyCommand) || (object = ((ERDDatabaseObjectModifyCommand)nc).getDatabaseObject()) == null || (node = DBNUtils.getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)object, (boolean)true)) == null) continue;
                        selectedNodes.add(node);
                    }
                }
                if (!selectedNodes.isEmpty() && ConfirmNavigatorNodesDeleteDialog.of((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), selectedNodes, null).open() != 2) {
                    return null;
                }
                deleteAction.run();
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        ERDEditorPart editor = (ERDEditorPart)((Object)RuntimeUtils.getObjectAdapter((Object)activeEditor, ERDEditorPart.class));
        if (editor != null) {
            if (editor.getDiagram().isEditEnabled()) {
                element.setText("Delete object(s)");
                element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE));
            } else {
                element.setText("Remove from diagram");
                element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_REMOVE));
            }
        }
    }

    private static class ERDDeleteAction
    extends DeleteAction {
        ERDDeleteAction(ERDEditorPart editor) {
            super((IWorkbenchPart)editor);
        }

        public List getSelectedObjects() {
            return super.getSelectedObjects();
        }
    }
}

