/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.ui.properties.PropertySourceDelegate;

public abstract class PropertyAwarePart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
DBPNamedObject {
    @NotNull
    public String getName() {
        return ((ERDObject)this.getModel()).getName();
    }

    @NotNull
    public DiagramPart getDiagramPart() {
        EditPart part = this.getParent();
        while (part != null) {
            if (part instanceof DiagramPart) {
                return (DiagramPart)part;
            }
            part = part.getParent();
        }
        throw new IllegalStateException("Diagram part must be top level part");
    }

    @NotNull
    public EntityDiagram getDiagram() {
        return this.getDiagramPart().getDiagram();
    }

    @NotNull
    public ERDEditorPart getEditor() {
        return ((ERDGraphicalViewer)this.getViewer()).getEditor();
    }

    @Nullable
    public DBECommandContext getCommandContext() {
        return this.getEditor().getCommandContext();
    }

    protected boolean isLayoutEnabled() {
        return this.getDiagram().isLayoutManualAllowed();
    }

    protected boolean isEditEnabled() {
        return this.getDiagram().isEditEnabled();
    }

    protected boolean isColumnDragAndDropSupported() {
        return true;
    }

    public void activate() {
        super.activate();
        ERDObject erdObject = (ERDObject)this.getModel();
        if (this.isLayoutEnabled() || this.isEditEnabled()) {
            erdObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.isLayoutEnabled() || this.isEditEnabled()) {
            ERDObject erdObject = (ERDObject)this.getModel();
            erdObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property;
        switch (property = evt.getPropertyName()) {
            case "CHILD": {
                this.handleChildChange(evt);
                break;
            }
            case "REORDER": {
                this.handleReorderChange(evt);
                break;
            }
            case "OUTPUT": {
                this.handleOutputChange(evt);
                break;
            }
            case "INPUT": {
                this.handleInputChange(evt);
                break;
            }
            case "NAME": {
                this.commitNameChange(evt);
                break;
            }
            case "CONTENTS": {
                this.commitRefresh(evt);
                break;
            }
            case "SIZE": {
                IFigure figure = this.getFigure();
                if (this instanceof NodePart) {
                    Rectangle curBounds = figure.getBounds().getCopy();
                    Dimension newSize = figure.getPreferredSize();
                    curBounds.width = newSize.width;
                    curBounds.height = newSize.height;
                    ((NodePart)this).modifyBounds(curBounds);
                    break;
                }
                figure.setSize(figure.getPreferredSize());
            }
        }
        if ("NAME".equals(property)) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.getViewer().getContents();
            IFigure partFigure = graphicalEditPart.getFigure();
            partFigure.getUpdateManager().performUpdate();
        }
    }

    private void handleInputChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for PROP_INPUT event");
        }
        if (newValue != null) {
            ConnectionEditPart editPart = this.createOrFindConnection(newValue);
            int modelIndex = this.getModelTargetConnections().indexOf(newValue);
            this.addTargetConnection(editPart, modelIndex);
        } else {
            List children = this.getTargetConnections();
            ConnectionEditPart partToRemove = null;
            for (ConnectionEditPart part : children) {
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeTargetConnection(partToRemove);
            }
        }
        this.getContentPane().revalidate();
    }

    private void handleOutputChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for PROP_INPUT event");
        }
        if (newValue != null) {
            ConnectionEditPart editPart = this.createOrFindConnection(newValue);
            int modelIndex = this.getModelSourceConnections().indexOf(newValue);
            this.addSourceConnection(editPart, modelIndex);
        } else {
            List children = this.getSourceConnections();
            ConnectionEditPart partToRemove = null;
            for (ConnectionEditPart part : children) {
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeSourceConnection(partToRemove);
            }
        }
        this.getContentPane().revalidate();
    }

    protected void handleChildChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (oldValue != null == (newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for PROP_CHILD event");
        }
        if (newValue != null) {
            EditPart editPart = this.createChild(newValue);
            int modelIndex = this.getModelChildren().indexOf(newValue);
            this.addChild(editPart, modelIndex);
        } else {
            List children = this.getChildren();
            EditPart partToRemove = null;
            for (EditPart part : children) {
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeChild(partToRemove);
            }
        }
    }

    protected void handleReorderChange(PropertyChangeEvent evt) {
        this.refreshChildren();
        this.refreshVisuals();
    }

    protected void commitNameChange(PropertyChangeEvent evt) {
    }

    protected void commitRefresh(PropertyChangeEvent evt) {
        this.commitNameChange(evt);
        this.refreshChildren();
        this.refreshVisuals();
    }

    public Object getAdapter(Class key) {
        if (key == IPropertySource.class) {
            Object object;
            Object model = this.getModel();
            if (model instanceof ERDObject && (object = ((ERDObject)model).getObject()) instanceof DBSObject) {
                DBECommandContext commandContext;
                if (this.isEditEnabled() && (commandContext = this.getCommandContext()) != null) {
                    PropertySourceEditable pse = new PropertySourceEditable(commandContext, object, object);
                    pse.collectProperties();
                    return new PropertySourceDelegate((DBPPropertySource)pse);
                }
                PropertyCollector propertyCollector = new PropertyCollector(object, false);
                propertyCollector.collectProperties();
                return new PropertySourceDelegate((DBPPropertySource)propertyCollector);
            }
            return null;
        }
        return super.getAdapter(key);
    }
}

