/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.editors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSession;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSessionManager;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;
import org.jkiss.utils.CommonUtils;

public class MySQLSessionEditor
extends AbstractSessionEditor {
    private static final Log log = Log.getLog(MySQLSessionEditor.class);
    private KillSessionAction killSessionAction;
    private KillSessionAction terminateQueryAction;

    public void createEditorControl(Composite parent) {
        this.killSessionAction = new KillSessionAction(false);
        this.terminateQueryAction = new KillSessionAction(true);
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        return new SessionManagerViewer<MySQLSession>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new MySQLSessionManager((MySQLDataSource)executionContext.getDataSource())){
            private boolean hideSleeping;

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)MySQLSessionEditor.this.killSessionAction);
                contributionManager.add((IAction)MySQLSessionEditor.this.terminateQueryAction);
                contributionManager.add((IContributionItem)new Separator());
                contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Hide sleeping", 2){
                    {
                        this.setToolTipText("Show only active connections");
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.HIDE_ALL_DETAILS));
                        this.setChecked(hideSleeping);
                    }

                    public void run() {
                        hideSleeping = this.isChecked();
                        MySQLSessionEditor.this.refreshPart((Object)MySQLSessionEditor.this, true);
                    }
                }, (boolean)true));
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                MySQLSessionEditor.this.killSessionAction.setEnabled(session != null);
                MySQLSessionEditor.this.terminateQueryAction.setEnabled(session != null && !CommonUtils.isEmpty((String)session.getActiveQuery()));
            }

            public Map<String, Object> getSessionOptions() {
                if (this.hideSleeping) {
                    return Collections.singletonMap("hideSleeping", true);
                }
                return super.getSessionOptions();
            }

            protected void loadSettings(IDialogSettings settings) {
                this.hideSleeping = CommonUtils.toBoolean((Object)settings.get("hideSleeping"));
                super.loadSettings(settings);
            }

            protected void saveSettings(IDialogSettings settings) {
                super.saveSettings(settings);
                settings.put("hideSleeping", this.hideSleeping);
            }
        };
    }

    private class KillSessionAction
    extends Action {
        private boolean killQuery;

        public KillSessionAction(boolean killQuery) {
            super(killQuery ? MySQLUIMessages.editors_session_editor_action_terminate_Query : MySQLUIMessages.editors_session_editor_action_kill_Session, killQuery ? UIUtils.getShardImageDescriptor((String)"IMG_ELCL_STOP") : DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_DISCONNECT));
            this.killQuery = killQuery;
        }

        public void run() {
            List sessions = MySQLSessionEditor.this.getSessionsViewer().getSelectedSessions();
            if (sessions != null && UIUtils.confirmAction((Shell)MySQLSessionEditor.this.getSite().getShell(), (String)this.getText(), (String)NLS.bind((String)MySQLUIMessages.editors_session_editor_confirm, (Object)this.getText(), (Object)sessions))) {
                MySQLSessionEditor.this.getSessionsViewer().alterSessions(sessions, Collections.singletonMap("killQuery", this.killQuery));
            }
        }
    }
}

