/***************************************************************
 * Name:      holiday.cpp
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#include "holiday.h"

Holiday::Holiday()
    : m_id(-1), m_name(wxEmptyString), m_day(0), m_month(wxDateTime::Inv_Month), m_reminded(false), m_easternMonday(false), m_easternFriday(false)
{
}

Holiday::Holiday(wxInt64 id, const wxString &name, int day, wxDateTime::Month month, int reminded, bool easternMonday, bool easternFriday)
    : m_id(id), m_name(name), m_day(day), m_month(month), m_reminded(reminded), m_easternMonday(easternMonday), m_easternFriday(easternFriday)
{
}

Holiday::~Holiday()
{
}

int Holiday::day() const
{
    return m_day;
}

void Holiday::setDay(int day)
{
    m_day = day;
}

wxDateTime::Month Holiday::month() const
{
    return m_month;
}

void Holiday::setMonth(const wxDateTime::Month &month)
{
    m_month = month;
}

wxString Holiday::name() const
{
    return m_name;
}

void Holiday::setName(const wxString &name)
{
    m_name = name;
}

int Holiday::reminded() const
{
    return m_reminded;
}

void Holiday::setReminded(int reminded)
{
    m_reminded = reminded;
}

bool Holiday::easternMonday() const
{
    return m_easternMonday;
}

void Holiday::setEasternMonday(bool easternMonday)
{
    m_easternMonday = easternMonday;
}

bool Holiday::easternFriday() const
{
    return m_easternFriday;
}

void Holiday::setEasternFriday(bool easternFriday)
{
    m_easternFriday = easternFriday;
}

wxInt64 Holiday::id() const
{
    return m_id;
}

void Holiday::setId(const wxInt64 &id)
{
    m_id = id;
}
