/***************************************************************
 * Name:      mergedialog.cpp
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#include <wx/gbsizer.h>
#include "dxdefs.h"
#include "mergedialog.h"
#include "dxutils.h"
#include "dxsettings.h"
#include "dxicons.h"

IMPLEMENT_DYNAMIC_CLASS(MergeEventsDialog, wxDialog)

BEGIN_EVENT_TABLE(MergeEventsDialog, wxDialog)
    EVT_BUTTON(wxID_OK, MergeEventsDialog::OnOk)
END_EVENT_TABLE()

MergeEventsDialog::MergeEventsDialog(wxWindow *parent)
: wxDialog(parent, wxID_ANY, _("Events"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE)
{
    m_mergeEvents = iengine->mergeEvents();

    wxBoxSizer *mainSizer = new wxBoxSizer(wxVERTICAL);

    mainSizer->Add(new wxStaticText(this, wxID_ANY, _("Loaded events")));

#if defined (__WXGTK__) || defined (__WXMAC__)
    m_mergePanel = new wxPanel(this, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN);
#else
    m_mergePanel = new wxPanel(this);
#endif
    wxBoxSizer *sizer2 = new wxBoxSizer(wxVERTICAL);
    m_mergeList = new wxListCtrl(m_mergePanel, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLC_REPORT|wxLC_HRULES|wxLC_VRULES);
    m_mergeList->InsertColumn(0, _("Event"));
    m_mergeList->SetColumnWidth(0, dxsettings.colEventWidth());
    if(dxsettings.colDateShow())
    {
        long col = m_mergeList->AppendColumn(_("Date"));
        m_mergeList->SetColumnWidth(col, dxsettings.colDateWidth());
    }
    if(dxsettings.colReminderShow())
    {
        long col = m_mergeList->AppendColumn(_("Reminder"));
        m_mergeList->SetColumnWidth(col, dxsettings.colReminderWidth());
    }
    if(dxsettings.colRecurrenceShow())
    {
        long col = m_mergeList->AppendColumn(_("Recurrence"));
        m_mergeList->SetColumnWidth(col, dxsettings.colRecurrenceWidth());
    }
    sizer2->Add(m_mergeList, 1, wxALL|wxEXPAND, 0);
    m_mergePanel->SetSizer(sizer2);
    sizer2->Fit(m_mergePanel);
    sizer2->SetSizeHints(m_mergePanel);
    mainSizer->Add(m_mergePanel, 1, wxALL|wxEXPAND, 5);

    wxStdDialogButtonSizer *btnSizer = new wxStdDialogButtonSizer();
    wxButton* okButton = new wxButton(this, wxID_OK, "", wxDefaultPosition, wxDefaultSize, 0);
    btnSizer->AddButton(okButton);
    wxButton* cancelButton = new wxButton(this, wxID_CANCEL, "", wxDefaultPosition, wxDefaultSize, 0);
    btnSizer->AddButton(cancelButton);
    btnSizer->Realize();
    mainSizer->Add(btnSizer, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 5);

    this->SetSizer(mainSizer);
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);

    fillMerge();
}

void MergeEventsDialog::OnOk(wxCommandEvent& /*event*/)
{
    bool fire = false;
    long row = 0;
    std::vector<Event>::iterator i;
    for(i = m_mergeEvents.begin(); i != m_mergeEvents.end(); ++i, row++)
    {
        if(m_mergeList->GetItemState(row, wxLIST_STATE_SELECTED) != 0)
        {
            fire = true;
            iengine->addEvent((*i));
        }
    }
    if(fire)
    {
        iengine->setLastid(-1);
        iengine->fireUpdated();
    }
    EndModal(wxID_OK);
    return;
}

void MergeEventsDialog::fillMerge()
{
    m_mergeList->DeleteAllItems();
    m_mergeList->Hide();
    long row = 0;
    std::vector<Event>::iterator i;
    for(i = m_mergeEvents.begin(); i != m_mergeEvents.end(); ++i, row++)
    {
        wxListItem item;
        item.SetId(row);
        item.SetText((*i).event());
        m_mergeList->InsertItem(item);
        int column = m_mergeList->GetColumnCount();
        if(column > 1)
        {
            if(dxsettings.colDateShow()) m_mergeList->SetItem(row, 1, dxutils::formatDateTime((*i).realEventDate(), dxsettings.dateFormat(), dxsettings.timeFormat(), dxsettings.dateLayout()));
            else
            {
                if(dxsettings.colReminderShow()) m_mergeList->SetItem(row, 1, (*i).reminderText());
                else
                {
                    m_mergeList->SetItem(row, 1, (*i).recurrenceText());
                }
            }
        }
        if(column > 2)
        {
            if(dxsettings.colReminderShow() && dxsettings.colDateShow()) m_mergeList->SetItem(row, 2, (*i).reminderText());
            else
            {
                m_mergeList->SetItem(row, 2, (*i).recurrenceText());
            }
        }
        if(column > 3)
        {
            m_mergeList->SetItem(row, 3, (*i).recurrenceText());
        }
    }
    m_mergeList->Show();
}
