#
# Copyright (c) 1990 Universities Research Association, Inc.
#       All Rights Reserved
#
#
# This material resulted from work developed under a Government Contract and
# is subject to the following license:  The Government retains a paid-up,
# nonexclusive, irrevocable worldwide license to reproduce, prepare derivative
# works, perform publicly and display publicly by or for the Government,
# including the right to distribute to other Government contractors.  Neither
# the United States nor the United States Department of Energy, nor any of
# their employees, makes any warrenty, express or implied, or assumes any
# legal liability or responsibility for the accuracy, completeness, or
# usefulness of any information, apparatus, product, or process disclosed, or
# represents that its use would not infringe privately owned rights.

# @(#) fermi.login 4.37 Delta: 96/03/26 10:54:55 Extraction 96/03/26 10:56:29 @(#)

#
# fermi.login settings for all users; called by the default .login
# Set the umask so that newly created files and directories will be readable
# by others, but writable only by the user.
#
umask 022
#
# Following put in to handle NQS
#
if ( $?ENVIRONMENT ) then
	if ( $ENVIRONMENT == "BATCH" ) exit
endif
#
# Determine terminal type
#
set term=$TERM
set ttype=`echo $TERM |cut -c1`
switch (x$term)
case x:
case xunknown:
case xarpanet:
case xnetwork:
case xnet:
case xdialup:
case xdumb:
	set term=vt100
	if ( { tty -s } ) stty erase '^?'
breaksw
default
	if ( -r /usr/lib/terminfo/$ttype/$term || -r /usr/share/lib/terminfo/$ttype/$term ) then
		switch ($term)
		case iris-ansi:	
		case iris-ansi-net:	
			if ( { tty -s } ) stty erase '^h'
		breaksw
		case sun:
		case ibm5081:
			set TTYNAME=`tty |cut -c6-`
			#space after TTYNAME is important to get unique match
			set modem=`who|grep "$TTYNAME "|grep -c modem`
			if ( "$modem" == "1" ) set term=vt100
			if ( { tty -s } ) stty erase '^?'
		breaksw
		case hp:
			if ( { tty -s } ) stty erase '^h'
			set TTYNAME=`tty |cut -c6-`
			#space after TTYNAME is important to get unique match
			set modem=`who|grep "$TTYNAME "|grep -c pty/`
			if ( "$modem" == "1" ) then
				set term=vt100
				stty erase '^?'
			endif
		breaksw
		default
			if ( { tty -s } ) stty erase '^?'
 		breaksw
		endsw
	else
		set bterm=`echo $term | cut -c1-3`
		if ( -r /usr/lib/terminfo/$ttype/$bterm || -r /usr/share/lib/terminfo/$ttype/$bterm ) then
			set term=$bterm
			if ( { tty -s } ) stty erase '^?'
		else
			switch ($MACH_OS)
			case IRIX:
			case SunOS:
			case AIX:
				switch ($bterm)
				case vt2:
				case vt3:
					set term=vt220
					if ( { tty -s } ) stty erase '^?'
				breaksw
				default
					set term=vt100
		 			if ( { tty -s } ) stty erase '^?'
				breaksw
				endsw
			breaksw
			case ULTRIX:
				switch ($bterm)
				case vt3:
					set term=vt300
					if ( { tty -s } ) stty erase '^?'
				breaksw
				case vt2:
					set term=vt200
					if ( { tty -s } ) stty erase '^?'
				breaksw
				default
					set term=vt100
		 			if ( { tty -s } ) stty erase '^?'
				breaksw
				endsw
			breaksw
			case OSF1:
				switch ($bterm)
				case vt2:
				case vt3:
					if ( { tty -s } ) stty erase '^?'
				breaksw
				default
					set term=vt100
		 			if ( { tty -s } ) stty erase '^?'
				breaksw
				endsw
			breaksw
			default
				set term=vt100
		 		if ( { tty -s } ) stty erase '^?'
			breaksw
			endsw
		endif
	endif
breaksw
endsw
#
# Set DISPLAY
#
if ( ! $?DISPLAY ) then
	set TTYPORT=`tty`
	if ( $TTYPORT == /dev/console ) then
		setenv DISPLAY "localhost:0"
	else if ( $?REMOTEHOST ) then
		setenv DISPLAY "${REMOTEHOST}:0"
	else
		set TTYNAME=`echo $TTYPORT |cut -c6-`
		#Note space after TTYNAME is important so you get a unique match
		set REMOTEHOST=`who|grep "$TTYNAME "|awk '{print $6}'|sed 's/(//'|sed 's/)//'`
		if ( x"$REMOTEHOST" != x ) then
			setenv DISPLAY "${REMOTEHOST}:0"
		endif
	endif
endif
#
# Who are you?
#
if ( $?LOGNAME ) then
	setenv LOGNAME "$LOGNAME"
else if ( $?USER ) then
	setenv LOGNAME "$USER"
else if ( $?REMOTEUSER ) then
	setenv LOGNAME "$REMOTEUSER"
endif
#
# The switch statement is to set the mail variable
# based on machine type.  Also motd and news are
# dependent on system type. Some systems automatically
# display motd (and thus shouldn't be repeated here.
# Others don't have news.
#
switch ($MACH_OS)
case IRIX:
	setenv TZ CST6CDT
	if ( `funame -r|cut -c1` == 3 ) then
		set mail=/usr/mail/$LOGNAME
		if ( { /bin/mail -e } ) then
			echo 'You have mail.'
		endif
	endif
	if ( { test -d /usr/news } ) then
 		/usr/bin/news
	endif
breaksw
case SunOS:
	setenv TZ CST6CDT
	if ( { test `echo $MACH_REL | cut -c1` -ge "5" } ) then
		setenv MAIL /usr/mail/$LOGNAME
	else
		setenv MAIL /usr/spool/mail/$LOGNAME
	endif
breaksw
case AIX:
	setenv TZ CST6CDT
	/bin/news
	setenv MAIL "/usr/spool/mail/$LOGNAME"
	setenv MAILMSG "[YOU HAVE NEW MAIL]"
	if ( { test -s $MAIL } ) then
		echo 'You have mail.'
	endif
	setenv EMULATE none
breaksw
case ULTRIX:
	set mail=/usr/spool/mail/$USER
breaksw
case OSF1:
	/usr/bin/news
	set mail=/usr/spool/mail/$USER
breaksw
case HP-UX:
	setenv TZ CST6CDT
	cat -s /etc/motd
	/usr/bin/news
	set mail=/usr/mail/$LOGNAME
	if ( { /bin/mail -e } ) then
		echo 'You have mail.'
	endif
breaksw
case "":
	#If for some reason funame -s returns NULL, as opposed to returning
	#something that isn't recognized, do nothing
breaksw
default
	cat -s /etc/motd
	if ( -x /usr/bin/news) then
		/usr/bin/news
	endif
	if ( -x /bin/news) then
		/bin/news
	endif
	if ( -d /usr/spool/mail ) then
		set mail=/usr/spool/mail
	endif
	if (	-d /usr/mail ) then
		set mail=/usr/mail/$LOGNAME
	endif
	if ( -s usr/mail/$LOGNAME ) then
#		if ( { /bin/mail -e } ) then
			echo 'You have mail.'
#		endif
	endif
breaksw
endsw
#
# Establish PAGER
#
if ( -r /usr/local/bin/less ) then
	setenv PAGER /usr/local/bin/less
else
	setenv PAGER more
endif
#
# Common terminal characteristics
#
if ( { tty -s } ) then
	stty intr '^c'	# set interrupt key to <ctrl-c>
	stty kill '^x'	# set kill key to <ctrl-x>
	stty echoe	# erase ERASEd characters
endif
echo "Terminal Type is $TERM"
/usr/local/bin/Info -new
#
# Some systems the user doesn't own his tty device ( Sun OpenWindows) so
# redirect stderr
#
/bin/chmod 622 `tty` >& /dev/null
#
# Check for existance of local.cshsrc file. This is the file admins should
# put in any changes, additions, etc. so that they don't need to re-edit this
# file every release.
#
if ( -r /usr/local/etc/local.login ) then
        source /usr/local/etc/local.login
endif

