dnl $Id: config.m4,v 1.7 2001/04/18 12:20:42 rjs Exp $

PHP_ARG_WITH(pdflib,whether to include PDFlib support,
[  --with-pdflib[=DIR]     Include PDFlib 4.x support. DIR is the PDFlib
                          base install directory, defaults to /usr/local
                          Set DIR to "shared" to build as dl, or "shared,DIR"
                          to build as dl and still specify DIR.])

  case "$PHP_PDFLIB" in
    yes)
      PHP_EXTENSION(pdf, $ext_shared)
      AC_CHECK_LIB(pdf, PDF_open_pdi, [
        AC_DEFINE(HAVE_PDFLIB,1,[ ])
      ],[
        AC_MSG_ERROR(PDFlib extension requires at least PDFlib 4.x. To build with PDFlib 3.x you should use --with-pdflib3.)
      ])
      AC_SUBST(PDFLIB_SHARED_LIBADD)
      AC_ADD_LIBRARY(pdf, PDFLIB_SHARED_LIBADD)
      ;;
    no)
      ;;
    *)
      test -f $withval/include/pdflib.h && PDFLIB_INCLUDE="$withval/include"
      if test -n "$PDFLIB_INCLUDE" ; then
        PHP_EXTENSION(pdf, $ext_shared)
        old_LIBS=$LIBS
        LIBS="$LIBS -L$withval/lib"
        AC_CHECK_LIB(pdf, PDF_open_pdi, [
          AC_DEFINE(HAVE_PDFLIB,1,[ ]) 
          PDFLIB_LIBS="$PDFLIB_LIBS -L$withval/lib -lpdf"
        ],[
          AC_MSG_ERROR(PDFlib extension requires PDFlib 4.x.)
        ])
        LIBS=$old_LIBS
        AC_SUBST(PDFLIB_SHARED_LIBADD)
        AC_ADD_LIBRARY_WITH_PATH(pdf, $withval/lib, PDFLIB_SHARED_LIBADD)
        AC_ADD_INCLUDE($PDFLIB_INCLUDE)
      fi ;;
  esac
