/*---------------------------------------------------------------------------*
 |              PDFlib - A library for generating PDF on the fly             |
 +---------------------------------------------------------------------------+
 | Copyright (c) 1997-2002 PDFlib GmbH and Thomas Merz. All rights reserved. |
 +---------------------------------------------------------------------------+
 |    This software is NOT in the public domain.  It can be used under two   |
 |    substantially different licensing terms:                               |
 |                                                                           |
 |    The commercial license is available for a fee, and allows you to       |
 |    - ship a commercial product based on PDFlib                            |
 |    - implement commercial Web services with PDFlib                        |
 |    - distribute (free or commercial) software when the source code is     |
 |      not made available                                                   |
 |    Details can be found in the file PDFlib-license.pdf.                   |
 |                                                                           |
 |    The "Aladdin Free Public License" doesn't require any license fee,     |
 |    and allows you to                                                      |
 |    - develop and distribute PDFlib-based software for which the complete  |
 |      source code is made available                                        |
 |    - redistribute PDFlib non-commercially under certain conditions        |
 |    - redistribute PDFlib on digital media for a fee if the complete       |
 |      contents of the media are freely redistributable                     |
 |    Details can be found in the file aladdin-license.pdf.                  |
 |                                                                           |
 |    These conditions extend to ports to other programming languages.       |
 |    PDFlib is distributed with no warranty of any kind. Commercial users,  |
 |    however, will receive warranty and support statements in writing.      |
 *---------------------------------------------------------------------------*/

/* $Id: p_unicode.c,v 1.9.2.3 2002/01/26 18:32:18 tm Exp $
 *
 * PDFlib routines for converting between Unicode values and Adobe glyph names
 *
 */

#include <string.h>

#include "p_intern.h"
#include "p_font.h"

/*
 * The glyph name table is based on the Adobe Glyph List (AGL) version 1.2
 * which can be found at
 * http://partners.adobe.com/asn/developer/type/glyphlist.txt
 */

typedef struct
{
    unsigned short unicode;
    const char *   aglname;
} uni_agl;

static const char glyph_A[] = "A";
static const char glyph_AE[] = "AE";
static const char glyph_AEacute[] = "AEacute";
static const char glyph_AEsmall[] = "AEsmall";
static const char glyph_Aacute[] = "Aacute";
static const char glyph_Aacutesmall[] = "Aacutesmall";
static const char glyph_Abreve[] = "Abreve";
static const char glyph_Acircumflex[] = "Acircumflex";
static const char glyph_Acircumflexsmall[] = "Acircumflexsmall";
static const char glyph_Acute[] = "Acute";
static const char glyph_Acutesmall[] = "Acutesmall";
static const char glyph_Adieresis[] = "Adieresis";
static const char glyph_Adieresissmall[] = "Adieresissmall";
static const char glyph_Agrave[] = "Agrave";
static const char glyph_Agravesmall[] = "Agravesmall";
static const char glyph_Alpha[] = "Alpha";
static const char glyph_Alphatonos[] = "Alphatonos";
static const char glyph_Amacron[] = "Amacron";
static const char glyph_Aogonek[] = "Aogonek";
static const char glyph_Aring[] = "Aring";
static const char glyph_Aringacute[] = "Aringacute";
static const char glyph_Aringsmall[] = "Aringsmall";
static const char glyph_Asmall[] = "Asmall";
static const char glyph_Atilde[] = "Atilde";
static const char glyph_Atildesmall[] = "Atildesmall";
static const char glyph_B[] = "B";
static const char glyph_Beta[] = "Beta";
static const char glyph_Brevesmall[] = "Brevesmall";
static const char glyph_Bsmall[] = "Bsmall";
static const char glyph_C[] = "C";
static const char glyph_Cacute[] = "Cacute";
static const char glyph_Caron[] = "Caron";
static const char glyph_Caronsmall[] = "Caronsmall";
static const char glyph_Ccaron[] = "Ccaron";
static const char glyph_Ccedilla[] = "Ccedilla";
static const char glyph_Ccedillasmall[] = "Ccedillasmall";
static const char glyph_Ccircumflex[] = "Ccircumflex";
static const char glyph_Cdotaccent[] = "Cdotaccent";
static const char glyph_Cedillasmall[] = "Cedillasmall";
static const char glyph_Chi[] = "Chi";
static const char glyph_Circumflexsmall[] = "Circumflexsmall";
static const char glyph_Csmall[] = "Csmall";
static const char glyph_D[] = "D";
static const char glyph_Dcaron[] = "Dcaron";
static const char glyph_Dcroat[] = "Dcroat";
static const char glyph_Delta[] = "Delta";
static const char glyph_Dieresis[] = "Dieresis";
static const char glyph_DieresisAcute[] = "DieresisAcute";
static const char glyph_DieresisGrave[] = "DieresisGrave";
static const char glyph_Dieresissmall[] = "Dieresissmall";
static const char glyph_Dotaccentsmall[] = "Dotaccentsmall";
static const char glyph_Dsmall[] = "Dsmall";
static const char glyph_E[] = "E";
static const char glyph_Eacute[] = "Eacute";
static const char glyph_Eacutesmall[] = "Eacutesmall";
static const char glyph_Ebreve[] = "Ebreve";
static const char glyph_Ecaron[] = "Ecaron";
static const char glyph_Ecircumflex[] = "Ecircumflex";
static const char glyph_Ecircumflexsmall[] = "Ecircumflexsmall";
static const char glyph_Edieresis[] = "Edieresis";
static const char glyph_Edieresissmall[] = "Edieresissmall";
static const char glyph_Edotaccent[] = "Edotaccent";
static const char glyph_Egrave[] = "Egrave";
static const char glyph_Egravesmall[] = "Egravesmall";
static const char glyph_Emacron[] = "Emacron";
static const char glyph_Eng[] = "Eng";
static const char glyph_Eogonek[] = "Eogonek";
static const char glyph_Epsilon[] = "Epsilon";
static const char glyph_Epsilontonos[] = "Epsilontonos";
static const char glyph_Esmall[] = "Esmall";
static const char glyph_Eta[] = "Eta";
static const char glyph_Etatonos[] = "Etatonos";
static const char glyph_Eth[] = "Eth";
static const char glyph_Ethsmall[] = "Ethsmall";
static const char glyph_Euro[] = "Euro";
static const char glyph_F[] = "F";
static const char glyph_Fsmall[] = "Fsmall";
static const char glyph_G[] = "G";
static const char glyph_Gamma[] = "Gamma";
static const char glyph_Gbreve[] = "Gbreve";
static const char glyph_Gcaron[] = "Gcaron";
static const char glyph_Gcircumflex[] = "Gcircumflex";
static const char glyph_Gcommaaccent[] = "Gcommaaccent";
static const char glyph_Gdotaccent[] = "Gdotaccent";
static const char glyph_Grave[] = "Grave";
static const char glyph_Gravesmall[] = "Gravesmall";
static const char glyph_Gsmall[] = "Gsmall";
static const char glyph_H[] = "H";
static const char glyph_H18533[] = "H18533";
static const char glyph_H18543[] = "H18543";
static const char glyph_H18551[] = "H18551";
static const char glyph_H22073[] = "H22073";
static const char glyph_Hbar[] = "Hbar";
static const char glyph_Hcircumflex[] = "Hcircumflex";
static const char glyph_Hsmall[] = "Hsmall";
static const char glyph_Hungarumlaut[] = "Hungarumlaut";
static const char glyph_Hungarumlautsmall[] = "Hungarumlautsmall";
static const char glyph_I[] = "I";
static const char glyph_IJ[] = "IJ";
static const char glyph_Iacute[] = "Iacute";
static const char glyph_Iacutesmall[] = "Iacutesmall";
static const char glyph_Ibreve[] = "Ibreve";
static const char glyph_Icircumflex[] = "Icircumflex";
static const char glyph_Icircumflexsmall[] = "Icircumflexsmall";
static const char glyph_Idieresis[] = "Idieresis";
static const char glyph_Idieresissmall[] = "Idieresissmall";
static const char glyph_Idotaccent[] = "Idotaccent";
static const char glyph_Ifraktur[] = "Ifraktur";
static const char glyph_Igrave[] = "Igrave";
static const char glyph_Igravesmall[] = "Igravesmall";
static const char glyph_Imacron[] = "Imacron";
static const char glyph_Iogonek[] = "Iogonek";
static const char glyph_Iota[] = "Iota";
static const char glyph_Iotadieresis[] = "Iotadieresis";
static const char glyph_Iotatonos[] = "Iotatonos";
static const char glyph_Ismall[] = "Ismall";
static const char glyph_Itilde[] = "Itilde";
static const char glyph_J[] = "J";
static const char glyph_Jcircumflex[] = "Jcircumflex";
static const char glyph_Jsmall[] = "Jsmall";
static const char glyph_K[] = "K";
static const char glyph_Kappa[] = "Kappa";
static const char glyph_Kcommaaccent[] = "Kcommaaccent";
static const char glyph_Ksmall[] = "Ksmall";
static const char glyph_L[] = "L";
static const char glyph_LL[] = "LL";
static const char glyph_Lacute[] = "Lacute";
static const char glyph_Lambda[] = "Lambda";
static const char glyph_Lcaron[] = "Lcaron";
static const char glyph_Lcommaaccent[] = "Lcommaaccent";
static const char glyph_Ldot[] = "Ldot";
static const char glyph_Lslash[] = "Lslash";
static const char glyph_Lslashsmall[] = "Lslashsmall";
static const char glyph_Lsmall[] = "Lsmall";
static const char glyph_M[] = "M";
static const char glyph_Macron[] = "Macron";
static const char glyph_Macronsmall[] = "Macronsmall";
static const char glyph_Msmall[] = "Msmall";
static const char glyph_Mu[] = "Mu";
static const char glyph_N[] = "N";
static const char glyph_Nacute[] = "Nacute";
static const char glyph_Ncaron[] = "Ncaron";
static const char glyph_Ncommaaccent[] = "Ncommaaccent";
static const char glyph_Nsmall[] = "Nsmall";
static const char glyph_Ntilde[] = "Ntilde";
static const char glyph_Ntildesmall[] = "Ntildesmall";
static const char glyph_Nu[] = "Nu";
static const char glyph_O[] = "O";
static const char glyph_OE[] = "OE";
static const char glyph_OEsmall[] = "OEsmall";
static const char glyph_Oacute[] = "Oacute";
static const char glyph_Oacutesmall[] = "Oacutesmall";
static const char glyph_Obreve[] = "Obreve";
static const char glyph_Ocircumflex[] = "Ocircumflex";
static const char glyph_Ocircumflexsmall[] = "Ocircumflexsmall";
static const char glyph_Odieresis[] = "Odieresis";
static const char glyph_Odieresissmall[] = "Odieresissmall";
static const char glyph_Ogoneksmall[] = "Ogoneksmall";
static const char glyph_Ograve[] = "Ograve";
static const char glyph_Ogravesmall[] = "Ogravesmall";
static const char glyph_Ohorn[] = "Ohorn";
static const char glyph_Ohungarumlaut[] = "Ohungarumlaut";
static const char glyph_Omacron[] = "Omacron";
static const char glyph_Omega[] = "Omega";
static const char glyph_Omegatonos[] = "Omegatonos";
static const char glyph_Omicron[] = "Omicron";
static const char glyph_Omicrontonos[] = "Omicrontonos";
static const char glyph_Oslash[] = "Oslash";
static const char glyph_Oslashacute[] = "Oslashacute";
static const char glyph_Oslashsmall[] = "Oslashsmall";
static const char glyph_Osmall[] = "Osmall";
static const char glyph_Otilde[] = "Otilde";
static const char glyph_Otildesmall[] = "Otildesmall";
static const char glyph_P[] = "P";
static const char glyph_Phi[] = "Phi";
static const char glyph_Pi[] = "Pi";
static const char glyph_Psi[] = "Psi";
static const char glyph_Psmall[] = "Psmall";
static const char glyph_Q[] = "Q";
static const char glyph_Qsmall[] = "Qsmall";
static const char glyph_R[] = "R";
static const char glyph_Racute[] = "Racute";
static const char glyph_Rcaron[] = "Rcaron";
static const char glyph_Rcommaaccent[] = "Rcommaaccent";
static const char glyph_Rfraktur[] = "Rfraktur";
static const char glyph_Rho[] = "Rho";
static const char glyph_Ringsmall[] = "Ringsmall";
static const char glyph_Rsmall[] = "Rsmall";
static const char glyph_S[] = "S";
static const char glyph_SF010000[] = "SF010000";
static const char glyph_SF020000[] = "SF020000";
static const char glyph_SF030000[] = "SF030000";
static const char glyph_SF040000[] = "SF040000";
static const char glyph_SF050000[] = "SF050000";
static const char glyph_SF060000[] = "SF060000";
static const char glyph_SF070000[] = "SF070000";
static const char glyph_SF080000[] = "SF080000";
static const char glyph_SF090000[] = "SF090000";
static const char glyph_SF100000[] = "SF100000";
static const char glyph_SF110000[] = "SF110000";
static const char glyph_SF190000[] = "SF190000";
static const char glyph_SF200000[] = "SF200000";
static const char glyph_SF210000[] = "SF210000";
static const char glyph_SF220000[] = "SF220000";
static const char glyph_SF230000[] = "SF230000";
static const char glyph_SF240000[] = "SF240000";
static const char glyph_SF250000[] = "SF250000";
static const char glyph_SF260000[] = "SF260000";
static const char glyph_SF270000[] = "SF270000";
static const char glyph_SF280000[] = "SF280000";
static const char glyph_SF360000[] = "SF360000";
static const char glyph_SF370000[] = "SF370000";
static const char glyph_SF380000[] = "SF380000";
static const char glyph_SF390000[] = "SF390000";
static const char glyph_SF400000[] = "SF400000";
static const char glyph_SF410000[] = "SF410000";
static const char glyph_SF420000[] = "SF420000";
static const char glyph_SF430000[] = "SF430000";
static const char glyph_SF440000[] = "SF440000";
static const char glyph_SF450000[] = "SF450000";
static const char glyph_SF460000[] = "SF460000";
static const char glyph_SF470000[] = "SF470000";
static const char glyph_SF480000[] = "SF480000";
static const char glyph_SF490000[] = "SF490000";
static const char glyph_SF500000[] = "SF500000";
static const char glyph_SF510000[] = "SF510000";
static const char glyph_SF520000[] = "SF520000";
static const char glyph_SF530000[] = "SF530000";
static const char glyph_SF540000[] = "SF540000";
static const char glyph_Sacute[] = "Sacute";
static const char glyph_Scaron[] = "Scaron";
static const char glyph_Scaronsmall[] = "Scaronsmall";
static const char glyph_Scedilla[] = "Scedilla";
static const char glyph_Scircumflex[] = "Scircumflex";
static const char glyph_Scommaaccent[] = "Scommaaccent";
static const char glyph_Sigma[] = "Sigma";
static const char glyph_Ssmall[] = "Ssmall";
static const char glyph_T[] = "T";
static const char glyph_Tau[] = "Tau";
static const char glyph_Tbar[] = "Tbar";
static const char glyph_Tcaron[] = "Tcaron";
static const char glyph_Tcommaaccent[] = "Tcommaaccent";
static const char glyph_Theta[] = "Theta";
static const char glyph_Thorn[] = "Thorn";
static const char glyph_Thornsmall[] = "Thornsmall";
static const char glyph_Tildesmall[] = "Tildesmall";
static const char glyph_Tsmall[] = "Tsmall";
static const char glyph_U[] = "U";
static const char glyph_Uacute[] = "Uacute";
static const char glyph_Uacutesmall[] = "Uacutesmall";
static const char glyph_Ubreve[] = "Ubreve";
static const char glyph_Ucircumflex[] = "Ucircumflex";
static const char glyph_Ucircumflexsmall[] = "Ucircumflexsmall";
static const char glyph_Udieresis[] = "Udieresis";
static const char glyph_Udieresissmall[] = "Udieresissmall";
static const char glyph_Ugrave[] = "Ugrave";
static const char glyph_Ugravesmall[] = "Ugravesmall";
static const char glyph_Uhorn[] = "Uhorn";
static const char glyph_Uhungarumlaut[] = "Uhungarumlaut";
static const char glyph_Umacron[] = "Umacron";
static const char glyph_Uogonek[] = "Uogonek";
static const char glyph_Upsilon[] = "Upsilon";
static const char glyph_Upsilon1[] = "Upsilon1";
static const char glyph_Upsilondieresis[] = "Upsilondieresis";
static const char glyph_Upsilontonos[] = "Upsilontonos";
static const char glyph_Uring[] = "Uring";
static const char glyph_Usmall[] = "Usmall";
static const char glyph_Utilde[] = "Utilde";
static const char glyph_V[] = "V";
static const char glyph_Vsmall[] = "Vsmall";
static const char glyph_W[] = "W";
static const char glyph_Wacute[] = "Wacute";
static const char glyph_Wcircumflex[] = "Wcircumflex";
static const char glyph_Wdieresis[] = "Wdieresis";
static const char glyph_Wgrave[] = "Wgrave";
static const char glyph_Wsmall[] = "Wsmall";
static const char glyph_X[] = "X";
static const char glyph_Xi[] = "Xi";
static const char glyph_Xsmall[] = "Xsmall";
static const char glyph_Y[] = "Y";
static const char glyph_Yacute[] = "Yacute";
static const char glyph_Yacutesmall[] = "Yacutesmall";
static const char glyph_Ycircumflex[] = "Ycircumflex";
static const char glyph_Ydieresis[] = "Ydieresis";
static const char glyph_Ydieresissmall[] = "Ydieresissmall";
static const char glyph_Ygrave[] = "Ygrave";
static const char glyph_Ysmall[] = "Ysmall";
static const char glyph_Z[] = "Z";
static const char glyph_Zacute[] = "Zacute";
static const char glyph_Zcaron[] = "Zcaron";
static const char glyph_Zcaronsmall[] = "Zcaronsmall";
static const char glyph_Zdotaccent[] = "Zdotaccent";
static const char glyph_Zeta[] = "Zeta";
static const char glyph_Zsmall[] = "Zsmall";
static const char glyph_a[] = "a";
static const char glyph_aacute[] = "aacute";
static const char glyph_abreve[] = "abreve";
static const char glyph_acircumflex[] = "acircumflex";
static const char glyph_acute[] = "acute";
static const char glyph_acutecomb[] = "acutecomb";
static const char glyph_adieresis[] = "adieresis";
static const char glyph_ae[] = "ae";
static const char glyph_aeacute[] = "aeacute";
static const char glyph_afii00208[] = "afii00208";
static const char glyph_afii10017[] = "afii10017";
static const char glyph_afii10018[] = "afii10018";
static const char glyph_afii10019[] = "afii10019";
static const char glyph_afii10020[] = "afii10020";
static const char glyph_afii10021[] = "afii10021";
static const char glyph_afii10022[] = "afii10022";
static const char glyph_afii10023[] = "afii10023";
static const char glyph_afii10024[] = "afii10024";
static const char glyph_afii10025[] = "afii10025";
static const char glyph_afii10026[] = "afii10026";
static const char glyph_afii10027[] = "afii10027";
static const char glyph_afii10028[] = "afii10028";
static const char glyph_afii10029[] = "afii10029";
static const char glyph_afii10030[] = "afii10030";
static const char glyph_afii10031[] = "afii10031";
static const char glyph_afii10032[] = "afii10032";
static const char glyph_afii10033[] = "afii10033";
static const char glyph_afii10034[] = "afii10034";
static const char glyph_afii10035[] = "afii10035";
static const char glyph_afii10036[] = "afii10036";
static const char glyph_afii10037[] = "afii10037";
static const char glyph_afii10038[] = "afii10038";
static const char glyph_afii10039[] = "afii10039";
static const char glyph_afii10040[] = "afii10040";
static const char glyph_afii10041[] = "afii10041";
static const char glyph_afii10042[] = "afii10042";
static const char glyph_afii10043[] = "afii10043";
static const char glyph_afii10044[] = "afii10044";
static const char glyph_afii10045[] = "afii10045";
static const char glyph_afii10046[] = "afii10046";
static const char glyph_afii10047[] = "afii10047";
static const char glyph_afii10048[] = "afii10048";
static const char glyph_afii10049[] = "afii10049";
static const char glyph_afii10050[] = "afii10050";
static const char glyph_afii10051[] = "afii10051";
static const char glyph_afii10052[] = "afii10052";
static const char glyph_afii10053[] = "afii10053";
static const char glyph_afii10054[] = "afii10054";
static const char glyph_afii10055[] = "afii10055";
static const char glyph_afii10056[] = "afii10056";
static const char glyph_afii10057[] = "afii10057";
static const char glyph_afii10058[] = "afii10058";
static const char glyph_afii10059[] = "afii10059";
static const char glyph_afii10060[] = "afii10060";
static const char glyph_afii10061[] = "afii10061";
static const char glyph_afii10062[] = "afii10062";
static const char glyph_afii10063[] = "afii10063";
static const char glyph_afii10064[] = "afii10064";
static const char glyph_afii10065[] = "afii10065";
static const char glyph_afii10066[] = "afii10066";
static const char glyph_afii10067[] = "afii10067";
static const char glyph_afii10068[] = "afii10068";
static const char glyph_afii10069[] = "afii10069";
static const char glyph_afii10070[] = "afii10070";
static const char glyph_afii10071[] = "afii10071";
static const char glyph_afii10072[] = "afii10072";
static const char glyph_afii10073[] = "afii10073";
static const char glyph_afii10074[] = "afii10074";
static const char glyph_afii10075[] = "afii10075";
static const char glyph_afii10076[] = "afii10076";
static const char glyph_afii10077[] = "afii10077";
static const char glyph_afii10078[] = "afii10078";
static const char glyph_afii10079[] = "afii10079";
static const char glyph_afii10080[] = "afii10080";
static const char glyph_afii10081[] = "afii10081";
static const char glyph_afii10082[] = "afii10082";
static const char glyph_afii10083[] = "afii10083";
static const char glyph_afii10084[] = "afii10084";
static const char glyph_afii10085[] = "afii10085";
static const char glyph_afii10086[] = "afii10086";
static const char glyph_afii10087[] = "afii10087";
static const char glyph_afii10088[] = "afii10088";
static const char glyph_afii10089[] = "afii10089";
static const char glyph_afii10090[] = "afii10090";
static const char glyph_afii10091[] = "afii10091";
static const char glyph_afii10092[] = "afii10092";
static const char glyph_afii10093[] = "afii10093";
static const char glyph_afii10094[] = "afii10094";
static const char glyph_afii10095[] = "afii10095";
static const char glyph_afii10096[] = "afii10096";
static const char glyph_afii10097[] = "afii10097";
static const char glyph_afii10098[] = "afii10098";
static const char glyph_afii10099[] = "afii10099";
static const char glyph_afii10100[] = "afii10100";
static const char glyph_afii10101[] = "afii10101";
static const char glyph_afii10102[] = "afii10102";
static const char glyph_afii10103[] = "afii10103";
static const char glyph_afii10104[] = "afii10104";
static const char glyph_afii10105[] = "afii10105";
static const char glyph_afii10106[] = "afii10106";
static const char glyph_afii10107[] = "afii10107";
static const char glyph_afii10108[] = "afii10108";
static const char glyph_afii10109[] = "afii10109";
static const char glyph_afii10110[] = "afii10110";
static const char glyph_afii10145[] = "afii10145";
static const char glyph_afii10146[] = "afii10146";
static const char glyph_afii10147[] = "afii10147";
static const char glyph_afii10148[] = "afii10148";
static const char glyph_afii10192[] = "afii10192";
static const char glyph_afii10193[] = "afii10193";
static const char glyph_afii10194[] = "afii10194";
static const char glyph_afii10195[] = "afii10195";
static const char glyph_afii10196[] = "afii10196";
static const char glyph_afii10831[] = "afii10831";
static const char glyph_afii10832[] = "afii10832";
static const char glyph_afii10846[] = "afii10846";
static const char glyph_afii299[] = "afii299";
static const char glyph_afii300[] = "afii300";
static const char glyph_afii301[] = "afii301";
static const char glyph_afii57381[] = "afii57381";
static const char glyph_afii57388[] = "afii57388";
static const char glyph_afii57392[] = "afii57392";
static const char glyph_afii57393[] = "afii57393";
static const char glyph_afii57394[] = "afii57394";
static const char glyph_afii57395[] = "afii57395";
static const char glyph_afii57396[] = "afii57396";
static const char glyph_afii57397[] = "afii57397";
static const char glyph_afii57398[] = "afii57398";
static const char glyph_afii57399[] = "afii57399";
static const char glyph_afii57400[] = "afii57400";
static const char glyph_afii57401[] = "afii57401";
static const char glyph_afii57403[] = "afii57403";
static const char glyph_afii57407[] = "afii57407";
static const char glyph_afii57409[] = "afii57409";
static const char glyph_afii57410[] = "afii57410";
static const char glyph_afii57411[] = "afii57411";
static const char glyph_afii57412[] = "afii57412";
static const char glyph_afii57413[] = "afii57413";
static const char glyph_afii57414[] = "afii57414";
static const char glyph_afii57415[] = "afii57415";
static const char glyph_afii57416[] = "afii57416";
static const char glyph_afii57417[] = "afii57417";
static const char glyph_afii57418[] = "afii57418";
static const char glyph_afii57419[] = "afii57419";
static const char glyph_afii57420[] = "afii57420";
static const char glyph_afii57421[] = "afii57421";
static const char glyph_afii57422[] = "afii57422";
static const char glyph_afii57423[] = "afii57423";
static const char glyph_afii57424[] = "afii57424";
static const char glyph_afii57425[] = "afii57425";
static const char glyph_afii57426[] = "afii57426";
static const char glyph_afii57427[] = "afii57427";
static const char glyph_afii57428[] = "afii57428";
static const char glyph_afii57429[] = "afii57429";
static const char glyph_afii57430[] = "afii57430";
static const char glyph_afii57431[] = "afii57431";
static const char glyph_afii57432[] = "afii57432";
static const char glyph_afii57433[] = "afii57433";
static const char glyph_afii57434[] = "afii57434";
static const char glyph_afii57440[] = "afii57440";
static const char glyph_afii57441[] = "afii57441";
static const char glyph_afii57442[] = "afii57442";
static const char glyph_afii57443[] = "afii57443";
static const char glyph_afii57444[] = "afii57444";
static const char glyph_afii57445[] = "afii57445";
static const char glyph_afii57446[] = "afii57446";
static const char glyph_afii57448[] = "afii57448";
static const char glyph_afii57449[] = "afii57449";
static const char glyph_afii57450[] = "afii57450";
static const char glyph_afii57451[] = "afii57451";
static const char glyph_afii57452[] = "afii57452";
static const char glyph_afii57453[] = "afii57453";
static const char glyph_afii57454[] = "afii57454";
static const char glyph_afii57455[] = "afii57455";
static const char glyph_afii57456[] = "afii57456";
static const char glyph_afii57457[] = "afii57457";
static const char glyph_afii57458[] = "afii57458";
static const char glyph_afii57470[] = "afii57470";
static const char glyph_afii57505[] = "afii57505";
static const char glyph_afii57506[] = "afii57506";
static const char glyph_afii57507[] = "afii57507";
static const char glyph_afii57508[] = "afii57508";
static const char glyph_afii57509[] = "afii57509";
static const char glyph_afii57511[] = "afii57511";
static const char glyph_afii57512[] = "afii57512";
static const char glyph_afii57513[] = "afii57513";
static const char glyph_afii57514[] = "afii57514";
static const char glyph_afii57519[] = "afii57519";
static const char glyph_afii57534[] = "afii57534";
static const char glyph_afii57636[] = "afii57636";
static const char glyph_afii57645[] = "afii57645";
static const char glyph_afii57658[] = "afii57658";
static const char glyph_afii57664[] = "afii57664";
static const char glyph_afii57665[] = "afii57665";
static const char glyph_afii57666[] = "afii57666";
static const char glyph_afii57667[] = "afii57667";
static const char glyph_afii57668[] = "afii57668";
static const char glyph_afii57669[] = "afii57669";
static const char glyph_afii57670[] = "afii57670";
static const char glyph_afii57671[] = "afii57671";
static const char glyph_afii57672[] = "afii57672";
static const char glyph_afii57673[] = "afii57673";
static const char glyph_afii57674[] = "afii57674";
static const char glyph_afii57675[] = "afii57675";
static const char glyph_afii57676[] = "afii57676";
static const char glyph_afii57677[] = "afii57677";
static const char glyph_afii57678[] = "afii57678";
static const char glyph_afii57679[] = "afii57679";
static const char glyph_afii57680[] = "afii57680";
static const char glyph_afii57681[] = "afii57681";
static const char glyph_afii57682[] = "afii57682";
static const char glyph_afii57683[] = "afii57683";
static const char glyph_afii57684[] = "afii57684";
static const char glyph_afii57685[] = "afii57685";
static const char glyph_afii57686[] = "afii57686";
static const char glyph_afii57687[] = "afii57687";
static const char glyph_afii57688[] = "afii57688";
static const char glyph_afii57689[] = "afii57689";
static const char glyph_afii57690[] = "afii57690";
static const char glyph_afii57694[] = "afii57694";
static const char glyph_afii57695[] = "afii57695";
static const char glyph_afii57700[] = "afii57700";
static const char glyph_afii57705[] = "afii57705";
static const char glyph_afii57716[] = "afii57716";
static const char glyph_afii57717[] = "afii57717";
static const char glyph_afii57718[] = "afii57718";
static const char glyph_afii57723[] = "afii57723";
static const char glyph_afii57793[] = "afii57793";
static const char glyph_afii57794[] = "afii57794";
static const char glyph_afii57795[] = "afii57795";
static const char glyph_afii57796[] = "afii57796";
static const char glyph_afii57797[] = "afii57797";
static const char glyph_afii57798[] = "afii57798";
static const char glyph_afii57799[] = "afii57799";
static const char glyph_afii57800[] = "afii57800";
static const char glyph_afii57801[] = "afii57801";
static const char glyph_afii57802[] = "afii57802";
static const char glyph_afii57803[] = "afii57803";
static const char glyph_afii57804[] = "afii57804";
static const char glyph_afii57806[] = "afii57806";
static const char glyph_afii57807[] = "afii57807";
static const char glyph_afii57839[] = "afii57839";
static const char glyph_afii57841[] = "afii57841";
static const char glyph_afii57842[] = "afii57842";
static const char glyph_afii57929[] = "afii57929";
static const char glyph_afii61248[] = "afii61248";
static const char glyph_afii61289[] = "afii61289";
static const char glyph_afii61352[] = "afii61352";
static const char glyph_afii61573[] = "afii61573";
static const char glyph_afii61574[] = "afii61574";
static const char glyph_afii61575[] = "afii61575";
static const char glyph_afii61664[] = "afii61664";
static const char glyph_afii63167[] = "afii63167";
static const char glyph_afii64937[] = "afii64937";
static const char glyph_agrave[] = "agrave";
static const char glyph_aleph[] = "aleph";
static const char glyph_alpha[] = "alpha";
static const char glyph_alphatonos[] = "alphatonos";
static const char glyph_amacron[] = "amacron";
static const char glyph_ampersand[] = "ampersand";
static const char glyph_ampersandsmall[] = "ampersandsmall";
static const char glyph_angle[] = "angle";
static const char glyph_angleleft[] = "angleleft";
static const char glyph_angleright[] = "angleright";
static const char glyph_anoteleia[] = "anoteleia";
static const char glyph_aogonek[] = "aogonek";
static const char glyph_approxequal[] = "approxequal";
static const char glyph_aring[] = "aring";
static const char glyph_aringacute[] = "aringacute";
static const char glyph_arrowboth[] = "arrowboth";
static const char glyph_arrowdblboth[] = "arrowdblboth";
static const char glyph_arrowdbldown[] = "arrowdbldown";
static const char glyph_arrowdblleft[] = "arrowdblleft";
static const char glyph_arrowdblright[] = "arrowdblright";
static const char glyph_arrowdblup[] = "arrowdblup";
static const char glyph_arrowdown[] = "arrowdown";
static const char glyph_arrowhorizex[] = "arrowhorizex";
static const char glyph_arrowleft[] = "arrowleft";
static const char glyph_arrowright[] = "arrowright";
static const char glyph_arrowup[] = "arrowup";
static const char glyph_arrowupdn[] = "arrowupdn";
static const char glyph_arrowupdnbse[] = "arrowupdnbse";
static const char glyph_arrowvertex[] = "arrowvertex";
static const char glyph_asciicircum[] = "asciicircum";
static const char glyph_asciitilde[] = "asciitilde";
static const char glyph_asterisk[] = "asterisk";
static const char glyph_asteriskmath[] = "asteriskmath";
static const char glyph_asuperior[] = "asuperior";
static const char glyph_at[] = "at";
static const char glyph_atilde[] = "atilde";
static const char glyph_b[] = "b";
static const char glyph_backslash[] = "backslash";
static const char glyph_bar[] = "bar";
static const char glyph_beta[] = "beta";
static const char glyph_block[] = "block";
static const char glyph_braceex[] = "braceex";
static const char glyph_braceleft[] = "braceleft";
static const char glyph_braceleftbt[] = "braceleftbt";
static const char glyph_braceleftmid[] = "braceleftmid";
static const char glyph_bracelefttp[] = "bracelefttp";
static const char glyph_braceright[] = "braceright";
static const char glyph_bracerightbt[] = "bracerightbt";
static const char glyph_bracerightmid[] = "bracerightmid";
static const char glyph_bracerighttp[] = "bracerighttp";
static const char glyph_bracketleft[] = "bracketleft";
static const char glyph_bracketleftbt[] = "bracketleftbt";
static const char glyph_bracketleftex[] = "bracketleftex";
static const char glyph_bracketlefttp[] = "bracketlefttp";
static const char glyph_bracketright[] = "bracketright";
static const char glyph_bracketrightbt[] = "bracketrightbt";
static const char glyph_bracketrightex[] = "bracketrightex";
static const char glyph_bracketrighttp[] = "bracketrighttp";
static const char glyph_breve[] = "breve";
static const char glyph_brokenbar[] = "brokenbar";
static const char glyph_bsuperior[] = "bsuperior";
static const char glyph_bullet[] = "bullet";
static const char glyph_c[] = "c";
static const char glyph_cacute[] = "cacute";
static const char glyph_caron[] = "caron";
static const char glyph_carriagereturn[] = "carriagereturn";
static const char glyph_ccaron[] = "ccaron";
static const char glyph_ccedilla[] = "ccedilla";
static const char glyph_ccircumflex[] = "ccircumflex";
static const char glyph_cdotaccent[] = "cdotaccent";
static const char glyph_cedilla[] = "cedilla";
static const char glyph_cent[] = "cent";
static const char glyph_centinferior[] = "centinferior";
static const char glyph_centoldstyle[] = "centoldstyle";
static const char glyph_centsuperior[] = "centsuperior";
static const char glyph_chi[] = "chi";
static const char glyph_circle[] = "circle";
static const char glyph_circlemultiply[] = "circlemultiply";
static const char glyph_circleplus[] = "circleplus";
static const char glyph_circumflex[] = "circumflex";
static const char glyph_club[] = "club";
static const char glyph_colon[] = "colon";
static const char glyph_colonmonetary[] = "colonmonetary";
static const char glyph_comma[] = "comma";
static const char glyph_commaaccent[] = "commaaccent";
static const char glyph_commainferior[] = "commainferior";
static const char glyph_commasuperior[] = "commasuperior";
static const char glyph_congruent[] = "congruent";
static const char glyph_copyright[] = "copyright";
static const char glyph_copyrightsans[] = "copyrightsans";
static const char glyph_copyrightserif[] = "copyrightserif";
static const char glyph_currency[] = "currency";
static const char glyph_cyrBreve[] = "cyrBreve";
static const char glyph_cyrFlex[] = "cyrFlex";
static const char glyph_cyrbreve[] = "cyrbreve";
static const char glyph_cyrflex[] = "cyrflex";
static const char glyph_d[] = "d";
static const char glyph_dagger[] = "dagger";
static const char glyph_daggerdbl[] = "daggerdbl";
static const char glyph_dblGrave[] = "dblGrave";
static const char glyph_dblgrave[] = "dblgrave";
static const char glyph_dcaron[] = "dcaron";
static const char glyph_dcroat[] = "dcroat";
static const char glyph_degree[] = "degree";
static const char glyph_delta[] = "delta";
static const char glyph_diamond[] = "diamond";
static const char glyph_dieresis[] = "dieresis";
static const char glyph_dieresisacute[] = "dieresisacute";
static const char glyph_dieresisgrave[] = "dieresisgrave";
static const char glyph_dieresistonos[] = "dieresistonos";
static const char glyph_divide[] = "divide";
static const char glyph_dkshade[] = "dkshade";
static const char glyph_dnblock[] = "dnblock";
static const char glyph_dollar[] = "dollar";
static const char glyph_dollarinferior[] = "dollarinferior";
static const char glyph_dollaroldstyle[] = "dollaroldstyle";
static const char glyph_dollarsuperior[] = "dollarsuperior";
static const char glyph_dong[] = "dong";
static const char glyph_dotaccent[] = "dotaccent";
static const char glyph_dotbelowcomb[] = "dotbelowcomb";
static const char glyph_dotlessi[] = "dotlessi";
static const char glyph_dotlessj[] = "dotlessj";
static const char glyph_dotmath[] = "dotmath";
static const char glyph_dsuperior[] = "dsuperior";
static const char glyph_e[] = "e";
static const char glyph_eacute[] = "eacute";
static const char glyph_ebreve[] = "ebreve";
static const char glyph_ecaron[] = "ecaron";
static const char glyph_ecircumflex[] = "ecircumflex";
static const char glyph_edieresis[] = "edieresis";
static const char glyph_edotaccent[] = "edotaccent";
static const char glyph_egrave[] = "egrave";
static const char glyph_eight[] = "eight";
static const char glyph_eightinferior[] = "eightinferior";
static const char glyph_eightoldstyle[] = "eightoldstyle";
static const char glyph_eightsuperior[] = "eightsuperior";
static const char glyph_element[] = "element";
static const char glyph_ellipsis[] = "ellipsis";
static const char glyph_emacron[] = "emacron";
static const char glyph_emdash[] = "emdash";
static const char glyph_emptyset[] = "emptyset";
static const char glyph_endash[] = "endash";
static const char glyph_eng[] = "eng";
static const char glyph_eogonek[] = "eogonek";
static const char glyph_epsilon[] = "epsilon";
static const char glyph_epsilontonos[] = "epsilontonos";
static const char glyph_equal[] = "equal";
static const char glyph_equivalence[] = "equivalence";
static const char glyph_estimated[] = "estimated";
static const char glyph_esuperior[] = "esuperior";
static const char glyph_eta[] = "eta";
static const char glyph_etatonos[] = "etatonos";
static const char glyph_eth[] = "eth";
static const char glyph_exclam[] = "exclam";
static const char glyph_exclamdbl[] = "exclamdbl";
static const char glyph_exclamdown[] = "exclamdown";
static const char glyph_exclamdownsmall[] = "exclamdownsmall";
static const char glyph_exclamsmall[] = "exclamsmall";
static const char glyph_existential[] = "existential";
static const char glyph_f[] = "f";
static const char glyph_female[] = "female";
static const char glyph_ff[] = "ff";
static const char glyph_ffi[] = "ffi";
static const char glyph_ffl[] = "ffl";
static const char glyph_fi[] = "fi";
static const char glyph_figuredash[] = "figuredash";
static const char glyph_filledbox[] = "filledbox";
static const char glyph_filledrect[] = "filledrect";
static const char glyph_five[] = "five";
static const char glyph_fiveeighths[] = "fiveeighths";
static const char glyph_fiveinferior[] = "fiveinferior";
static const char glyph_fiveoldstyle[] = "fiveoldstyle";
static const char glyph_fivesuperior[] = "fivesuperior";
static const char glyph_fl[] = "fl";
static const char glyph_florin[] = "florin";
static const char glyph_four[] = "four";
static const char glyph_fourinferior[] = "fourinferior";
static const char glyph_fouroldstyle[] = "fouroldstyle";
static const char glyph_foursuperior[] = "foursuperior";
static const char glyph_fraction[] = "fraction";
static const char glyph_franc[] = "franc";
static const char glyph_g[] = "g";
static const char glyph_gamma[] = "gamma";
static const char glyph_gbreve[] = "gbreve";
static const char glyph_gcaron[] = "gcaron";
static const char glyph_gcircumflex[] = "gcircumflex";
static const char glyph_gcommaaccent[] = "gcommaaccent";
static const char glyph_gdotaccent[] = "gdotaccent";
static const char glyph_germandbls[] = "germandbls";
static const char glyph_gradient[] = "gradient";
static const char glyph_grave[] = "grave";
static const char glyph_gravecomb[] = "gravecomb";
static const char glyph_greater[] = "greater";
static const char glyph_greaterequal[] = "greaterequal";
static const char glyph_guillemotleft[] = "guillemotleft";
static const char glyph_guillemotright[] = "guillemotright";
static const char glyph_guilsinglleft[] = "guilsinglleft";
static const char glyph_guilsinglright[] = "guilsinglright";
static const char glyph_h[] = "h";
static const char glyph_hbar[] = "hbar";
static const char glyph_hcircumflex[] = "hcircumflex";
static const char glyph_heart[] = "heart";
static const char glyph_hookabovecomb[] = "hookabovecomb";
static const char glyph_house[] = "house";
static const char glyph_hungarumlaut[] = "hungarumlaut";
static const char glyph_hyphen[] = "hyphen";
static const char glyph_hypheninferior[] = "hypheninferior";
static const char glyph_hyphensuperior[] = "hyphensuperior";
static const char glyph_i[] = "i";
static const char glyph_iacute[] = "iacute";
static const char glyph_ibreve[] = "ibreve";
static const char glyph_icircumflex[] = "icircumflex";
static const char glyph_idieresis[] = "idieresis";
static const char glyph_igrave[] = "igrave";
static const char glyph_ij[] = "ij";
static const char glyph_imacron[] = "imacron";
static const char glyph_infinity[] = "infinity";
static const char glyph_integral[] = "integral";
static const char glyph_integralbt[] = "integralbt";
static const char glyph_integralex[] = "integralex";
static const char glyph_integraltp[] = "integraltp";
static const char glyph_intersection[] = "intersection";
static const char glyph_invbullet[] = "invbullet";
static const char glyph_invcircle[] = "invcircle";
static const char glyph_invsmileface[] = "invsmileface";
static const char glyph_iogonek[] = "iogonek";
static const char glyph_iota[] = "iota";
static const char glyph_iotadieresis[] = "iotadieresis";
static const char glyph_iotadieresistonos[] = "iotadieresistonos";
static const char glyph_iotatonos[] = "iotatonos";
static const char glyph_isuperior[] = "isuperior";
static const char glyph_itilde[] = "itilde";
static const char glyph_j[] = "j";
static const char glyph_jcircumflex[] = "jcircumflex";
static const char glyph_k[] = "k";
static const char glyph_kappa[] = "kappa";
static const char glyph_kcommaaccent[] = "kcommaaccent";
static const char glyph_kgreenlandic[] = "kgreenlandic";
static const char glyph_l[] = "l";
static const char glyph_lacute[] = "lacute";
static const char glyph_lambda[] = "lambda";
static const char glyph_lcaron[] = "lcaron";
static const char glyph_lcommaaccent[] = "lcommaaccent";
static const char glyph_ldot[] = "ldot";
static const char glyph_less[] = "less";
static const char glyph_lessequal[] = "lessequal";
static const char glyph_lfblock[] = "lfblock";
static const char glyph_lira[] = "lira";
static const char glyph_ll[] = "ll";
static const char glyph_logicaland[] = "logicaland";
static const char glyph_logicalnot[] = "logicalnot";
static const char glyph_logicalor[] = "logicalor";
static const char glyph_longs[] = "longs";
static const char glyph_lozenge[] = "lozenge";
static const char glyph_lslash[] = "lslash";
static const char glyph_lsuperior[] = "lsuperior";
static const char glyph_ltshade[] = "ltshade";
static const char glyph_m[] = "m";
static const char glyph_macron[] = "macron";
static const char glyph_male[] = "male";
static const char glyph_minus[] = "minus";
static const char glyph_minute[] = "minute";
static const char glyph_msuperior[] = "msuperior";
static const char glyph_mu[] = "mu";
static const char glyph_multiply[] = "multiply";
static const char glyph_musicalnote[] = "musicalnote";
static const char glyph_musicalnotedbl[] = "musicalnotedbl";
static const char glyph_n[] = "n";
static const char glyph_nacute[] = "nacute";
static const char glyph_napostrophe[] = "napostrophe";
static const char glyph_ncaron[] = "ncaron";
static const char glyph_ncommaaccent[] = "ncommaaccent";
static const char glyph_nine[] = "nine";
static const char glyph_nineinferior[] = "nineinferior";
static const char glyph_nineoldstyle[] = "nineoldstyle";
static const char glyph_ninesuperior[] = "ninesuperior";
static const char glyph_notelement[] = "notelement";
static const char glyph_notequal[] = "notequal";
static const char glyph_notsubset[] = "notsubset";
static const char glyph_nsuperior[] = "nsuperior";
static const char glyph_ntilde[] = "ntilde";
static const char glyph_nu[] = "nu";
static const char glyph_numbersign[] = "numbersign";
static const char glyph_o[] = "o";
static const char glyph_oacute[] = "oacute";
static const char glyph_obreve[] = "obreve";
static const char glyph_ocircumflex[] = "ocircumflex";
static const char glyph_odieresis[] = "odieresis";
static const char glyph_oe[] = "oe";
static const char glyph_ogonek[] = "ogonek";
static const char glyph_ograve[] = "ograve";
static const char glyph_ohorn[] = "ohorn";
static const char glyph_ohungarumlaut[] = "ohungarumlaut";
static const char glyph_omacron[] = "omacron";
static const char glyph_omega[] = "omega";
static const char glyph_omega1[] = "omega1";
static const char glyph_omegatonos[] = "omegatonos";
static const char glyph_omicron[] = "omicron";
static const char glyph_omicrontonos[] = "omicrontonos";
static const char glyph_one[] = "one";
static const char glyph_onedotenleader[] = "onedotenleader";
static const char glyph_oneeighth[] = "oneeighth";
static const char glyph_onefitted[] = "onefitted";
static const char glyph_onehalf[] = "onehalf";
static const char glyph_oneinferior[] = "oneinferior";
static const char glyph_oneoldstyle[] = "oneoldstyle";
static const char glyph_onequarter[] = "onequarter";
static const char glyph_onesuperior[] = "onesuperior";
static const char glyph_onethird[] = "onethird";
static const char glyph_openbullet[] = "openbullet";
static const char glyph_ordfeminine[] = "ordfeminine";
static const char glyph_ordmasculine[] = "ordmasculine";
static const char glyph_orthogonal[] = "orthogonal";
static const char glyph_oslash[] = "oslash";
static const char glyph_oslashacute[] = "oslashacute";
static const char glyph_osuperior[] = "osuperior";
static const char glyph_otilde[] = "otilde";
static const char glyph_p[] = "p";
static const char glyph_paragraph[] = "paragraph";
static const char glyph_parenleft[] = "parenleft";
static const char glyph_parenleftbt[] = "parenleftbt";
static const char glyph_parenleftex[] = "parenleftex";
static const char glyph_parenleftinferior[] = "parenleftinferior";
static const char glyph_parenleftsuperior[] = "parenleftsuperior";
static const char glyph_parenlefttp[] = "parenlefttp";
static const char glyph_parenright[] = "parenright";
static const char glyph_parenrightbt[] = "parenrightbt";
static const char glyph_parenrightex[] = "parenrightex";
static const char glyph_parenrightinferior[] = "parenrightinferior";
static const char glyph_parenrightsuperior[] = "parenrightsuperior";
static const char glyph_parenrighttp[] = "parenrighttp";
static const char glyph_partialdiff[] = "partialdiff";
static const char glyph_percent[] = "percent";
static const char glyph_period[] = "period";
static const char glyph_periodcentered[] = "periodcentered";
static const char glyph_periodinferior[] = "periodinferior";
static const char glyph_periodsuperior[] = "periodsuperior";
static const char glyph_perpendicular[] = "perpendicular";
static const char glyph_perthousand[] = "perthousand";
static const char glyph_peseta[] = "peseta";
static const char glyph_phi[] = "phi";
static const char glyph_phi1[] = "phi1";
static const char glyph_pi[] = "pi";
static const char glyph_plus[] = "plus";
static const char glyph_plusminus[] = "plusminus";
static const char glyph_prescription[] = "prescription";
static const char glyph_product[] = "product";
static const char glyph_propersubset[] = "propersubset";
static const char glyph_propersuperset[] = "propersuperset";
static const char glyph_proportional[] = "proportional";
static const char glyph_psi[] = "psi";
static const char glyph_q[] = "q";
static const char glyph_question[] = "question";
static const char glyph_questiondown[] = "questiondown";
static const char glyph_questiondownsmall[] = "questiondownsmall";
static const char glyph_questionsmall[] = "questionsmall";
static const char glyph_quotedbl[] = "quotedbl";
static const char glyph_quotedblbase[] = "quotedblbase";
static const char glyph_quotedblleft[] = "quotedblleft";
static const char glyph_quotedblright[] = "quotedblright";
static const char glyph_quoteleft[] = "quoteleft";
static const char glyph_quotereversed[] = "quotereversed";
static const char glyph_quoteright[] = "quoteright";
static const char glyph_quotesinglbase[] = "quotesinglbase";
static const char glyph_quotesingle[] = "quotesingle";
static const char glyph_r[] = "r";
static const char glyph_racute[] = "racute";
static const char glyph_radical[] = "radical";
static const char glyph_radicalex[] = "radicalex";
static const char glyph_rcaron[] = "rcaron";
static const char glyph_rcommaaccent[] = "rcommaaccent";
static const char glyph_reflexsubset[] = "reflexsubset";
static const char glyph_reflexsuperset[] = "reflexsuperset";
static const char glyph_registered[] = "registered";
static const char glyph_registersans[] = "registersans";
static const char glyph_registerserif[] = "registerserif";
static const char glyph_revlogicalnot[] = "revlogicalnot";
static const char glyph_rho[] = "rho";
static const char glyph_ring[] = "ring";
static const char glyph_rsuperior[] = "rsuperior";
static const char glyph_rtblock[] = "rtblock";
static const char glyph_rupiah[] = "rupiah";
static const char glyph_s[] = "s";
static const char glyph_sacute[] = "sacute";
static const char glyph_scaron[] = "scaron";
static const char glyph_scedilla[] = "scedilla";
static const char glyph_scircumflex[] = "scircumflex";
static const char glyph_scommaaccent[] = "scommaaccent";
static const char glyph_second[] = "second";
static const char glyph_section[] = "section";
static const char glyph_semicolon[] = "semicolon";
static const char glyph_seven[] = "seven";
static const char glyph_seveneighths[] = "seveneighths";
static const char glyph_seveninferior[] = "seveninferior";
static const char glyph_sevenoldstyle[] = "sevenoldstyle";
static const char glyph_sevensuperior[] = "sevensuperior";
static const char glyph_shade[] = "shade";
static const char glyph_sigma[] = "sigma";
static const char glyph_sigma1[] = "sigma1";
static const char glyph_similar[] = "similar";
static const char glyph_six[] = "six";
static const char glyph_sixinferior[] = "sixinferior";
static const char glyph_sixoldstyle[] = "sixoldstyle";
static const char glyph_sixsuperior[] = "sixsuperior";
static const char glyph_slash[] = "slash";
static const char glyph_smileface[] = "smileface";
static const char glyph_space[] = "space";
static const char glyph_spade[] = "spade";
static const char glyph_ssuperior[] = "ssuperior";
static const char glyph_sterling[] = "sterling";
static const char glyph_suchthat[] = "suchthat";
static const char glyph_summation[] = "summation";
static const char glyph_sun[] = "sun";
static const char glyph_t[] = "t";
static const char glyph_tau[] = "tau";
static const char glyph_tbar[] = "tbar";
static const char glyph_tcaron[] = "tcaron";
static const char glyph_tcommaaccent[] = "tcommaaccent";
static const char glyph_therefore[] = "therefore";
static const char glyph_theta[] = "theta";
static const char glyph_theta1[] = "theta1";
static const char glyph_thorn[] = "thorn";
static const char glyph_three[] = "three";
static const char glyph_threeeighths[] = "threeeighths";
static const char glyph_threeinferior[] = "threeinferior";
static const char glyph_threeoldstyle[] = "threeoldstyle";
static const char glyph_threequarters[] = "threequarters";
static const char glyph_threequartersemdash[] = "threequartersemdash";
static const char glyph_threesuperior[] = "threesuperior";
static const char glyph_tilde[] = "tilde";
static const char glyph_tildecomb[] = "tildecomb";
static const char glyph_tonos[] = "tonos";
static const char glyph_trademark[] = "trademark";
static const char glyph_trademarksans[] = "trademarksans";
static const char glyph_trademarkserif[] = "trademarkserif";
static const char glyph_triagdn[] = "triagdn";
static const char glyph_triaglf[] = "triaglf";
static const char glyph_triagrt[] = "triagrt";
static const char glyph_triagup[] = "triagup";
static const char glyph_tsuperior[] = "tsuperior";
static const char glyph_two[] = "two";
static const char glyph_twodotenleader[] = "twodotenleader";
static const char glyph_twoinferior[] = "twoinferior";
static const char glyph_twooldstyle[] = "twooldstyle";
static const char glyph_twosuperior[] = "twosuperior";
static const char glyph_twothirds[] = "twothirds";
static const char glyph_u[] = "u";
static const char glyph_uacute[] = "uacute";
static const char glyph_ubreve[] = "ubreve";
static const char glyph_ucircumflex[] = "ucircumflex";
static const char glyph_udieresis[] = "udieresis";
static const char glyph_ugrave[] = "ugrave";
static const char glyph_uhorn[] = "uhorn";
static const char glyph_uhungarumlaut[] = "uhungarumlaut";
static const char glyph_umacron[] = "umacron";
static const char glyph_underscore[] = "underscore";
static const char glyph_underscoredbl[] = "underscoredbl";
static const char glyph_union[] = "union";
static const char glyph_universal[] = "universal";
static const char glyph_uogonek[] = "uogonek";
static const char glyph_upblock[] = "upblock";
static const char glyph_upsilon[] = "upsilon";
static const char glyph_upsilondieresis[] = "upsilondieresis";
static const char glyph_upsilondieresistonos[] = "upsilondieresistonos";
static const char glyph_upsilontonos[] = "upsilontonos";
static const char glyph_uring[] = "uring";
static const char glyph_utilde[] = "utilde";
static const char glyph_v[] = "v";
static const char glyph_w[] = "w";
static const char glyph_wacute[] = "wacute";
static const char glyph_wcircumflex[] = "wcircumflex";
static const char glyph_wdieresis[] = "wdieresis";
static const char glyph_weierstrass[] = "weierstrass";
static const char glyph_wgrave[] = "wgrave";
static const char glyph_x[] = "x";
static const char glyph_xi[] = "xi";
static const char glyph_y[] = "y";
static const char glyph_yacute[] = "yacute";
static const char glyph_ycircumflex[] = "ycircumflex";
static const char glyph_ydieresis[] = "ydieresis";
static const char glyph_yen[] = "yen";
static const char glyph_ygrave[] = "ygrave";
static const char glyph_z[] = "z";
static const char glyph_zacute[] = "zacute";
static const char glyph_zcaron[] = "zcaron";
static const char glyph_zdotaccent[] = "zdotaccent";
static const char glyph_zero[] = "zero";
static const char glyph_zeroinferior[] = "zeroinferior";
static const char glyph_zerooldstyle[] = "zerooldstyle";
static const char glyph_zerosuperior[] = "zerosuperior";
static const char glyph_zeta[] = "zeta";

static uni_agl tab_agl2uni[] =
{
    { 0x0041, glyph_A },
    { 0x00C6, glyph_AE },
    { 0x01FC, glyph_AEacute },
    { 0xF7E6, glyph_AEsmall },
    { 0x00C1, glyph_Aacute },
    { 0xF7E1, glyph_Aacutesmall },
    { 0x0102, glyph_Abreve },
    { 0x00C2, glyph_Acircumflex },
    { 0xF7E2, glyph_Acircumflexsmall },
    { 0xF6C9, glyph_Acute },
    { 0xF7B4, glyph_Acutesmall },
    { 0x00C4, glyph_Adieresis },
    { 0xF7E4, glyph_Adieresissmall },
    { 0x00C0, glyph_Agrave },
    { 0xF7E0, glyph_Agravesmall },
    { 0x0391, glyph_Alpha },
    { 0x0386, glyph_Alphatonos },
    { 0x0100, glyph_Amacron },
    { 0x0104, glyph_Aogonek },
    { 0x00C5, glyph_Aring },
    { 0x01FA, glyph_Aringacute },
    { 0xF7E5, glyph_Aringsmall },
    { 0xF761, glyph_Asmall },
    { 0x00C3, glyph_Atilde },
    { 0xF7E3, glyph_Atildesmall },
    { 0x0042, glyph_B },
    { 0x0392, glyph_Beta },
    { 0xF6F4, glyph_Brevesmall },
    { 0xF762, glyph_Bsmall },
    { 0x0043, glyph_C },
    { 0x0106, glyph_Cacute },
    { 0xF6CA, glyph_Caron },
    { 0xF6F5, glyph_Caronsmall },
    { 0x010C, glyph_Ccaron },
    { 0x00C7, glyph_Ccedilla },
    { 0xF7E7, glyph_Ccedillasmall },
    { 0x0108, glyph_Ccircumflex },
    { 0x010A, glyph_Cdotaccent },
    { 0xF7B8, glyph_Cedillasmall },
    { 0x03A7, glyph_Chi },
    { 0xF6F6, glyph_Circumflexsmall },
    { 0xF763, glyph_Csmall },
    { 0x0044, glyph_D },
    { 0x010E, glyph_Dcaron },
    { 0x0110, glyph_Dcroat },
/*  { 0x2206, glyph_Delta },  duplicate */
    { 0x0394, glyph_Delta },
    { 0xF6CB, glyph_Dieresis },
    { 0xF6CC, glyph_DieresisAcute },
    { 0xF6CD, glyph_DieresisGrave },
    { 0xF7A8, glyph_Dieresissmall },
    { 0xF6F7, glyph_Dotaccentsmall },
    { 0xF764, glyph_Dsmall },
    { 0x0045, glyph_E },
    { 0x00C9, glyph_Eacute },
    { 0xF7E9, glyph_Eacutesmall },
    { 0x0114, glyph_Ebreve },
    { 0x011A, glyph_Ecaron },
    { 0x00CA, glyph_Ecircumflex },
    { 0xF7EA, glyph_Ecircumflexsmall },
    { 0x00CB, glyph_Edieresis },
    { 0xF7EB, glyph_Edieresissmall },
    { 0x0116, glyph_Edotaccent },
    { 0x00C8, glyph_Egrave },
    { 0xF7E8, glyph_Egravesmall },
    { 0x0112, glyph_Emacron },
    { 0x014A, glyph_Eng },
    { 0x0118, glyph_Eogonek },
    { 0x0395, glyph_Epsilon },
    { 0x0388, glyph_Epsilontonos },
    { 0xF765, glyph_Esmall },
    { 0x0397, glyph_Eta },
    { 0x0389, glyph_Etatonos },
    { 0x00D0, glyph_Eth },
    { 0xF7F0, glyph_Ethsmall },
    { 0x20AC, glyph_Euro },
    { 0x0046, glyph_F },
    { 0xF766, glyph_Fsmall },
    { 0x0047, glyph_G },
    { 0x0393, glyph_Gamma },
    { 0x011E, glyph_Gbreve },
    { 0x01E6, glyph_Gcaron },
    { 0x011C, glyph_Gcircumflex },
    { 0x0122, glyph_Gcommaaccent },
    { 0x0120, glyph_Gdotaccent },
    { 0xF6CE, glyph_Grave },
    { 0xF760, glyph_Gravesmall },
    { 0xF767, glyph_Gsmall },
    { 0x0048, glyph_H },
    { 0x25CF, glyph_H18533 },
    { 0x25AA, glyph_H18543 },
    { 0x25AB, glyph_H18551 },
    { 0x25A1, glyph_H22073 },
    { 0x0126, glyph_Hbar },
    { 0x0124, glyph_Hcircumflex },
    { 0xF768, glyph_Hsmall },
    { 0xF6CF, glyph_Hungarumlaut },
    { 0xF6F8, glyph_Hungarumlautsmall },
    { 0x0049, glyph_I },
    { 0x0132, glyph_IJ },
    { 0x00CD, glyph_Iacute },
    { 0xF7ED, glyph_Iacutesmall },
    { 0x012C, glyph_Ibreve },
    { 0x00CE, glyph_Icircumflex },
    { 0xF7EE, glyph_Icircumflexsmall },
    { 0x00CF, glyph_Idieresis },
    { 0xF7EF, glyph_Idieresissmall },
    { 0x0130, glyph_Idotaccent },
    { 0x2111, glyph_Ifraktur },
    { 0x00CC, glyph_Igrave },
    { 0xF7EC, glyph_Igravesmall },
    { 0x012A, glyph_Imacron },
    { 0x012E, glyph_Iogonek },
    { 0x0399, glyph_Iota },
    { 0x03AA, glyph_Iotadieresis },
    { 0x038A, glyph_Iotatonos },
    { 0xF769, glyph_Ismall },
    { 0x0128, glyph_Itilde },
    { 0x004A, glyph_J },
    { 0x0134, glyph_Jcircumflex },
    { 0xF76A, glyph_Jsmall },
    { 0x004B, glyph_K },
    { 0x039A, glyph_Kappa },
    { 0x0136, glyph_Kcommaaccent },
    { 0xF76B, glyph_Ksmall },
    { 0x004C, glyph_L },
    { 0xF6BF, glyph_LL },
    { 0x0139, glyph_Lacute },
    { 0x039B, glyph_Lambda },
    { 0x013D, glyph_Lcaron },
    { 0x013B, glyph_Lcommaaccent },
    { 0x013F, glyph_Ldot },
    { 0x0141, glyph_Lslash },
    { 0xF6F9, glyph_Lslashsmall },
    { 0xF76C, glyph_Lsmall },
    { 0x004D, glyph_M },
    { 0xF6D0, glyph_Macron },
    { 0xF7AF, glyph_Macronsmall },
    { 0xF76D, glyph_Msmall },
    { 0x039C, glyph_Mu },
    { 0x004E, glyph_N },
    { 0x0143, glyph_Nacute },
    { 0x0147, glyph_Ncaron },
    { 0x0145, glyph_Ncommaaccent },
    { 0xF76E, glyph_Nsmall },
    { 0x00D1, glyph_Ntilde },
    { 0xF7F1, glyph_Ntildesmall },
    { 0x039D, glyph_Nu },
    { 0x004F, glyph_O },
    { 0x0152, glyph_OE },
    { 0xF6FA, glyph_OEsmall },
    { 0x00D3, glyph_Oacute },
    { 0xF7F3, glyph_Oacutesmall },
    { 0x014E, glyph_Obreve },
    { 0x00D4, glyph_Ocircumflex },
    { 0xF7F4, glyph_Ocircumflexsmall },
    { 0x00D6, glyph_Odieresis },
    { 0xF7F6, glyph_Odieresissmall },
    { 0xF6FB, glyph_Ogoneksmall },
    { 0x00D2, glyph_Ograve },
    { 0xF7F2, glyph_Ogravesmall },
    { 0x01A0, glyph_Ohorn },
    { 0x0150, glyph_Ohungarumlaut },
    { 0x014C, glyph_Omacron },
/*  { 0x2126, glyph_Omega },  duplicate */
    { 0x03A9, glyph_Omega },
    { 0x038F, glyph_Omegatonos },
    { 0x039F, glyph_Omicron },
    { 0x038C, glyph_Omicrontonos },
    { 0x00D8, glyph_Oslash },
    { 0x01FE, glyph_Oslashacute },
    { 0xF7F8, glyph_Oslashsmall },
    { 0xF76F, glyph_Osmall },
    { 0x00D5, glyph_Otilde },
    { 0xF7F5, glyph_Otildesmall },
    { 0x0050, glyph_P },
    { 0x03A6, glyph_Phi },
    { 0x03A0, glyph_Pi },
    { 0x03A8, glyph_Psi },
    { 0xF770, glyph_Psmall },
    { 0x0051, glyph_Q },
    { 0xF771, glyph_Qsmall },
    { 0x0052, glyph_R },
    { 0x0154, glyph_Racute },
    { 0x0158, glyph_Rcaron },
    { 0x0156, glyph_Rcommaaccent },
    { 0x211C, glyph_Rfraktur },
    { 0x03A1, glyph_Rho },
    { 0xF6FC, glyph_Ringsmall },
    { 0xF772, glyph_Rsmall },
    { 0x0053, glyph_S },
    { 0x250C, glyph_SF010000 },
    { 0x2514, glyph_SF020000 },
    { 0x2510, glyph_SF030000 },
    { 0x2518, glyph_SF040000 },
    { 0x253C, glyph_SF050000 },
    { 0x252C, glyph_SF060000 },
    { 0x2534, glyph_SF070000 },
    { 0x251C, glyph_SF080000 },
    { 0x2524, glyph_SF090000 },
    { 0x2500, glyph_SF100000 },
    { 0x2502, glyph_SF110000 },
    { 0x2561, glyph_SF190000 },
    { 0x2562, glyph_SF200000 },
    { 0x2556, glyph_SF210000 },
    { 0x2555, glyph_SF220000 },
    { 0x2563, glyph_SF230000 },
    { 0x2551, glyph_SF240000 },
    { 0x2557, glyph_SF250000 },
    { 0x255D, glyph_SF260000 },
    { 0x255C, glyph_SF270000 },
    { 0x255B, glyph_SF280000 },
    { 0x255E, glyph_SF360000 },
    { 0x255F, glyph_SF370000 },
    { 0x255A, glyph_SF380000 },
    { 0x2554, glyph_SF390000 },
    { 0x2569, glyph_SF400000 },
    { 0x2566, glyph_SF410000 },
    { 0x2560, glyph_SF420000 },
    { 0x2550, glyph_SF430000 },
    { 0x256C, glyph_SF440000 },
    { 0x2567, glyph_SF450000 },
    { 0x2568, glyph_SF460000 },
    { 0x2564, glyph_SF470000 },
    { 0x2565, glyph_SF480000 },
    { 0x2559, glyph_SF490000 },
    { 0x2558, glyph_SF500000 },
    { 0x2552, glyph_SF510000 },
    { 0x2553, glyph_SF520000 },
    { 0x256B, glyph_SF530000 },
    { 0x256A, glyph_SF540000 },
    { 0x015A, glyph_Sacute },
    { 0x0160, glyph_Scaron },
    { 0xF6FD, glyph_Scaronsmall },
    { 0x015E, glyph_Scedilla },
/*  { 0xF6C1, glyph_Scedilla },  duplicate */
    { 0x015C, glyph_Scircumflex },
    { 0x0218, glyph_Scommaaccent },
    { 0x03A3, glyph_Sigma },
    { 0xF773, glyph_Ssmall },
    { 0x0054, glyph_T },
    { 0x03A4, glyph_Tau },
    { 0x0166, glyph_Tbar },
    { 0x0164, glyph_Tcaron },
    { 0x0162, glyph_Tcommaaccent },
/*  { 0x021A, glyph_Tcommaaccent },  duplicate */
    { 0x0398, glyph_Theta },
    { 0x00DE, glyph_Thorn },
    { 0xF7FE, glyph_Thornsmall },
    { 0xF6FE, glyph_Tildesmall },
    { 0xF774, glyph_Tsmall },
    { 0x0055, glyph_U },
    { 0x00DA, glyph_Uacute },
    { 0xF7FA, glyph_Uacutesmall },
    { 0x016C, glyph_Ubreve },
    { 0x00DB, glyph_Ucircumflex },
    { 0xF7FB, glyph_Ucircumflexsmall },
    { 0x00DC, glyph_Udieresis },
    { 0xF7FC, glyph_Udieresissmall },
    { 0x00D9, glyph_Ugrave },
    { 0xF7F9, glyph_Ugravesmall },
    { 0x01AF, glyph_Uhorn },
    { 0x0170, glyph_Uhungarumlaut },
    { 0x016A, glyph_Umacron },
    { 0x0172, glyph_Uogonek },
    { 0x03A5, glyph_Upsilon },
    { 0x03D2, glyph_Upsilon1 },
    { 0x03AB, glyph_Upsilondieresis },
    { 0x038E, glyph_Upsilontonos },
    { 0x016E, glyph_Uring },
    { 0xF775, glyph_Usmall },
    { 0x0168, glyph_Utilde },
    { 0x0056, glyph_V },
    { 0xF776, glyph_Vsmall },
    { 0x0057, glyph_W },
    { 0x1E82, glyph_Wacute },
    { 0x0174, glyph_Wcircumflex },
    { 0x1E84, glyph_Wdieresis },
    { 0x1E80, glyph_Wgrave },
    { 0xF777, glyph_Wsmall },
    { 0x0058, glyph_X },
    { 0x039E, glyph_Xi },
    { 0xF778, glyph_Xsmall },
    { 0x0059, glyph_Y },
    { 0x00DD, glyph_Yacute },
    { 0xF7FD, glyph_Yacutesmall },
    { 0x0176, glyph_Ycircumflex },
    { 0x0178, glyph_Ydieresis },
    { 0xF7FF, glyph_Ydieresissmall },
    { 0x1EF2, glyph_Ygrave },
    { 0xF779, glyph_Ysmall },
    { 0x005A, glyph_Z },
    { 0x0179, glyph_Zacute },
    { 0x017D, glyph_Zcaron },
    { 0xF6FF, glyph_Zcaronsmall },
    { 0x017B, glyph_Zdotaccent },
    { 0x0396, glyph_Zeta },
    { 0xF77A, glyph_Zsmall },
    { 0x0061, glyph_a },
    { 0x00E1, glyph_aacute },
    { 0x0103, glyph_abreve },
    { 0x00E2, glyph_acircumflex },
    { 0x00B4, glyph_acute },
    { 0x0301, glyph_acutecomb },
    { 0x00E4, glyph_adieresis },
    { 0x00E6, glyph_ae },
    { 0x01FD, glyph_aeacute },
    { 0x2015, glyph_afii00208 },
    { 0x0410, glyph_afii10017 },
    { 0x0411, glyph_afii10018 },
    { 0x0412, glyph_afii10019 },
    { 0x0413, glyph_afii10020 },
    { 0x0414, glyph_afii10021 },
    { 0x0415, glyph_afii10022 },
    { 0x0401, glyph_afii10023 },
    { 0x0416, glyph_afii10024 },
    { 0x0417, glyph_afii10025 },
    { 0x0418, glyph_afii10026 },
    { 0x0419, glyph_afii10027 },
    { 0x041A, glyph_afii10028 },
    { 0x041B, glyph_afii10029 },
    { 0x041C, glyph_afii10030 },
    { 0x041D, glyph_afii10031 },
    { 0x041E, glyph_afii10032 },
    { 0x041F, glyph_afii10033 },
    { 0x0420, glyph_afii10034 },
    { 0x0421, glyph_afii10035 },
    { 0x0422, glyph_afii10036 },
    { 0x0423, glyph_afii10037 },
    { 0x0424, glyph_afii10038 },
    { 0x0425, glyph_afii10039 },
    { 0x0426, glyph_afii10040 },
    { 0x0427, glyph_afii10041 },
    { 0x0428, glyph_afii10042 },
    { 0x0429, glyph_afii10043 },
    { 0x042A, glyph_afii10044 },
    { 0x042B, glyph_afii10045 },
    { 0x042C, glyph_afii10046 },
    { 0x042D, glyph_afii10047 },
    { 0x042E, glyph_afii10048 },
    { 0x042F, glyph_afii10049 },
    { 0x0490, glyph_afii10050 },
    { 0x0402, glyph_afii10051 },
    { 0x0403, glyph_afii10052 },
    { 0x0404, glyph_afii10053 },
    { 0x0405, glyph_afii10054 },
    { 0x0406, glyph_afii10055 },
    { 0x0407, glyph_afii10056 },
    { 0x0408, glyph_afii10057 },
    { 0x0409, glyph_afii10058 },
    { 0x040A, glyph_afii10059 },
    { 0x040B, glyph_afii10060 },
    { 0x040C, glyph_afii10061 },
    { 0x040E, glyph_afii10062 },
    { 0xF6C4, glyph_afii10063 },
    { 0xF6C5, glyph_afii10064 },
    { 0x0430, glyph_afii10065 },
    { 0x0431, glyph_afii10066 },
    { 0x0432, glyph_afii10067 },
    { 0x0433, glyph_afii10068 },
    { 0x0434, glyph_afii10069 },
    { 0x0435, glyph_afii10070 },
    { 0x0451, glyph_afii10071 },
    { 0x0436, glyph_afii10072 },
    { 0x0437, glyph_afii10073 },
    { 0x0438, glyph_afii10074 },
    { 0x0439, glyph_afii10075 },
    { 0x043A, glyph_afii10076 },
    { 0x043B, glyph_afii10077 },
    { 0x043C, glyph_afii10078 },
    { 0x043D, glyph_afii10079 },
    { 0x043E, glyph_afii10080 },
    { 0x043F, glyph_afii10081 },
    { 0x0440, glyph_afii10082 },
    { 0x0441, glyph_afii10083 },
    { 0x0442, glyph_afii10084 },
    { 0x0443, glyph_afii10085 },
    { 0x0444, glyph_afii10086 },
    { 0x0445, glyph_afii10087 },
    { 0x0446, glyph_afii10088 },
    { 0x0447, glyph_afii10089 },
    { 0x0448, glyph_afii10090 },
    { 0x0449, glyph_afii10091 },
    { 0x044A, glyph_afii10092 },
    { 0x044B, glyph_afii10093 },
    { 0x044C, glyph_afii10094 },
    { 0x044D, glyph_afii10095 },
    { 0x044E, glyph_afii10096 },
    { 0x044F, glyph_afii10097 },
    { 0x0491, glyph_afii10098 },
    { 0x0452, glyph_afii10099 },
    { 0x0453, glyph_afii10100 },
    { 0x0454, glyph_afii10101 },
    { 0x0455, glyph_afii10102 },
    { 0x0456, glyph_afii10103 },
    { 0x0457, glyph_afii10104 },
    { 0x0458, glyph_afii10105 },
    { 0x0459, glyph_afii10106 },
    { 0x045A, glyph_afii10107 },
    { 0x045B, glyph_afii10108 },
    { 0x045C, glyph_afii10109 },
    { 0x045E, glyph_afii10110 },
    { 0x040F, glyph_afii10145 },
    { 0x0462, glyph_afii10146 },
    { 0x0472, glyph_afii10147 },
    { 0x0474, glyph_afii10148 },
    { 0xF6C6, glyph_afii10192 },
    { 0x045F, glyph_afii10193 },
    { 0x0463, glyph_afii10194 },
    { 0x0473, glyph_afii10195 },
    { 0x0475, glyph_afii10196 },
    { 0xF6C7, glyph_afii10831 },
    { 0xF6C8, glyph_afii10832 },
    { 0x04D9, glyph_afii10846 },
    { 0x200E, glyph_afii299 },
    { 0x200F, glyph_afii300 },
    { 0x200D, glyph_afii301 },
    { 0x066A, glyph_afii57381 },
    { 0x060C, glyph_afii57388 },
    { 0x0660, glyph_afii57392 },
    { 0x0661, glyph_afii57393 },
    { 0x0662, glyph_afii57394 },
    { 0x0663, glyph_afii57395 },
    { 0x0664, glyph_afii57396 },
    { 0x0665, glyph_afii57397 },
    { 0x0666, glyph_afii57398 },
    { 0x0667, glyph_afii57399 },
    { 0x0668, glyph_afii57400 },
    { 0x0669, glyph_afii57401 },
    { 0x061B, glyph_afii57403 },
    { 0x061F, glyph_afii57407 },
    { 0x0621, glyph_afii57409 },
    { 0x0622, glyph_afii57410 },
    { 0x0623, glyph_afii57411 },
    { 0x0624, glyph_afii57412 },
    { 0x0625, glyph_afii57413 },
    { 0x0626, glyph_afii57414 },
    { 0x0627, glyph_afii57415 },
    { 0x0628, glyph_afii57416 },
    { 0x0629, glyph_afii57417 },
    { 0x062A, glyph_afii57418 },
    { 0x062B, glyph_afii57419 },
    { 0x062C, glyph_afii57420 },
    { 0x062D, glyph_afii57421 },
    { 0x062E, glyph_afii57422 },
    { 0x062F, glyph_afii57423 },
    { 0x0630, glyph_afii57424 },
    { 0x0631, glyph_afii57425 },
    { 0x0632, glyph_afii57426 },
    { 0x0633, glyph_afii57427 },
    { 0x0634, glyph_afii57428 },
    { 0x0635, glyph_afii57429 },
    { 0x0636, glyph_afii57430 },
    { 0x0637, glyph_afii57431 },
    { 0x0638, glyph_afii57432 },
    { 0x0639, glyph_afii57433 },
    { 0x063A, glyph_afii57434 },
    { 0x0640, glyph_afii57440 },
    { 0x0641, glyph_afii57441 },
    { 0x0642, glyph_afii57442 },
    { 0x0643, glyph_afii57443 },
    { 0x0644, glyph_afii57444 },
    { 0x0645, glyph_afii57445 },
    { 0x0646, glyph_afii57446 },
    { 0x0648, glyph_afii57448 },
    { 0x0649, glyph_afii57449 },
    { 0x064A, glyph_afii57450 },
    { 0x064B, glyph_afii57451 },
    { 0x064C, glyph_afii57452 },
    { 0x064D, glyph_afii57453 },
    { 0x064E, glyph_afii57454 },
    { 0x064F, glyph_afii57455 },
    { 0x0650, glyph_afii57456 },
    { 0x0651, glyph_afii57457 },
    { 0x0652, glyph_afii57458 },
    { 0x0647, glyph_afii57470 },
    { 0x06A4, glyph_afii57505 },
    { 0x067E, glyph_afii57506 },
    { 0x0686, glyph_afii57507 },
    { 0x0698, glyph_afii57508 },
    { 0x06AF, glyph_afii57509 },
    { 0x0679, glyph_afii57511 },
    { 0x0688, glyph_afii57512 },
    { 0x0691, glyph_afii57513 },
    { 0x06BA, glyph_afii57514 },
    { 0x06D2, glyph_afii57519 },
    { 0x06D5, glyph_afii57534 },
    { 0x20AA, glyph_afii57636 },
    { 0x05BE, glyph_afii57645 },
    { 0x05C3, glyph_afii57658 },
    { 0x05D0, glyph_afii57664 },
    { 0x05D1, glyph_afii57665 },
    { 0x05D2, glyph_afii57666 },
    { 0x05D3, glyph_afii57667 },
    { 0x05D4, glyph_afii57668 },
    { 0x05D5, glyph_afii57669 },
    { 0x05D6, glyph_afii57670 },
    { 0x05D7, glyph_afii57671 },
    { 0x05D8, glyph_afii57672 },
    { 0x05D9, glyph_afii57673 },
    { 0x05DA, glyph_afii57674 },
    { 0x05DB, glyph_afii57675 },
    { 0x05DC, glyph_afii57676 },
    { 0x05DD, glyph_afii57677 },
    { 0x05DE, glyph_afii57678 },
    { 0x05DF, glyph_afii57679 },
    { 0x05E0, glyph_afii57680 },
    { 0x05E1, glyph_afii57681 },
    { 0x05E2, glyph_afii57682 },
    { 0x05E3, glyph_afii57683 },
    { 0x05E4, glyph_afii57684 },
    { 0x05E5, glyph_afii57685 },
    { 0x05E6, glyph_afii57686 },
    { 0x05E7, glyph_afii57687 },
    { 0x05E8, glyph_afii57688 },
    { 0x05E9, glyph_afii57689 },
    { 0x05EA, glyph_afii57690 },
    { 0xFB2A, glyph_afii57694 },
    { 0xFB2B, glyph_afii57695 },
    { 0xFB4B, glyph_afii57700 },
    { 0xFB1F, glyph_afii57705 },
    { 0x05F0, glyph_afii57716 },
    { 0x05F1, glyph_afii57717 },
    { 0x05F2, glyph_afii57718 },
    { 0xFB35, glyph_afii57723 },
    { 0x05B4, glyph_afii57793 },
    { 0x05B5, glyph_afii57794 },
    { 0x05B6, glyph_afii57795 },
    { 0x05BB, glyph_afii57796 },
    { 0x05B8, glyph_afii57797 },
    { 0x05B7, glyph_afii57798 },
    { 0x05B0, glyph_afii57799 },
    { 0x05B2, glyph_afii57800 },
    { 0x05B1, glyph_afii57801 },
    { 0x05B3, glyph_afii57802 },
    { 0x05C2, glyph_afii57803 },
    { 0x05C1, glyph_afii57804 },
    { 0x05B9, glyph_afii57806 },
    { 0x05BC, glyph_afii57807 },
    { 0x05BD, glyph_afii57839 },
    { 0x05BF, glyph_afii57841 },
    { 0x05C0, glyph_afii57842 },
    { 0x02BC, glyph_afii57929 },
    { 0x2105, glyph_afii61248 },
    { 0x2113, glyph_afii61289 },
    { 0x2116, glyph_afii61352 },
    { 0x202C, glyph_afii61573 },
    { 0x202D, glyph_afii61574 },
    { 0x202E, glyph_afii61575 },
    { 0x200C, glyph_afii61664 },
    { 0x066D, glyph_afii63167 },
    { 0x02BD, glyph_afii64937 },
    { 0x00E0, glyph_agrave },
    { 0x2135, glyph_aleph },
    { 0x03B1, glyph_alpha },
    { 0x03AC, glyph_alphatonos },
    { 0x0101, glyph_amacron },
    { 0x0026, glyph_ampersand },
    { 0xF726, glyph_ampersandsmall },
    { 0x2220, glyph_angle },
    { 0x2329, glyph_angleleft },
    { 0x232A, glyph_angleright },
    { 0x0387, glyph_anoteleia },
    { 0x0105, glyph_aogonek },
    { 0x2248, glyph_approxequal },
    { 0x00E5, glyph_aring },
    { 0x01FB, glyph_aringacute },
    { 0x2194, glyph_arrowboth },
    { 0x21D4, glyph_arrowdblboth },
    { 0x21D3, glyph_arrowdbldown },
    { 0x21D0, glyph_arrowdblleft },
    { 0x21D2, glyph_arrowdblright },
    { 0x21D1, glyph_arrowdblup },
    { 0x2193, glyph_arrowdown },
    { 0xF8E7, glyph_arrowhorizex },
    { 0x2190, glyph_arrowleft },
    { 0x2192, glyph_arrowright },
    { 0x2191, glyph_arrowup },
    { 0x2195, glyph_arrowupdn },
    { 0x21A8, glyph_arrowupdnbse },
    { 0xF8E6, glyph_arrowvertex },
    { 0x005E, glyph_asciicircum },
    { 0x007E, glyph_asciitilde },
    { 0x002A, glyph_asterisk },
    { 0x2217, glyph_asteriskmath },
    { 0xF6E9, glyph_asuperior },
    { 0x0040, glyph_at },
    { 0x00E3, glyph_atilde },
    { 0x0062, glyph_b },
    { 0x005C, glyph_backslash },
    { 0x007C, glyph_bar },
    { 0x03B2, glyph_beta },
    { 0x2588, glyph_block },
    { 0xF8F4, glyph_braceex },
    { 0x007B, glyph_braceleft },
    { 0xF8F3, glyph_braceleftbt },
    { 0xF8F2, glyph_braceleftmid },
    { 0xF8F1, glyph_bracelefttp },
    { 0x007D, glyph_braceright },
    { 0xF8FE, glyph_bracerightbt },
    { 0xF8FD, glyph_bracerightmid },
    { 0xF8FC, glyph_bracerighttp },
    { 0x005B, glyph_bracketleft },
    { 0xF8F0, glyph_bracketleftbt },
    { 0xF8EF, glyph_bracketleftex },
    { 0xF8EE, glyph_bracketlefttp },
    { 0x005D, glyph_bracketright },
    { 0xF8FB, glyph_bracketrightbt },
    { 0xF8FA, glyph_bracketrightex },
    { 0xF8F9, glyph_bracketrighttp },
    { 0x02D8, glyph_breve },
    { 0x00A6, glyph_brokenbar },
    { 0xF6EA, glyph_bsuperior },
    { 0x2022, glyph_bullet },
    { 0x0063, glyph_c },
    { 0x0107, glyph_cacute },
    { 0x02C7, glyph_caron },
    { 0x21B5, glyph_carriagereturn },
    { 0x010D, glyph_ccaron },
    { 0x00E7, glyph_ccedilla },
    { 0x0109, glyph_ccircumflex },
    { 0x010B, glyph_cdotaccent },
    { 0x00B8, glyph_cedilla },
    { 0x00A2, glyph_cent },
    { 0xF6DF, glyph_centinferior },
    { 0xF7A2, glyph_centoldstyle },
    { 0xF6E0, glyph_centsuperior },
    { 0x03C7, glyph_chi },
    { 0x25CB, glyph_circle },
    { 0x2297, glyph_circlemultiply },
    { 0x2295, glyph_circleplus },
    { 0x02C6, glyph_circumflex },
    { 0x2663, glyph_club },
    { 0x003A, glyph_colon },
    { 0x20A1, glyph_colonmonetary },
    { 0x002C, glyph_comma },
    { 0xF6C3, glyph_commaaccent },
    { 0xF6E1, glyph_commainferior },
    { 0xF6E2, glyph_commasuperior },
    { 0x2245, glyph_congruent },
    { 0x00A9, glyph_copyright },
    { 0xF8E9, glyph_copyrightsans },
    { 0xF6D9, glyph_copyrightserif },
    { 0x00A4, glyph_currency },
    { 0xF6D1, glyph_cyrBreve },
    { 0xF6D2, glyph_cyrFlex },
    { 0xF6D4, glyph_cyrbreve },
    { 0xF6D5, glyph_cyrflex },
    { 0x0064, glyph_d },
    { 0x2020, glyph_dagger },
    { 0x2021, glyph_daggerdbl },
    { 0xF6D3, glyph_dblGrave },
    { 0xF6D6, glyph_dblgrave },
    { 0x010F, glyph_dcaron },
    { 0x0111, glyph_dcroat },
    { 0x00B0, glyph_degree },
    { 0x03B4, glyph_delta },
    { 0x2666, glyph_diamond },
    { 0x00A8, glyph_dieresis },
    { 0xF6D7, glyph_dieresisacute },
    { 0xF6D8, glyph_dieresisgrave },
    { 0x0385, glyph_dieresistonos },
    { 0x00F7, glyph_divide },
    { 0x2593, glyph_dkshade },
    { 0x2584, glyph_dnblock },
    { 0x0024, glyph_dollar },
    { 0xF6E3, glyph_dollarinferior },
    { 0xF724, glyph_dollaroldstyle },
    { 0xF6E4, glyph_dollarsuperior },
    { 0x20AB, glyph_dong },
    { 0x02D9, glyph_dotaccent },
    { 0x0323, glyph_dotbelowcomb },
    { 0x0131, glyph_dotlessi },
    { 0xF6BE, glyph_dotlessj },
    { 0x22C5, glyph_dotmath },
    { 0xF6EB, glyph_dsuperior },
    { 0x0065, glyph_e },
    { 0x00E9, glyph_eacute },
    { 0x0115, glyph_ebreve },
    { 0x011B, glyph_ecaron },
    { 0x00EA, glyph_ecircumflex },
    { 0x00EB, glyph_edieresis },
    { 0x0117, glyph_edotaccent },
    { 0x00E8, glyph_egrave },
    { 0x0038, glyph_eight },
    { 0x2088, glyph_eightinferior },
    { 0xF738, glyph_eightoldstyle },
    { 0x2078, glyph_eightsuperior },
    { 0x2208, glyph_element },
    { 0x2026, glyph_ellipsis },
    { 0x0113, glyph_emacron },
    { 0x2014, glyph_emdash },
    { 0x2205, glyph_emptyset },
    { 0x2013, glyph_endash },
    { 0x014B, glyph_eng },
    { 0x0119, glyph_eogonek },
    { 0x03B5, glyph_epsilon },
    { 0x03AD, glyph_epsilontonos },
    { 0x003D, glyph_equal },
    { 0x2261, glyph_equivalence },
    { 0x212E, glyph_estimated },
    { 0xF6EC, glyph_esuperior },
    { 0x03B7, glyph_eta },
    { 0x03AE, glyph_etatonos },
    { 0x00F0, glyph_eth },
    { 0x0021, glyph_exclam },
    { 0x203C, glyph_exclamdbl },
    { 0x00A1, glyph_exclamdown },
    { 0xF7A1, glyph_exclamdownsmall },
    { 0xF721, glyph_exclamsmall },
    { 0x2203, glyph_existential },
    { 0x0066, glyph_f },
    { 0x2640, glyph_female },
    { 0xFB00, glyph_ff },
    { 0xFB03, glyph_ffi },
    { 0xFB04, glyph_ffl },
    { 0xFB01, glyph_fi },
    { 0x2012, glyph_figuredash },
    { 0x25A0, glyph_filledbox },
    { 0x25AC, glyph_filledrect },
    { 0x0035, glyph_five },
    { 0x215D, glyph_fiveeighths },
    { 0x2085, glyph_fiveinferior },
    { 0xF735, glyph_fiveoldstyle },
    { 0x2075, glyph_fivesuperior },
    { 0xFB02, glyph_fl },
    { 0x0192, glyph_florin },
    { 0x0034, glyph_four },
    { 0x2084, glyph_fourinferior },
    { 0xF734, glyph_fouroldstyle },
    { 0x2074, glyph_foursuperior },
    { 0x2044, glyph_fraction },
/*  { 0x2215, glyph_fraction },  duplicate */
    { 0x20A3, glyph_franc },
    { 0x0067, glyph_g },
    { 0x03B3, glyph_gamma },
    { 0x011F, glyph_gbreve },
    { 0x01E7, glyph_gcaron },
    { 0x011D, glyph_gcircumflex },
    { 0x0123, glyph_gcommaaccent },
    { 0x0121, glyph_gdotaccent },
    { 0x00DF, glyph_germandbls },
    { 0x2207, glyph_gradient },
    { 0x0060, glyph_grave },
    { 0x0300, glyph_gravecomb },
    { 0x003E, glyph_greater },
    { 0x2265, glyph_greaterequal },
    { 0x00AB, glyph_guillemotleft },
    { 0x00BB, glyph_guillemotright },
    { 0x2039, glyph_guilsinglleft },
    { 0x203A, glyph_guilsinglright },
    { 0x0068, glyph_h },
    { 0x0127, glyph_hbar },
    { 0x0125, glyph_hcircumflex },
    { 0x2665, glyph_heart },
    { 0x0309, glyph_hookabovecomb },
    { 0x2302, glyph_house },
    { 0x02DD, glyph_hungarumlaut },
    { 0x002D, glyph_hyphen },
/*  { 0x00AD, glyph_hyphen },  duplicate */
    { 0xF6E5, glyph_hypheninferior },
    { 0xF6E6, glyph_hyphensuperior },
    { 0x0069, glyph_i },
    { 0x00ED, glyph_iacute },
    { 0x012D, glyph_ibreve },
    { 0x00EE, glyph_icircumflex },
    { 0x00EF, glyph_idieresis },
    { 0x00EC, glyph_igrave },
    { 0x0133, glyph_ij },
    { 0x012B, glyph_imacron },
    { 0x221E, glyph_infinity },
    { 0x222B, glyph_integral },
    { 0x2321, glyph_integralbt },
    { 0xF8F5, glyph_integralex },
    { 0x2320, glyph_integraltp },
    { 0x2229, glyph_intersection },
    { 0x25D8, glyph_invbullet },
    { 0x25D9, glyph_invcircle },
    { 0x263B, glyph_invsmileface },
    { 0x012F, glyph_iogonek },
    { 0x03B9, glyph_iota },
    { 0x03CA, glyph_iotadieresis },
    { 0x0390, glyph_iotadieresistonos },
    { 0x03AF, glyph_iotatonos },
    { 0xF6ED, glyph_isuperior },
    { 0x0129, glyph_itilde },
    { 0x006A, glyph_j },
    { 0x0135, glyph_jcircumflex },
    { 0x006B, glyph_k },
    { 0x03BA, glyph_kappa },
    { 0x0137, glyph_kcommaaccent },
    { 0x0138, glyph_kgreenlandic },
    { 0x006C, glyph_l },
    { 0x013A, glyph_lacute },
    { 0x03BB, glyph_lambda },
    { 0x013E, glyph_lcaron },
    { 0x013C, glyph_lcommaaccent },
    { 0x0140, glyph_ldot },
    { 0x003C, glyph_less },
    { 0x2264, glyph_lessequal },
    { 0x258C, glyph_lfblock },
    { 0x20A4, glyph_lira },
    { 0xF6C0, glyph_ll },
    { 0x2227, glyph_logicaland },
    { 0x00AC, glyph_logicalnot },
    { 0x2228, glyph_logicalor },
    { 0x017F, glyph_longs },
    { 0x25CA, glyph_lozenge },
    { 0x0142, glyph_lslash },
    { 0xF6EE, glyph_lsuperior },
    { 0x2591, glyph_ltshade },
    { 0x006D, glyph_m },
    { 0x00AF, glyph_macron },
/*  { 0x02C9, glyph_macron },  duplicate */
    { 0x2642, glyph_male },
    { 0x2212, glyph_minus },
    { 0x2032, glyph_minute },
    { 0xF6EF, glyph_msuperior },
/*  { 0x00B5, glyph_mu },  duplicate */
    { 0x03BC, glyph_mu },
    { 0x00D7, glyph_multiply },
    { 0x266A, glyph_musicalnote },
    { 0x266B, glyph_musicalnotedbl },
    { 0x006E, glyph_n },
    { 0x0144, glyph_nacute },
    { 0x0149, glyph_napostrophe },
    { 0x0148, glyph_ncaron },
    { 0x0146, glyph_ncommaaccent },
    { 0x0039, glyph_nine },
    { 0x2089, glyph_nineinferior },
    { 0xF739, glyph_nineoldstyle },
    { 0x2079, glyph_ninesuperior },
    { 0x2209, glyph_notelement },
    { 0x2260, glyph_notequal },
    { 0x2284, glyph_notsubset },
    { 0x207F, glyph_nsuperior },
    { 0x00F1, glyph_ntilde },
    { 0x03BD, glyph_nu },
    { 0x0023, glyph_numbersign },
    { 0x006F, glyph_o },
    { 0x00F3, glyph_oacute },
    { 0x014F, glyph_obreve },
    { 0x00F4, glyph_ocircumflex },
    { 0x00F6, glyph_odieresis },
    { 0x0153, glyph_oe },
    { 0x02DB, glyph_ogonek },
    { 0x00F2, glyph_ograve },
    { 0x01A1, glyph_ohorn },
    { 0x0151, glyph_ohungarumlaut },
    { 0x014D, glyph_omacron },
    { 0x03C9, glyph_omega },
    { 0x03D6, glyph_omega1 },
    { 0x03CE, glyph_omegatonos },
    { 0x03BF, glyph_omicron },
    { 0x03CC, glyph_omicrontonos },
    { 0x0031, glyph_one },
    { 0x2024, glyph_onedotenleader },
    { 0x215B, glyph_oneeighth },
    { 0xF6DC, glyph_onefitted },
    { 0x00BD, glyph_onehalf },
    { 0x2081, glyph_oneinferior },
    { 0xF731, glyph_oneoldstyle },
    { 0x00BC, glyph_onequarter },
    { 0x00B9, glyph_onesuperior },
    { 0x2153, glyph_onethird },
    { 0x25E6, glyph_openbullet },
    { 0x00AA, glyph_ordfeminine },
    { 0x00BA, glyph_ordmasculine },
    { 0x221F, glyph_orthogonal },
    { 0x00F8, glyph_oslash },
    { 0x01FF, glyph_oslashacute },
    { 0xF6F0, glyph_osuperior },
    { 0x00F5, glyph_otilde },
    { 0x0070, glyph_p },
    { 0x00B6, glyph_paragraph },
    { 0x0028, glyph_parenleft },
    { 0xF8ED, glyph_parenleftbt },
    { 0xF8EC, glyph_parenleftex },
    { 0x208D, glyph_parenleftinferior },
    { 0x207D, glyph_parenleftsuperior },
    { 0xF8EB, glyph_parenlefttp },
    { 0x0029, glyph_parenright },
    { 0xF8F8, glyph_parenrightbt },
    { 0xF8F7, glyph_parenrightex },
    { 0x208E, glyph_parenrightinferior },
    { 0x207E, glyph_parenrightsuperior },
    { 0xF8F6, glyph_parenrighttp },
    { 0x2202, glyph_partialdiff },
    { 0x0025, glyph_percent },
    { 0x002E, glyph_period },
    { 0x00B7, glyph_periodcentered },
/*  { 0x2219, glyph_periodcentered },  duplicate */
    { 0xF6E7, glyph_periodinferior },
    { 0xF6E8, glyph_periodsuperior },
    { 0x22A5, glyph_perpendicular },
    { 0x2030, glyph_perthousand },
    { 0x20A7, glyph_peseta },
    { 0x03C6, glyph_phi },
    { 0x03D5, glyph_phi1 },
    { 0x03C0, glyph_pi },
    { 0x002B, glyph_plus },
    { 0x00B1, glyph_plusminus },
    { 0x211E, glyph_prescription },
    { 0x220F, glyph_product },
    { 0x2282, glyph_propersubset },
    { 0x2283, glyph_propersuperset },
    { 0x221D, glyph_proportional },
    { 0x03C8, glyph_psi },
    { 0x0071, glyph_q },
    { 0x003F, glyph_question },
    { 0x00BF, glyph_questiondown },
    { 0xF7BF, glyph_questiondownsmall },
    { 0xF73F, glyph_questionsmall },
    { 0x0022, glyph_quotedbl },
    { 0x201E, glyph_quotedblbase },
    { 0x201C, glyph_quotedblleft },
    { 0x201D, glyph_quotedblright },
    { 0x2018, glyph_quoteleft },
    { 0x201B, glyph_quotereversed },
    { 0x2019, glyph_quoteright },
    { 0x201A, glyph_quotesinglbase },
    { 0x0027, glyph_quotesingle },
    { 0x0072, glyph_r },
    { 0x0155, glyph_racute },
    { 0x221A, glyph_radical },
    { 0xF8E5, glyph_radicalex },
    { 0x0159, glyph_rcaron },
    { 0x0157, glyph_rcommaaccent },
    { 0x2286, glyph_reflexsubset },
    { 0x2287, glyph_reflexsuperset },
    { 0x00AE, glyph_registered },
    { 0xF8E8, glyph_registersans },
    { 0xF6DA, glyph_registerserif },
    { 0x2310, glyph_revlogicalnot },
    { 0x03C1, glyph_rho },
    { 0x02DA, glyph_ring },
    { 0xF6F1, glyph_rsuperior },
    { 0x2590, glyph_rtblock },
    { 0xF6DD, glyph_rupiah },
    { 0x0073, glyph_s },
    { 0x015B, glyph_sacute },
    { 0x0161, glyph_scaron },
    { 0x015F, glyph_scedilla },
/*  { 0xF6C2, glyph_scedilla },  duplicate */
    { 0x015D, glyph_scircumflex },
    { 0x0219, glyph_scommaaccent },
    { 0x2033, glyph_second },
    { 0x00A7, glyph_section },
    { 0x003B, glyph_semicolon },
    { 0x0037, glyph_seven },
    { 0x215E, glyph_seveneighths },
    { 0x2087, glyph_seveninferior },
    { 0xF737, glyph_sevenoldstyle },
    { 0x2077, glyph_sevensuperior },
    { 0x2592, glyph_shade },
    { 0x03C3, glyph_sigma },
    { 0x03C2, glyph_sigma1 },
    { 0x223C, glyph_similar },
    { 0x0036, glyph_six },
    { 0x2086, glyph_sixinferior },
    { 0xF736, glyph_sixoldstyle },
    { 0x2076, glyph_sixsuperior },
    { 0x002F, glyph_slash },
    { 0x263A, glyph_smileface },
    { 0x0020, glyph_space },
/*  { 0x00A0, glyph_space },  duplicate */
    { 0x2660, glyph_spade },
    { 0xF6F2, glyph_ssuperior },
    { 0x00A3, glyph_sterling },
    { 0x220B, glyph_suchthat },
    { 0x2211, glyph_summation },
    { 0x263C, glyph_sun },
    { 0x0074, glyph_t },
    { 0x03C4, glyph_tau },
    { 0x0167, glyph_tbar },
    { 0x0165, glyph_tcaron },
    { 0x0163, glyph_tcommaaccent },
/*  { 0x021B, glyph_tcommaaccent },  duplicate */
    { 0x2234, glyph_therefore },
    { 0x03B8, glyph_theta },
    { 0x03D1, glyph_theta1 },
    { 0x00FE, glyph_thorn },
    { 0x0033, glyph_three },
    { 0x215C, glyph_threeeighths },
    { 0x2083, glyph_threeinferior },
    { 0xF733, glyph_threeoldstyle },
    { 0x00BE, glyph_threequarters },
    { 0xF6DE, glyph_threequartersemdash },
    { 0x00B3, glyph_threesuperior },
    { 0x02DC, glyph_tilde },
    { 0x0303, glyph_tildecomb },
    { 0x0384, glyph_tonos },
    { 0x2122, glyph_trademark },
    { 0xF8EA, glyph_trademarksans },
    { 0xF6DB, glyph_trademarkserif },
    { 0x25BC, glyph_triagdn },
    { 0x25C4, glyph_triaglf },
    { 0x25BA, glyph_triagrt },
    { 0x25B2, glyph_triagup },
    { 0xF6F3, glyph_tsuperior },
    { 0x0032, glyph_two },
    { 0x2025, glyph_twodotenleader },
    { 0x2082, glyph_twoinferior },
    { 0xF732, glyph_twooldstyle },
    { 0x00B2, glyph_twosuperior },
    { 0x2154, glyph_twothirds },
    { 0x0075, glyph_u },
    { 0x00FA, glyph_uacute },
    { 0x016D, glyph_ubreve },
    { 0x00FB, glyph_ucircumflex },
    { 0x00FC, glyph_udieresis },
    { 0x00F9, glyph_ugrave },
    { 0x01B0, glyph_uhorn },
    { 0x0171, glyph_uhungarumlaut },
    { 0x016B, glyph_umacron },
    { 0x005F, glyph_underscore },
    { 0x2017, glyph_underscoredbl },
    { 0x222A, glyph_union },
    { 0x2200, glyph_universal },
    { 0x0173, glyph_uogonek },
    { 0x2580, glyph_upblock },
    { 0x03C5, glyph_upsilon },
    { 0x03CB, glyph_upsilondieresis },
    { 0x03B0, glyph_upsilondieresistonos },
    { 0x03CD, glyph_upsilontonos },
    { 0x016F, glyph_uring },
    { 0x0169, glyph_utilde },
    { 0x0076, glyph_v },
    { 0x0077, glyph_w },
    { 0x1E83, glyph_wacute },
    { 0x0175, glyph_wcircumflex },
    { 0x1E85, glyph_wdieresis },
    { 0x2118, glyph_weierstrass },
    { 0x1E81, glyph_wgrave },
    { 0x0078, glyph_x },
    { 0x03BE, glyph_xi },
    { 0x0079, glyph_y },
    { 0x00FD, glyph_yacute },
    { 0x0177, glyph_ycircumflex },
    { 0x00FF, glyph_ydieresis },
    { 0x00A5, glyph_yen },
    { 0x1EF3, glyph_ygrave },
    { 0x007A, glyph_z },
    { 0x017A, glyph_zacute },
    { 0x017E, glyph_zcaron },
    { 0x017C, glyph_zdotaccent },
    { 0x0030, glyph_zero },
    { 0x2080, glyph_zeroinferior },
    { 0xF730, glyph_zerooldstyle },
    { 0x2070, glyph_zerosuperior },
    { 0x03B6, glyph_zeta },
}; /* tab_agl2uni */

static uni_agl tab_uni2agl[] =
{
    { 0x0020, glyph_space },
    { 0x0021, glyph_exclam },
    { 0x0022, glyph_quotedbl },
    { 0x0023, glyph_numbersign },
    { 0x0024, glyph_dollar },
    { 0x0025, glyph_percent },
    { 0x0026, glyph_ampersand },
    { 0x0027, glyph_quotesingle },
    { 0x0028, glyph_parenleft },
    { 0x0029, glyph_parenright },
    { 0x002A, glyph_asterisk },
    { 0x002B, glyph_plus },
    { 0x002C, glyph_comma },
    { 0x002D, glyph_hyphen },
    { 0x002E, glyph_period },
    { 0x002F, glyph_slash },
    { 0x0030, glyph_zero },
    { 0x0031, glyph_one },
    { 0x0032, glyph_two },
    { 0x0033, glyph_three },
    { 0x0034, glyph_four },
    { 0x0035, glyph_five },
    { 0x0036, glyph_six },
    { 0x0037, glyph_seven },
    { 0x0038, glyph_eight },
    { 0x0039, glyph_nine },
    { 0x003A, glyph_colon },
    { 0x003B, glyph_semicolon },
    { 0x003C, glyph_less },
    { 0x003D, glyph_equal },
    { 0x003E, glyph_greater },
    { 0x003F, glyph_question },
    { 0x0040, glyph_at },
    { 0x0041, glyph_A },
    { 0x0042, glyph_B },
    { 0x0043, glyph_C },
    { 0x0044, glyph_D },
    { 0x0045, glyph_E },
    { 0x0046, glyph_F },
    { 0x0047, glyph_G },
    { 0x0048, glyph_H },
    { 0x0049, glyph_I },
    { 0x004A, glyph_J },
    { 0x004B, glyph_K },
    { 0x004C, glyph_L },
    { 0x004D, glyph_M },
    { 0x004E, glyph_N },
    { 0x004F, glyph_O },
    { 0x0050, glyph_P },
    { 0x0051, glyph_Q },
    { 0x0052, glyph_R },
    { 0x0053, glyph_S },
    { 0x0054, glyph_T },
    { 0x0055, glyph_U },
    { 0x0056, glyph_V },
    { 0x0057, glyph_W },
    { 0x0058, glyph_X },
    { 0x0059, glyph_Y },
    { 0x005A, glyph_Z },
    { 0x005B, glyph_bracketleft },
    { 0x005C, glyph_backslash },
    { 0x005D, glyph_bracketright },
    { 0x005E, glyph_asciicircum },
    { 0x005F, glyph_underscore },
    { 0x0060, glyph_grave },
    { 0x0061, glyph_a },
    { 0x0062, glyph_b },
    { 0x0063, glyph_c },
    { 0x0064, glyph_d },
    { 0x0065, glyph_e },
    { 0x0066, glyph_f },
    { 0x0067, glyph_g },
    { 0x0068, glyph_h },
    { 0x0069, glyph_i },
    { 0x006A, glyph_j },
    { 0x006B, glyph_k },
    { 0x006C, glyph_l },
    { 0x006D, glyph_m },
    { 0x006E, glyph_n },
    { 0x006F, glyph_o },
    { 0x0070, glyph_p },
    { 0x0071, glyph_q },
    { 0x0072, glyph_r },
    { 0x0073, glyph_s },
    { 0x0074, glyph_t },
    { 0x0075, glyph_u },
    { 0x0076, glyph_v },
    { 0x0077, glyph_w },
    { 0x0078, glyph_x },
    { 0x0079, glyph_y },
    { 0x007A, glyph_z },
    { 0x007B, glyph_braceleft },
    { 0x007C, glyph_bar },
    { 0x007D, glyph_braceright },
    { 0x007E, glyph_asciitilde },
    { 0x00A0, glyph_space },
    { 0x00A1, glyph_exclamdown },
    { 0x00A2, glyph_cent },
    { 0x00A3, glyph_sterling },
    { 0x00A4, glyph_currency },
    { 0x00A5, glyph_yen },
    { 0x00A6, glyph_brokenbar },
    { 0x00A7, glyph_section },
    { 0x00A8, glyph_dieresis },
    { 0x00A9, glyph_copyright },
    { 0x00AA, glyph_ordfeminine },
    { 0x00AB, glyph_guillemotleft },
    { 0x00AC, glyph_logicalnot },
    { 0x00AD, glyph_hyphen },
    { 0x00AE, glyph_registered },
    { 0x00AF, glyph_macron },
    { 0x00B0, glyph_degree },
    { 0x00B1, glyph_plusminus },
    { 0x00B2, glyph_twosuperior },
    { 0x00B3, glyph_threesuperior },
    { 0x00B4, glyph_acute },
    { 0x00B5, glyph_mu },
    { 0x00B6, glyph_paragraph },
    { 0x00B7, glyph_periodcentered },
    { 0x00B8, glyph_cedilla },
    { 0x00B9, glyph_onesuperior },
    { 0x00BA, glyph_ordmasculine },
    { 0x00BB, glyph_guillemotright },
    { 0x00BC, glyph_onequarter },
    { 0x00BD, glyph_onehalf },
    { 0x00BE, glyph_threequarters },
    { 0x00BF, glyph_questiondown },
    { 0x00C0, glyph_Agrave },
    { 0x00C1, glyph_Aacute },
    { 0x00C2, glyph_Acircumflex },
    { 0x00C3, glyph_Atilde },
    { 0x00C4, glyph_Adieresis },
    { 0x00C5, glyph_Aring },
    { 0x00C6, glyph_AE },
    { 0x00C7, glyph_Ccedilla },
    { 0x00C8, glyph_Egrave },
    { 0x00C9, glyph_Eacute },
    { 0x00CA, glyph_Ecircumflex },
    { 0x00CB, glyph_Edieresis },
    { 0x00CC, glyph_Igrave },
    { 0x00CD, glyph_Iacute },
    { 0x00CE, glyph_Icircumflex },
    { 0x00CF, glyph_Idieresis },
    { 0x00D0, glyph_Eth },
    { 0x00D1, glyph_Ntilde },
    { 0x00D2, glyph_Ograve },
    { 0x00D3, glyph_Oacute },
    { 0x00D4, glyph_Ocircumflex },
    { 0x00D5, glyph_Otilde },
    { 0x00D6, glyph_Odieresis },
    { 0x00D7, glyph_multiply },
    { 0x00D8, glyph_Oslash },
    { 0x00D9, glyph_Ugrave },
    { 0x00DA, glyph_Uacute },
    { 0x00DB, glyph_Ucircumflex },
    { 0x00DC, glyph_Udieresis },
    { 0x00DD, glyph_Yacute },
    { 0x00DE, glyph_Thorn },
    { 0x00DF, glyph_germandbls },
    { 0x00E0, glyph_agrave },
    { 0x00E1, glyph_aacute },
    { 0x00E2, glyph_acircumflex },
    { 0x00E3, glyph_atilde },
    { 0x00E4, glyph_adieresis },
    { 0x00E5, glyph_aring },
    { 0x00E6, glyph_ae },
    { 0x00E7, glyph_ccedilla },
    { 0x00E8, glyph_egrave },
    { 0x00E9, glyph_eacute },
    { 0x00EA, glyph_ecircumflex },
    { 0x00EB, glyph_edieresis },
    { 0x00EC, glyph_igrave },
    { 0x00ED, glyph_iacute },
    { 0x00EE, glyph_icircumflex },
    { 0x00EF, glyph_idieresis },
    { 0x00F0, glyph_eth },
    { 0x00F1, glyph_ntilde },
    { 0x00F2, glyph_ograve },
    { 0x00F3, glyph_oacute },
    { 0x00F4, glyph_ocircumflex },
    { 0x00F5, glyph_otilde },
    { 0x00F6, glyph_odieresis },
    { 0x00F7, glyph_divide },
    { 0x00F8, glyph_oslash },
    { 0x00F9, glyph_ugrave },
    { 0x00FA, glyph_uacute },
    { 0x00FB, glyph_ucircumflex },
    { 0x00FC, glyph_udieresis },
    { 0x00FD, glyph_yacute },
    { 0x00FE, glyph_thorn },
    { 0x00FF, glyph_ydieresis },
    { 0x0100, glyph_Amacron },
    { 0x0101, glyph_amacron },
    { 0x0102, glyph_Abreve },
    { 0x0103, glyph_abreve },
    { 0x0104, glyph_Aogonek },
    { 0x0105, glyph_aogonek },
    { 0x0106, glyph_Cacute },
    { 0x0107, glyph_cacute },
    { 0x0108, glyph_Ccircumflex },
    { 0x0109, glyph_ccircumflex },
    { 0x010A, glyph_Cdotaccent },
    { 0x010B, glyph_cdotaccent },
    { 0x010C, glyph_Ccaron },
    { 0x010D, glyph_ccaron },
    { 0x010E, glyph_Dcaron },
    { 0x010F, glyph_dcaron },
    { 0x0110, glyph_Dcroat },
    { 0x0111, glyph_dcroat },
    { 0x0112, glyph_Emacron },
    { 0x0113, glyph_emacron },
    { 0x0114, glyph_Ebreve },
    { 0x0115, glyph_ebreve },
    { 0x0116, glyph_Edotaccent },
    { 0x0117, glyph_edotaccent },
    { 0x0118, glyph_Eogonek },
    { 0x0119, glyph_eogonek },
    { 0x011A, glyph_Ecaron },
    { 0x011B, glyph_ecaron },
    { 0x011C, glyph_Gcircumflex },
    { 0x011D, glyph_gcircumflex },
    { 0x011E, glyph_Gbreve },
    { 0x011F, glyph_gbreve },
    { 0x0120, glyph_Gdotaccent },
    { 0x0121, glyph_gdotaccent },
    { 0x0122, glyph_Gcommaaccent },
    { 0x0123, glyph_gcommaaccent },
    { 0x0124, glyph_Hcircumflex },
    { 0x0125, glyph_hcircumflex },
    { 0x0126, glyph_Hbar },
    { 0x0127, glyph_hbar },
    { 0x0128, glyph_Itilde },
    { 0x0129, glyph_itilde },
    { 0x012A, glyph_Imacron },
    { 0x012B, glyph_imacron },
    { 0x012C, glyph_Ibreve },
    { 0x012D, glyph_ibreve },
    { 0x012E, glyph_Iogonek },
    { 0x012F, glyph_iogonek },
    { 0x0130, glyph_Idotaccent },
    { 0x0131, glyph_dotlessi },
    { 0x0132, glyph_IJ },
    { 0x0133, glyph_ij },
    { 0x0134, glyph_Jcircumflex },
    { 0x0135, glyph_jcircumflex },
    { 0x0136, glyph_Kcommaaccent },
    { 0x0137, glyph_kcommaaccent },
    { 0x0138, glyph_kgreenlandic },
    { 0x0139, glyph_Lacute },
    { 0x013A, glyph_lacute },
    { 0x013B, glyph_Lcommaaccent },
    { 0x013C, glyph_lcommaaccent },
    { 0x013D, glyph_Lcaron },
    { 0x013E, glyph_lcaron },
    { 0x013F, glyph_Ldot },
    { 0x0140, glyph_ldot },
    { 0x0141, glyph_Lslash },
    { 0x0142, glyph_lslash },
    { 0x0143, glyph_Nacute },
    { 0x0144, glyph_nacute },
    { 0x0145, glyph_Ncommaaccent },
    { 0x0146, glyph_ncommaaccent },
    { 0x0147, glyph_Ncaron },
    { 0x0148, glyph_ncaron },
    { 0x0149, glyph_napostrophe },
    { 0x014A, glyph_Eng },
    { 0x014B, glyph_eng },
    { 0x014C, glyph_Omacron },
    { 0x014D, glyph_omacron },
    { 0x014E, glyph_Obreve },
    { 0x014F, glyph_obreve },
    { 0x0150, glyph_Ohungarumlaut },
    { 0x0151, glyph_ohungarumlaut },
    { 0x0152, glyph_OE },
    { 0x0153, glyph_oe },
    { 0x0154, glyph_Racute },
    { 0x0155, glyph_racute },
    { 0x0156, glyph_Rcommaaccent },
    { 0x0157, glyph_rcommaaccent },
    { 0x0158, glyph_Rcaron },
    { 0x0159, glyph_rcaron },
    { 0x015A, glyph_Sacute },
    { 0x015B, glyph_sacute },
    { 0x015C, glyph_Scircumflex },
    { 0x015D, glyph_scircumflex },
    { 0x015E, glyph_Scedilla },
    { 0x015F, glyph_scedilla },
    { 0x0160, glyph_Scaron },
    { 0x0161, glyph_scaron },
    { 0x0162, glyph_Tcommaaccent },
    { 0x0163, glyph_tcommaaccent },
    { 0x0164, glyph_Tcaron },
    { 0x0165, glyph_tcaron },
    { 0x0166, glyph_Tbar },
    { 0x0167, glyph_tbar },
    { 0x0168, glyph_Utilde },
    { 0x0169, glyph_utilde },
    { 0x016A, glyph_Umacron },
    { 0x016B, glyph_umacron },
    { 0x016C, glyph_Ubreve },
    { 0x016D, glyph_ubreve },
    { 0x016E, glyph_Uring },
    { 0x016F, glyph_uring },
    { 0x0170, glyph_Uhungarumlaut },
    { 0x0171, glyph_uhungarumlaut },
    { 0x0172, glyph_Uogonek },
    { 0x0173, glyph_uogonek },
    { 0x0174, glyph_Wcircumflex },
    { 0x0175, glyph_wcircumflex },
    { 0x0176, glyph_Ycircumflex },
    { 0x0177, glyph_ycircumflex },
    { 0x0178, glyph_Ydieresis },
    { 0x0179, glyph_Zacute },
    { 0x017A, glyph_zacute },
    { 0x017B, glyph_Zdotaccent },
    { 0x017C, glyph_zdotaccent },
    { 0x017D, glyph_Zcaron },
    { 0x017E, glyph_zcaron },
    { 0x017F, glyph_longs },
    { 0x0192, glyph_florin },
    { 0x01A0, glyph_Ohorn },
    { 0x01A1, glyph_ohorn },
    { 0x01AF, glyph_Uhorn },
    { 0x01B0, glyph_uhorn },
    { 0x01E6, glyph_Gcaron },
    { 0x01E7, glyph_gcaron },
    { 0x01FA, glyph_Aringacute },
    { 0x01FB, glyph_aringacute },
    { 0x01FC, glyph_AEacute },
    { 0x01FD, glyph_aeacute },
    { 0x01FE, glyph_Oslashacute },
    { 0x01FF, glyph_oslashacute },
    { 0x0218, glyph_Scommaaccent },
    { 0x0219, glyph_scommaaccent },
    { 0x021A, glyph_Tcommaaccent },
    { 0x021B, glyph_tcommaaccent },
    { 0x02BC, glyph_afii57929 },
    { 0x02BD, glyph_afii64937 },
    { 0x02C6, glyph_circumflex },
    { 0x02C7, glyph_caron },
    { 0x02C9, glyph_macron },
    { 0x02D8, glyph_breve },
    { 0x02D9, glyph_dotaccent },
    { 0x02DA, glyph_ring },
    { 0x02DB, glyph_ogonek },
    { 0x02DC, glyph_tilde },
    { 0x02DD, glyph_hungarumlaut },
    { 0x0300, glyph_gravecomb },
    { 0x0301, glyph_acutecomb },
    { 0x0303, glyph_tildecomb },
    { 0x0309, glyph_hookabovecomb },
    { 0x0323, glyph_dotbelowcomb },
    { 0x0384, glyph_tonos },
    { 0x0385, glyph_dieresistonos },
    { 0x0386, glyph_Alphatonos },
    { 0x0387, glyph_anoteleia },
    { 0x0388, glyph_Epsilontonos },
    { 0x0389, glyph_Etatonos },
    { 0x038A, glyph_Iotatonos },
    { 0x038C, glyph_Omicrontonos },
    { 0x038E, glyph_Upsilontonos },
    { 0x038F, glyph_Omegatonos },
    { 0x0390, glyph_iotadieresistonos },
    { 0x0391, glyph_Alpha },
    { 0x0392, glyph_Beta },
    { 0x0393, glyph_Gamma },
    { 0x0394, glyph_Delta },
    { 0x0395, glyph_Epsilon },
    { 0x0396, glyph_Zeta },
    { 0x0397, glyph_Eta },
    { 0x0398, glyph_Theta },
    { 0x0399, glyph_Iota },
    { 0x039A, glyph_Kappa },
    { 0x039B, glyph_Lambda },
    { 0x039C, glyph_Mu },
    { 0x039D, glyph_Nu },
    { 0x039E, glyph_Xi },
    { 0x039F, glyph_Omicron },
    { 0x03A0, glyph_Pi },
    { 0x03A1, glyph_Rho },
    { 0x03A3, glyph_Sigma },
    { 0x03A4, glyph_Tau },
    { 0x03A5, glyph_Upsilon },
    { 0x03A6, glyph_Phi },
    { 0x03A7, glyph_Chi },
    { 0x03A8, glyph_Psi },
    { 0x03A9, glyph_Omega },
    { 0x03AA, glyph_Iotadieresis },
    { 0x03AB, glyph_Upsilondieresis },
    { 0x03AC, glyph_alphatonos },
    { 0x03AD, glyph_epsilontonos },
    { 0x03AE, glyph_etatonos },
    { 0x03AF, glyph_iotatonos },
    { 0x03B0, glyph_upsilondieresistonos },
    { 0x03B1, glyph_alpha },
    { 0x03B2, glyph_beta },
    { 0x03B3, glyph_gamma },
    { 0x03B4, glyph_delta },
    { 0x03B5, glyph_epsilon },
    { 0x03B6, glyph_zeta },
    { 0x03B7, glyph_eta },
    { 0x03B8, glyph_theta },
    { 0x03B9, glyph_iota },
    { 0x03BA, glyph_kappa },
    { 0x03BB, glyph_lambda },
    { 0x03BC, glyph_mu },
    { 0x03BD, glyph_nu },
    { 0x03BE, glyph_xi },
    { 0x03BF, glyph_omicron },
    { 0x03C0, glyph_pi },
    { 0x03C1, glyph_rho },
    { 0x03C2, glyph_sigma1 },
    { 0x03C3, glyph_sigma },
    { 0x03C4, glyph_tau },
    { 0x03C5, glyph_upsilon },
    { 0x03C6, glyph_phi },
    { 0x03C7, glyph_chi },
    { 0x03C8, glyph_psi },
    { 0x03C9, glyph_omega },
    { 0x03CA, glyph_iotadieresis },
    { 0x03CB, glyph_upsilondieresis },
    { 0x03CC, glyph_omicrontonos },
    { 0x03CD, glyph_upsilontonos },
    { 0x03CE, glyph_omegatonos },
    { 0x03D1, glyph_theta1 },
    { 0x03D2, glyph_Upsilon1 },
    { 0x03D5, glyph_phi1 },
    { 0x03D6, glyph_omega1 },
    { 0x0401, glyph_afii10023 },
    { 0x0402, glyph_afii10051 },
    { 0x0403, glyph_afii10052 },
    { 0x0404, glyph_afii10053 },
    { 0x0405, glyph_afii10054 },
    { 0x0406, glyph_afii10055 },
    { 0x0407, glyph_afii10056 },
    { 0x0408, glyph_afii10057 },
    { 0x0409, glyph_afii10058 },
    { 0x040A, glyph_afii10059 },
    { 0x040B, glyph_afii10060 },
    { 0x040C, glyph_afii10061 },
    { 0x040E, glyph_afii10062 },
    { 0x040F, glyph_afii10145 },
    { 0x0410, glyph_afii10017 },
    { 0x0411, glyph_afii10018 },
    { 0x0412, glyph_afii10019 },
    { 0x0413, glyph_afii10020 },
    { 0x0414, glyph_afii10021 },
    { 0x0415, glyph_afii10022 },
    { 0x0416, glyph_afii10024 },
    { 0x0417, glyph_afii10025 },
    { 0x0418, glyph_afii10026 },
    { 0x0419, glyph_afii10027 },
    { 0x041A, glyph_afii10028 },
    { 0x041B, glyph_afii10029 },
    { 0x041C, glyph_afii10030 },
    { 0x041D, glyph_afii10031 },
    { 0x041E, glyph_afii10032 },
    { 0x041F, glyph_afii10033 },
    { 0x0420, glyph_afii10034 },
    { 0x0421, glyph_afii10035 },
    { 0x0422, glyph_afii10036 },
    { 0x0423, glyph_afii10037 },
    { 0x0424, glyph_afii10038 },
    { 0x0425, glyph_afii10039 },
    { 0x0426, glyph_afii10040 },
    { 0x0427, glyph_afii10041 },
    { 0x0428, glyph_afii10042 },
    { 0x0429, glyph_afii10043 },
    { 0x042A, glyph_afii10044 },
    { 0x042B, glyph_afii10045 },
    { 0x042C, glyph_afii10046 },
    { 0x042D, glyph_afii10047 },
    { 0x042E, glyph_afii10048 },
    { 0x042F, glyph_afii10049 },
    { 0x0430, glyph_afii10065 },
    { 0x0431, glyph_afii10066 },
    { 0x0432, glyph_afii10067 },
    { 0x0433, glyph_afii10068 },
    { 0x0434, glyph_afii10069 },
    { 0x0435, glyph_afii10070 },
    { 0x0436, glyph_afii10072 },
    { 0x0437, glyph_afii10073 },
    { 0x0438, glyph_afii10074 },
    { 0x0439, glyph_afii10075 },
    { 0x043A, glyph_afii10076 },
    { 0x043B, glyph_afii10077 },
    { 0x043C, glyph_afii10078 },
    { 0x043D, glyph_afii10079 },
    { 0x043E, glyph_afii10080 },
    { 0x043F, glyph_afii10081 },
    { 0x0440, glyph_afii10082 },
    { 0x0441, glyph_afii10083 },
    { 0x0442, glyph_afii10084 },
    { 0x0443, glyph_afii10085 },
    { 0x0444, glyph_afii10086 },
    { 0x0445, glyph_afii10087 },
    { 0x0446, glyph_afii10088 },
    { 0x0447, glyph_afii10089 },
    { 0x0448, glyph_afii10090 },
    { 0x0449, glyph_afii10091 },
    { 0x044A, glyph_afii10092 },
    { 0x044B, glyph_afii10093 },
    { 0x044C, glyph_afii10094 },
    { 0x044D, glyph_afii10095 },
    { 0x044E, glyph_afii10096 },
    { 0x044F, glyph_afii10097 },
    { 0x0451, glyph_afii10071 },
    { 0x0452, glyph_afii10099 },
    { 0x0453, glyph_afii10100 },
    { 0x0454, glyph_afii10101 },
    { 0x0455, glyph_afii10102 },
    { 0x0456, glyph_afii10103 },
    { 0x0457, glyph_afii10104 },
    { 0x0458, glyph_afii10105 },
    { 0x0459, glyph_afii10106 },
    { 0x045A, glyph_afii10107 },
    { 0x045B, glyph_afii10108 },
    { 0x045C, glyph_afii10109 },
    { 0x045E, glyph_afii10110 },
    { 0x045F, glyph_afii10193 },
    { 0x0462, glyph_afii10146 },
    { 0x0463, glyph_afii10194 },
    { 0x0472, glyph_afii10147 },
    { 0x0473, glyph_afii10195 },
    { 0x0474, glyph_afii10148 },
    { 0x0475, glyph_afii10196 },
    { 0x0490, glyph_afii10050 },
    { 0x0491, glyph_afii10098 },
    { 0x04D9, glyph_afii10846 },
    { 0x05B0, glyph_afii57799 },
    { 0x05B1, glyph_afii57801 },
    { 0x05B2, glyph_afii57800 },
    { 0x05B3, glyph_afii57802 },
    { 0x05B4, glyph_afii57793 },
    { 0x05B5, glyph_afii57794 },
    { 0x05B6, glyph_afii57795 },
    { 0x05B7, glyph_afii57798 },
    { 0x05B8, glyph_afii57797 },
    { 0x05B9, glyph_afii57806 },
    { 0x05BB, glyph_afii57796 },
    { 0x05BC, glyph_afii57807 },
    { 0x05BD, glyph_afii57839 },
    { 0x05BE, glyph_afii57645 },
    { 0x05BF, glyph_afii57841 },
    { 0x05C0, glyph_afii57842 },
    { 0x05C1, glyph_afii57804 },
    { 0x05C2, glyph_afii57803 },
    { 0x05C3, glyph_afii57658 },
    { 0x05D0, glyph_afii57664 },
    { 0x05D1, glyph_afii57665 },
    { 0x05D2, glyph_afii57666 },
    { 0x05D3, glyph_afii57667 },
    { 0x05D4, glyph_afii57668 },
    { 0x05D5, glyph_afii57669 },
    { 0x05D6, glyph_afii57670 },
    { 0x05D7, glyph_afii57671 },
    { 0x05D8, glyph_afii57672 },
    { 0x05D9, glyph_afii57673 },
    { 0x05DA, glyph_afii57674 },
    { 0x05DB, glyph_afii57675 },
    { 0x05DC, glyph_afii57676 },
    { 0x05DD, glyph_afii57677 },
    { 0x05DE, glyph_afii57678 },
    { 0x05DF, glyph_afii57679 },
    { 0x05E0, glyph_afii57680 },
    { 0x05E1, glyph_afii57681 },
    { 0x05E2, glyph_afii57682 },
    { 0x05E3, glyph_afii57683 },
    { 0x05E4, glyph_afii57684 },
    { 0x05E5, glyph_afii57685 },
    { 0x05E6, glyph_afii57686 },
    { 0x05E7, glyph_afii57687 },
    { 0x05E8, glyph_afii57688 },
    { 0x05E9, glyph_afii57689 },
    { 0x05EA, glyph_afii57690 },
    { 0x05F0, glyph_afii57716 },
    { 0x05F1, glyph_afii57717 },
    { 0x05F2, glyph_afii57718 },
    { 0x060C, glyph_afii57388 },
    { 0x061B, glyph_afii57403 },
    { 0x061F, glyph_afii57407 },
    { 0x0621, glyph_afii57409 },
    { 0x0622, glyph_afii57410 },
    { 0x0623, glyph_afii57411 },
    { 0x0624, glyph_afii57412 },
    { 0x0625, glyph_afii57413 },
    { 0x0626, glyph_afii57414 },
    { 0x0627, glyph_afii57415 },
    { 0x0628, glyph_afii57416 },
    { 0x0629, glyph_afii57417 },
    { 0x062A, glyph_afii57418 },
    { 0x062B, glyph_afii57419 },
    { 0x062C, glyph_afii57420 },
    { 0x062D, glyph_afii57421 },
    { 0x062E, glyph_afii57422 },
    { 0x062F, glyph_afii57423 },
    { 0x0630, glyph_afii57424 },
    { 0x0631, glyph_afii57425 },
    { 0x0632, glyph_afii57426 },
    { 0x0633, glyph_afii57427 },
    { 0x0634, glyph_afii57428 },
    { 0x0635, glyph_afii57429 },
    { 0x0636, glyph_afii57430 },
    { 0x0637, glyph_afii57431 },
    { 0x0638, glyph_afii57432 },
    { 0x0639, glyph_afii57433 },
    { 0x063A, glyph_afii57434 },
    { 0x0640, glyph_afii57440 },
    { 0x0641, glyph_afii57441 },
    { 0x0642, glyph_afii57442 },
    { 0x0643, glyph_afii57443 },
    { 0x0644, glyph_afii57444 },
    { 0x0645, glyph_afii57445 },
    { 0x0646, glyph_afii57446 },
    { 0x0647, glyph_afii57470 },
    { 0x0648, glyph_afii57448 },
    { 0x0649, glyph_afii57449 },
    { 0x064A, glyph_afii57450 },
    { 0x064B, glyph_afii57451 },
    { 0x064C, glyph_afii57452 },
    { 0x064D, glyph_afii57453 },
    { 0x064E, glyph_afii57454 },
    { 0x064F, glyph_afii57455 },
    { 0x0650, glyph_afii57456 },
    { 0x0651, glyph_afii57457 },
    { 0x0652, glyph_afii57458 },
    { 0x0660, glyph_afii57392 },
    { 0x0661, glyph_afii57393 },
    { 0x0662, glyph_afii57394 },
    { 0x0663, glyph_afii57395 },
    { 0x0664, glyph_afii57396 },
    { 0x0665, glyph_afii57397 },
    { 0x0666, glyph_afii57398 },
    { 0x0667, glyph_afii57399 },
    { 0x0668, glyph_afii57400 },
    { 0x0669, glyph_afii57401 },
    { 0x066A, glyph_afii57381 },
    { 0x066D, glyph_afii63167 },
    { 0x0679, glyph_afii57511 },
    { 0x067E, glyph_afii57506 },
    { 0x0686, glyph_afii57507 },
    { 0x0688, glyph_afii57512 },
    { 0x0691, glyph_afii57513 },
    { 0x0698, glyph_afii57508 },
    { 0x06A4, glyph_afii57505 },
    { 0x06AF, glyph_afii57509 },
    { 0x06BA, glyph_afii57514 },
    { 0x06D2, glyph_afii57519 },
    { 0x06D5, glyph_afii57534 },
    { 0x1E80, glyph_Wgrave },
    { 0x1E81, glyph_wgrave },
    { 0x1E82, glyph_Wacute },
    { 0x1E83, glyph_wacute },
    { 0x1E84, glyph_Wdieresis },
    { 0x1E85, glyph_wdieresis },
    { 0x1EF2, glyph_Ygrave },
    { 0x1EF3, glyph_ygrave },
    { 0x200C, glyph_afii61664 },
    { 0x200D, glyph_afii301 },
    { 0x200E, glyph_afii299 },
    { 0x200F, glyph_afii300 },
    { 0x2012, glyph_figuredash },
    { 0x2013, glyph_endash },
    { 0x2014, glyph_emdash },
    { 0x2015, glyph_afii00208 },
    { 0x2017, glyph_underscoredbl },
    { 0x2018, glyph_quoteleft },
    { 0x2019, glyph_quoteright },
    { 0x201A, glyph_quotesinglbase },
    { 0x201B, glyph_quotereversed },
    { 0x201C, glyph_quotedblleft },
    { 0x201D, glyph_quotedblright },
    { 0x201E, glyph_quotedblbase },
    { 0x2020, glyph_dagger },
    { 0x2021, glyph_daggerdbl },
    { 0x2022, glyph_bullet },
    { 0x2024, glyph_onedotenleader },
    { 0x2025, glyph_twodotenleader },
    { 0x2026, glyph_ellipsis },
    { 0x202C, glyph_afii61573 },
    { 0x202D, glyph_afii61574 },
    { 0x202E, glyph_afii61575 },
    { 0x2030, glyph_perthousand },
    { 0x2032, glyph_minute },
    { 0x2033, glyph_second },
    { 0x2039, glyph_guilsinglleft },
    { 0x203A, glyph_guilsinglright },
    { 0x203C, glyph_exclamdbl },
    { 0x2044, glyph_fraction },
    { 0x2070, glyph_zerosuperior },
    { 0x2074, glyph_foursuperior },
    { 0x2075, glyph_fivesuperior },
    { 0x2076, glyph_sixsuperior },
    { 0x2077, glyph_sevensuperior },
    { 0x2078, glyph_eightsuperior },
    { 0x2079, glyph_ninesuperior },
    { 0x207D, glyph_parenleftsuperior },
    { 0x207E, glyph_parenrightsuperior },
    { 0x207F, glyph_nsuperior },
    { 0x2080, glyph_zeroinferior },
    { 0x2081, glyph_oneinferior },
    { 0x2082, glyph_twoinferior },
    { 0x2083, glyph_threeinferior },
    { 0x2084, glyph_fourinferior },
    { 0x2085, glyph_fiveinferior },
    { 0x2086, glyph_sixinferior },
    { 0x2087, glyph_seveninferior },
    { 0x2088, glyph_eightinferior },
    { 0x2089, glyph_nineinferior },
    { 0x208D, glyph_parenleftinferior },
    { 0x208E, glyph_parenrightinferior },
    { 0x20A1, glyph_colonmonetary },
    { 0x20A3, glyph_franc },
    { 0x20A4, glyph_lira },
    { 0x20A7, glyph_peseta },
    { 0x20AA, glyph_afii57636 },
    { 0x20AB, glyph_dong },
    { 0x20AC, glyph_Euro },
    { 0x2105, glyph_afii61248 },
    { 0x2111, glyph_Ifraktur },
    { 0x2113, glyph_afii61289 },
    { 0x2116, glyph_afii61352 },
    { 0x2118, glyph_weierstrass },
    { 0x211C, glyph_Rfraktur },
    { 0x211E, glyph_prescription },
    { 0x2122, glyph_trademark },
    { 0x2126, glyph_Omega },
    { 0x212E, glyph_estimated },
    { 0x2135, glyph_aleph },
    { 0x2153, glyph_onethird },
    { 0x2154, glyph_twothirds },
    { 0x215B, glyph_oneeighth },
    { 0x215C, glyph_threeeighths },
    { 0x215D, glyph_fiveeighths },
    { 0x215E, glyph_seveneighths },
    { 0x2190, glyph_arrowleft },
    { 0x2191, glyph_arrowup },
    { 0x2192, glyph_arrowright },
    { 0x2193, glyph_arrowdown },
    { 0x2194, glyph_arrowboth },
    { 0x2195, glyph_arrowupdn },
    { 0x21A8, glyph_arrowupdnbse },
    { 0x21B5, glyph_carriagereturn },
    { 0x21D0, glyph_arrowdblleft },
    { 0x21D1, glyph_arrowdblup },
    { 0x21D2, glyph_arrowdblright },
    { 0x21D3, glyph_arrowdbldown },
    { 0x21D4, glyph_arrowdblboth },
    { 0x2200, glyph_universal },
    { 0x2202, glyph_partialdiff },
    { 0x2203, glyph_existential },
    { 0x2205, glyph_emptyset },
    { 0x2206, glyph_Delta },
    { 0x2207, glyph_gradient },
    { 0x2208, glyph_element },
    { 0x2209, glyph_notelement },
    { 0x220B, glyph_suchthat },
    { 0x220F, glyph_product },
    { 0x2211, glyph_summation },
    { 0x2212, glyph_minus },
    { 0x2215, glyph_fraction },
    { 0x2217, glyph_asteriskmath },
    { 0x2219, glyph_periodcentered },
    { 0x221A, glyph_radical },
    { 0x221D, glyph_proportional },
    { 0x221E, glyph_infinity },
    { 0x221F, glyph_orthogonal },
    { 0x2220, glyph_angle },
    { 0x2227, glyph_logicaland },
    { 0x2228, glyph_logicalor },
    { 0x2229, glyph_intersection },
    { 0x222A, glyph_union },
    { 0x222B, glyph_integral },
    { 0x2234, glyph_therefore },
    { 0x223C, glyph_similar },
    { 0x2245, glyph_congruent },
    { 0x2248, glyph_approxequal },
    { 0x2260, glyph_notequal },
    { 0x2261, glyph_equivalence },
    { 0x2264, glyph_lessequal },
    { 0x2265, glyph_greaterequal },
    { 0x2282, glyph_propersubset },
    { 0x2283, glyph_propersuperset },
    { 0x2284, glyph_notsubset },
    { 0x2286, glyph_reflexsubset },
    { 0x2287, glyph_reflexsuperset },
    { 0x2295, glyph_circleplus },
    { 0x2297, glyph_circlemultiply },
    { 0x22A5, glyph_perpendicular },
    { 0x22C5, glyph_dotmath },
    { 0x2302, glyph_house },
    { 0x2310, glyph_revlogicalnot },
    { 0x2320, glyph_integraltp },
    { 0x2321, glyph_integralbt },
    { 0x2329, glyph_angleleft },
    { 0x232A, glyph_angleright },
    { 0x2500, glyph_SF100000 },
    { 0x2502, glyph_SF110000 },
    { 0x250C, glyph_SF010000 },
    { 0x2510, glyph_SF030000 },
    { 0x2514, glyph_SF020000 },
    { 0x2518, glyph_SF040000 },
    { 0x251C, glyph_SF080000 },
    { 0x2524, glyph_SF090000 },
    { 0x252C, glyph_SF060000 },
    { 0x2534, glyph_SF070000 },
    { 0x253C, glyph_SF050000 },
    { 0x2550, glyph_SF430000 },
    { 0x2551, glyph_SF240000 },
    { 0x2552, glyph_SF510000 },
    { 0x2553, glyph_SF520000 },
    { 0x2554, glyph_SF390000 },
    { 0x2555, glyph_SF220000 },
    { 0x2556, glyph_SF210000 },
    { 0x2557, glyph_SF250000 },
    { 0x2558, glyph_SF500000 },
    { 0x2559, glyph_SF490000 },
    { 0x255A, glyph_SF380000 },
    { 0x255B, glyph_SF280000 },
    { 0x255C, glyph_SF270000 },
    { 0x255D, glyph_SF260000 },
    { 0x255E, glyph_SF360000 },
    { 0x255F, glyph_SF370000 },
    { 0x2560, glyph_SF420000 },
    { 0x2561, glyph_SF190000 },
    { 0x2562, glyph_SF200000 },
    { 0x2563, glyph_SF230000 },
    { 0x2564, glyph_SF470000 },
    { 0x2565, glyph_SF480000 },
    { 0x2566, glyph_SF410000 },
    { 0x2567, glyph_SF450000 },
    { 0x2568, glyph_SF460000 },
    { 0x2569, glyph_SF400000 },
    { 0x256A, glyph_SF540000 },
    { 0x256B, glyph_SF530000 },
    { 0x256C, glyph_SF440000 },
    { 0x2580, glyph_upblock },
    { 0x2584, glyph_dnblock },
    { 0x2588, glyph_block },
    { 0x258C, glyph_lfblock },
    { 0x2590, glyph_rtblock },
    { 0x2591, glyph_ltshade },
    { 0x2592, glyph_shade },
    { 0x2593, glyph_dkshade },
    { 0x25A0, glyph_filledbox },
    { 0x25A1, glyph_H22073 },
    { 0x25AA, glyph_H18543 },
    { 0x25AB, glyph_H18551 },
    { 0x25AC, glyph_filledrect },
    { 0x25B2, glyph_triagup },
    { 0x25BA, glyph_triagrt },
    { 0x25BC, glyph_triagdn },
    { 0x25C4, glyph_triaglf },
    { 0x25CA, glyph_lozenge },
    { 0x25CB, glyph_circle },
    { 0x25CF, glyph_H18533 },
    { 0x25D8, glyph_invbullet },
    { 0x25D9, glyph_invcircle },
    { 0x25E6, glyph_openbullet },
    { 0x263A, glyph_smileface },
    { 0x263B, glyph_invsmileface },
    { 0x263C, glyph_sun },
    { 0x2640, glyph_female },
    { 0x2642, glyph_male },
    { 0x2660, glyph_spade },
    { 0x2663, glyph_club },
    { 0x2665, glyph_heart },
    { 0x2666, glyph_diamond },
    { 0x266A, glyph_musicalnote },
    { 0x266B, glyph_musicalnotedbl },
    { 0xF6BE, glyph_dotlessj },
    { 0xF6BF, glyph_LL },
    { 0xF6C0, glyph_ll },
    { 0xF6C1, glyph_Scedilla },
    { 0xF6C2, glyph_scedilla },
    { 0xF6C3, glyph_commaaccent },
    { 0xF6C4, glyph_afii10063 },
    { 0xF6C5, glyph_afii10064 },
    { 0xF6C6, glyph_afii10192 },
    { 0xF6C7, glyph_afii10831 },
    { 0xF6C8, glyph_afii10832 },
    { 0xF6C9, glyph_Acute },
    { 0xF6CA, glyph_Caron },
    { 0xF6CB, glyph_Dieresis },
    { 0xF6CC, glyph_DieresisAcute },
    { 0xF6CD, glyph_DieresisGrave },
    { 0xF6CE, glyph_Grave },
    { 0xF6CF, glyph_Hungarumlaut },
    { 0xF6D0, glyph_Macron },
    { 0xF6D1, glyph_cyrBreve },
    { 0xF6D2, glyph_cyrFlex },
    { 0xF6D3, glyph_dblGrave },
    { 0xF6D4, glyph_cyrbreve },
    { 0xF6D5, glyph_cyrflex },
    { 0xF6D6, glyph_dblgrave },
    { 0xF6D7, glyph_dieresisacute },
    { 0xF6D8, glyph_dieresisgrave },
    { 0xF6D9, glyph_copyrightserif },
    { 0xF6DA, glyph_registerserif },
    { 0xF6DB, glyph_trademarkserif },
    { 0xF6DC, glyph_onefitted },
    { 0xF6DD, glyph_rupiah },
    { 0xF6DE, glyph_threequartersemdash },
    { 0xF6DF, glyph_centinferior },
    { 0xF6E0, glyph_centsuperior },
    { 0xF6E1, glyph_commainferior },
    { 0xF6E2, glyph_commasuperior },
    { 0xF6E3, glyph_dollarinferior },
    { 0xF6E4, glyph_dollarsuperior },
    { 0xF6E5, glyph_hypheninferior },
    { 0xF6E6, glyph_hyphensuperior },
    { 0xF6E7, glyph_periodinferior },
    { 0xF6E8, glyph_periodsuperior },
    { 0xF6E9, glyph_asuperior },
    { 0xF6EA, glyph_bsuperior },
    { 0xF6EB, glyph_dsuperior },
    { 0xF6EC, glyph_esuperior },
    { 0xF6ED, glyph_isuperior },
    { 0xF6EE, glyph_lsuperior },
    { 0xF6EF, glyph_msuperior },
    { 0xF6F0, glyph_osuperior },
    { 0xF6F1, glyph_rsuperior },
    { 0xF6F2, glyph_ssuperior },
    { 0xF6F3, glyph_tsuperior },
    { 0xF6F4, glyph_Brevesmall },
    { 0xF6F5, glyph_Caronsmall },
    { 0xF6F6, glyph_Circumflexsmall },
    { 0xF6F7, glyph_Dotaccentsmall },
    { 0xF6F8, glyph_Hungarumlautsmall },
    { 0xF6F9, glyph_Lslashsmall },
    { 0xF6FA, glyph_OEsmall },
    { 0xF6FB, glyph_Ogoneksmall },
    { 0xF6FC, glyph_Ringsmall },
    { 0xF6FD, glyph_Scaronsmall },
    { 0xF6FE, glyph_Tildesmall },
    { 0xF6FF, glyph_Zcaronsmall },
    { 0xF721, glyph_exclamsmall },
    { 0xF724, glyph_dollaroldstyle },
    { 0xF726, glyph_ampersandsmall },
    { 0xF730, glyph_zerooldstyle },
    { 0xF731, glyph_oneoldstyle },
    { 0xF732, glyph_twooldstyle },
    { 0xF733, glyph_threeoldstyle },
    { 0xF734, glyph_fouroldstyle },
    { 0xF735, glyph_fiveoldstyle },
    { 0xF736, glyph_sixoldstyle },
    { 0xF737, glyph_sevenoldstyle },
    { 0xF738, glyph_eightoldstyle },
    { 0xF739, glyph_nineoldstyle },
    { 0xF73F, glyph_questionsmall },
    { 0xF760, glyph_Gravesmall },
    { 0xF761, glyph_Asmall },
    { 0xF762, glyph_Bsmall },
    { 0xF763, glyph_Csmall },
    { 0xF764, glyph_Dsmall },
    { 0xF765, glyph_Esmall },
    { 0xF766, glyph_Fsmall },
    { 0xF767, glyph_Gsmall },
    { 0xF768, glyph_Hsmall },
    { 0xF769, glyph_Ismall },
    { 0xF76A, glyph_Jsmall },
    { 0xF76B, glyph_Ksmall },
    { 0xF76C, glyph_Lsmall },
    { 0xF76D, glyph_Msmall },
    { 0xF76E, glyph_Nsmall },
    { 0xF76F, glyph_Osmall },
    { 0xF770, glyph_Psmall },
    { 0xF771, glyph_Qsmall },
    { 0xF772, glyph_Rsmall },
    { 0xF773, glyph_Ssmall },
    { 0xF774, glyph_Tsmall },
    { 0xF775, glyph_Usmall },
    { 0xF776, glyph_Vsmall },
    { 0xF777, glyph_Wsmall },
    { 0xF778, glyph_Xsmall },
    { 0xF779, glyph_Ysmall },
    { 0xF77A, glyph_Zsmall },
    { 0xF7A1, glyph_exclamdownsmall },
    { 0xF7A2, glyph_centoldstyle },
    { 0xF7A8, glyph_Dieresissmall },
    { 0xF7AF, glyph_Macronsmall },
    { 0xF7B4, glyph_Acutesmall },
    { 0xF7B8, glyph_Cedillasmall },
    { 0xF7BF, glyph_questiondownsmall },
    { 0xF7E0, glyph_Agravesmall },
    { 0xF7E1, glyph_Aacutesmall },
    { 0xF7E2, glyph_Acircumflexsmall },
    { 0xF7E3, glyph_Atildesmall },
    { 0xF7E4, glyph_Adieresissmall },
    { 0xF7E5, glyph_Aringsmall },
    { 0xF7E6, glyph_AEsmall },
    { 0xF7E7, glyph_Ccedillasmall },
    { 0xF7E8, glyph_Egravesmall },
    { 0xF7E9, glyph_Eacutesmall },
    { 0xF7EA, glyph_Ecircumflexsmall },
    { 0xF7EB, glyph_Edieresissmall },
    { 0xF7EC, glyph_Igravesmall },
    { 0xF7ED, glyph_Iacutesmall },
    { 0xF7EE, glyph_Icircumflexsmall },
    { 0xF7EF, glyph_Idieresissmall },
    { 0xF7F0, glyph_Ethsmall },
    { 0xF7F1, glyph_Ntildesmall },
    { 0xF7F2, glyph_Ogravesmall },
    { 0xF7F3, glyph_Oacutesmall },
    { 0xF7F4, glyph_Ocircumflexsmall },
    { 0xF7F5, glyph_Otildesmall },
    { 0xF7F6, glyph_Odieresissmall },
    { 0xF7F8, glyph_Oslashsmall },
    { 0xF7F9, glyph_Ugravesmall },
    { 0xF7FA, glyph_Uacutesmall },
    { 0xF7FB, glyph_Ucircumflexsmall },
    { 0xF7FC, glyph_Udieresissmall },
    { 0xF7FD, glyph_Yacutesmall },
    { 0xF7FE, glyph_Thornsmall },
    { 0xF7FF, glyph_Ydieresissmall },
    { 0xF8E5, glyph_radicalex },
    { 0xF8E6, glyph_arrowvertex },
    { 0xF8E7, glyph_arrowhorizex },
    { 0xF8E8, glyph_registersans },
    { 0xF8E9, glyph_copyrightsans },
    { 0xF8EA, glyph_trademarksans },
    { 0xF8EB, glyph_parenlefttp },
    { 0xF8EC, glyph_parenleftex },
    { 0xF8ED, glyph_parenleftbt },
    { 0xF8EE, glyph_bracketlefttp },
    { 0xF8EF, glyph_bracketleftex },
    { 0xF8F0, glyph_bracketleftbt },
    { 0xF8F1, glyph_bracelefttp },
    { 0xF8F2, glyph_braceleftmid },
    { 0xF8F3, glyph_braceleftbt },
    { 0xF8F4, glyph_braceex },
    { 0xF8F5, glyph_integralex },
    { 0xF8F6, glyph_parenrighttp },
    { 0xF8F7, glyph_parenrightex },
    { 0xF8F8, glyph_parenrightbt },
    { 0xF8F9, glyph_bracketrighttp },
    { 0xF8FA, glyph_bracketrightex },
    { 0xF8FB, glyph_bracketrightbt },
    { 0xF8FC, glyph_bracerighttp },
    { 0xF8FD, glyph_bracerightmid },
    { 0xF8FE, glyph_bracerightbt },
    { 0xFB00, glyph_ff },
    { 0xFB01, glyph_fi },
    { 0xFB02, glyph_fl },
    { 0xFB03, glyph_ffi },
    { 0xFB04, glyph_ffl },
    { 0xFB1F, glyph_afii57705 },
    { 0xFB2A, glyph_afii57694 },
    { 0xFB2B, glyph_afii57695 },
    { 0xFB35, glyph_afii57723 },
    { 0xFB4B, glyph_afii57700 },
}; /* tab_agl2uni */

#define LEN_AGL2UNI	((sizeof tab_agl2uni) / (sizeof (uni_agl)))
#define LEN_UNI2AGL	((sizeof tab_uni2agl) / (sizeof (uni_agl)))

/*
 * Returns the Unicode value of a glyph name. If the name is not
 * contained in the Adobe Glyph List (AGL) 0 will be returned.
 */

unsigned int
pdf_adobe2unicode(PDF *p, const char *name)
{
    int lo = 0;
    int hi = LEN_AGL2UNI;

    (void) p;

    if (!name)
	return 0;

    while (lo < hi)
    {
	int i = (lo + hi) / 2;
	int cmp = strcmp(name, tab_agl2uni[i].aglname);

	if (cmp == 0)
	    return tab_agl2uni[i].unicode;

	if (cmp < 0)
	    hi = i;
	else
	    lo = i + 1;
    }

    return 0;
}

/*
 * Returns the name in the Adobe Glyph List which corresponds to
 * the supplied Unicode value. If the value doesn't have a
 * corresponding Unicode name NULL will be returned.
 */

const char *
pdf_unicode2adobe(PDF *p, unsigned int uv)
{
    int lo = 0;
    int hi = LEN_UNI2AGL;

    (void) p;

    while (lo < hi)
    {
	int i = (lo + hi) / 2;

	if (uv == (unsigned int) tab_uni2agl[i].unicode)
	    return tab_uni2agl[i].aglname;

	if (uv < (unsigned int) tab_uni2agl[i].unicode)
	    hi = i;
	else
	    lo = i + 1;
    }

    return (char *) 0;
}
