/*
 * The Micro-C pre-processor features a non-standard extension to provide
 * a very flexible and powerful string concatination operator. This operator
 * ('#') works like this: If '#' is found immediately following a string:
 *  - 1 - The trailing quote is removed from the string.
 *  - 2 - The opening quote is removed from the NEXT string encountered.
 *
 * This program demonstrates some uses of the '#' operator.
 *
 * Compile command: CC strcon -fop [MODE=(0-3)]
 */
#include <stdio.h>

#define	TEXT	Unquoted Text		/* A text string without quotes */
#define	QTEXT	"Quoted Text"		/* A text string with quotes */

/* MCP does not normally process '#' statements within a string (you
might WANT the string to have #if etc. within it)... This block shows
how to use string concatination to allow conditional construction of
a string */
char prompt[] = { "Mode=" #
#if MODE==0
"Zero" #
#elif MODE==1
"One" #
#elif MODE==2
"Two" #
#elif MODE==3
"Three" #
#else
	#error MODE is not set correctly!
#endif
"" };

main()
{
	/* Display date & time of compilation */
	puts("Compiled: "#__DATE__" "#__TIME__"");

	/* Display the conditonally constructed string */
	puts(prompt);

	/* Simple string concatination */
	puts("String1" #"String2");

	/* Insertion of non-quoted text into a string */
	puts("String1" # TEXT "String2");

	/* Insertion of quoted text into a string */
	puts("String1" # QTEXT # "String2");
}
