#ifndef RDWRSECT_H_
#define RDWRSECT_H_

typedef unsigned long SECTOR;

struct RDWRHandleStruct
{
   int handle;                /* Drive number or file handle of image  */
			      /* file.                                 */
   int IsImageFile;           /* Remembers wether an image file is     */
			      /* intended.                             */
   int dirbegin;              /* First sector with directory entries.  */

   /* Specific cached information of boot sector. */
   unsigned char  SectorsPerCluster;  /* sectors per cluster.              */
   unsigned short ReservedSectors;    /* number of reserved sectors.       */
   unsigned char  Fats;               /* number of fats.                   */
   unsigned short NumberOfFiles;      /* number of files or directories in */
				      /* the root directory.               */
   unsigned short NumberOfSectors;    /* number of sectors in the volume.  */
   unsigned char  descriptor;         /* media descriptor.                 */
   unsigned short SectorsPerFat;      /* number of sectors per fat.        */
   unsigned short SectorsPerTrack;    /* sectors per track.                */
   unsigned short Heads;              /* number of read/write heads.       */

   /* Function to read from drive or image file. */
   int (*ReadFunc)  (int handle, int nsects, SECTOR lsects, void* buffer);
   
   /* Function to write to drive or image file. */
   int (*WriteFunc) (int handle, int nsects, SECTOR lsects, void* buffer);
}; 
typedef struct RDWRHandleStruct* RDWRHandle;

int ReadSectors(RDWRHandle handle, int nsects, SECTOR lsect, void* buffer);
int WriteSectors(RDWRHandle handle, int nsects, SECTOR lsect, void* buffer);

int InitReadWriteSectors(char* driveorfile, RDWRHandle* handle);
int InitReadSectors     (char* driveorfile, RDWRHandle* handle);

/* Reasonably stupid. */
int InitWriteSectors    (char* driveorfile, RDWRHandle* handle);

void CloseReadWriteSectors(RDWRHandle* handle);

#endif
