/*
** XMS.H
**
** Header file for Extended Memory routines in XMS.ASM.
*/

#ifndef _XMS_H
#define _XMS_H

/* initialisation routine. */
int XMMinit(void);

/* routines for managing EMB's */
int  XMSinit(void);
int  XMSversion(void);
long XMScoreleft(void);
int  XMSfree(unsigned int handle);
long XMSmemcpy(unsigned int desthandle, long destoff,
		 unsigned int srchandle, long srcoff, long n);
int  DOStoXMSmove(unsigned int desthandle, long destoff,
		 const char *src, unsigned n);
int  XMStoDOSmove(char *dest, unsigned int srchandle, long srcoff, unsigned n);

unsigned int XMSalloc(long size);

int XMSrealloc(unsigned int handle, long size);

/* routines for managing the HMA. */
int HMAalloc(void);
int HMAcoreleft(void);
int HMAfree(void);


/* routines for managing UMB's. */
unsigned int UMBalloc(void);
unsigned int GetUMBsize(void);
int UMBfree (unsigned int segment);

#endif
