/*    
   Flldrvmp.c - fill drive map.

   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdlib.h>

#include "fte.h"
#include "inffat12.h"
#include "expected.h"

static int ReportDriveSize(RDWRHandle handle);

static int Reporter(RDWRHandle handle, CLUSTER label, SECTOR sector,
                    void** structure);

int FillDriveMap(RDWRHandle handle)
{
    SmallMessage("Calculating drive size.");
    if (ReportDriveSize(handle))
    {
       SmallMessage("Drawing drive map.");
       return LinearTraverseFat(handle, Reporter, NULL);
    }
    else
       return FALSE;
}

static int Reporter(RDWRHandle handle, CLUSTER label, SECTOR sector,
                    void** structure)
{
    int     symbol;
    CLUSTER cluster;

    cluster = DataSectorToCluster(handle, sector);

    if (FAT_FREE(label))   symbol = UNUSEDSYMBOL;
    if (FAT_BAD(label))    symbol = BADSYMBOL;
    if (FAT_LAST(label))   symbol = USEDSYMBOL;
    if (FAT_NORMAL(label)) symbol = USEDSYMBOL;

    DrawOnDriveMap(cluster, symbol);
    return TRUE;
}

static int ReportDriveSize(RDWRHandle handle)
{
   unsigned short clusters;

   clusters = GetClustersInDataArea(handle);

   if (clusters == 0) return FALSE;

   DrawDriveMap(clusters);

   return TRUE;
}
