/*    
   Defrag.c - defrag main routine.

   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include "..\..\modlgate\defrpars.h"
#include "..\..\modlgate\modlgate.h"
#include "..\..\misc\version.h"
#include "..\..\misc\misc.h"
#include "..\..\misc\boot.h"
#include "..\..\misc\bool.h"
#include "..\keyboard\keyboard.h"
#include "..\mouse\mouse.h"
#include "..\event\event.h"
#include "..\screen\screen.h"
#include "..\dialog\dialog.h"
#include "..\dialog\menu.h"
#include "..\dialog\msgbxs.h"
#include "..\dialog\copyrigt.h"
#include "..\dialog\maplegnd.h"
#include "..\dialog\defrdone.h"
#include "..\winman\winman.h"
#include "..\winman\window.h"
#include "..\winman\control.h"

#include "..\logman\logman.h"

#include "actions.h"
#include "defrag.h"
#include "keepdos.h"
#include "checkos.h"
#include "chkargs.h"

int StartOptimization(void);

int main(int argc, char *argv[])
{
    char switchchar = SwitchChar();

char answer[5]; 
    
    /* Check parameters. */
    if (argc == 2)
    {
      /* Show help if requested. */
      if ((argv[1][0] == switchchar) || (argv[1][0] == '/'))  
      {
         if (argv[1][1] == '?')
         {
            ShowHelp(switchchar);
            return 0;
         }
      }
      
      /* Show no-ops if requested. */
      if (stricmp(&argv[1][1], "no-ops") == 0)
      {
         ShowNoOps(switchchar);
         return 0;
      }
    }
    ParseArguments(argc, argv, switchchar);

printf("This is an alpha version of defrag!!!\n");
printf("Are you sure you want to continue (YES/No)?");
scanf("%5s", answer);

if (stricmp(answer, "YES") != 0) return 1;
    
    /* Show copyright on the screen. */
    printf("This program is free software. It comes with ABSOLUTELY NO WARANTIES.\n"
           "You are welcome to redistribute it under the terms of the\n" 
           "GNU General Public License, see http://www.GNU.org for details.\n");

    /* Initialise defrag. */
    SaveDOSState();
    atexit(OnExit);
    ctrlbrk(OnCBreak);
    MousePresent();
    SetScreenLines(25);
    ShowMouse();
    HideCursor();
    MouseGotoXY(1, 1);
    SetHighIntensity(1);
    CriticalHandlerOn();
    
    /* Draw main screen. */
    DrawScreen();
    
    /* Show copyright on the log. */
    LogPrint("This program is free software. It comes with ABSOLUTELY NO WARANTIES.\n"
             "You are welcome to redistribute it under the terms of the\n" 
             "GNU General Public License, see http://www.GNU.org for details.\n");

    /* Check OS. */
    if (!CheckOS()) return 1; 
    
    /* Ask for a drive and see wether it needs defragmentation. */
    if (GetParsedDrive() == 0)
    {
       if (SelectDrive()) 
       {
          if (StartOptimization()) 
             return 0;
       }
       else
          if (HandleMenu()) return 0;
    }
    else
    {
       DrawCurrentDrive(GetOptimizationDrive());
       if (QueryDisk()) 
       {
          if (StartOptimization())
             return 0;
       }
       else
          if (HandleMenu()) return 0;
    }

    /* Go defrag! */
    MainLoop();

    return 0;
}


static void MainLoop()
{
    int leave = 0, event, refreshstatus = 1;

    while (!leave)
    {
        if (refreshstatus)
        {
           SetStatusBar(RED, WHITE, "                                            ");
           SetStatusBar(RED, WHITE, " Press ALT or F10 to activate menu.");
           refreshstatus = 0;
        }

        while ((event = GetEvent()) == 0);

        CheckExternalEvent(event);

        switch (event)
        {
            case ALT_B:
                 if (StartOptimization()) leave = TRUE;
                 refreshstatus = TRUE;
                 break;

            case ALT_L:
                 ShowMapLegend();
                 refreshstatus = TRUE;
                 break;

            case ALT_C:
                 ShowCopyRight();
                 refreshstatus = TRUE;
                 break;

            case ALT_X:
                 leave = TRUE;
                 break;

            case ALT_O:
            case F10:
            case ALTKEY:
                 leave = HandleMenu();
                 refreshstatus = TRUE;
                 break;

            case ALT_S:
                 SelectSortOptions();
                 refreshstatus = TRUE;
                 break;

            case ALT_M:
                 SelectOptimizationMethod();
                 refreshstatus = TRUE;
                 break;
            
            case MSLEFT:
            case MSRIGHT:
            case MSMIDDLE:
                 if (PressedInRange(3, 1, 15, 1))
                    leave = HandleMenu();
                 if (PressedInRange(63, 25, 80, 25))
                    ShowCopyRight();
                 refreshstatus = TRUE;
                 break;

            default:
                    while (AltKeyDown());
        }
    }
}

static int HandleMenu ()
{
    for (;;)
    {
       switch (MainMenu())
       {
              case CHANGEDRIVE:
                   SelectDrive();
                   break;

              case EXITDEFRAG:
                   return 1;

              case DISPLAYCOPYRIGHT:
                   ShowCopyRight();
                   break;

              case SHOWMAP:
                   ShowMapLegend();
                   break;

              case SPECIFYFILEORDER:
                   SelectSortOptions();
                   break;

              case CHANGEMETHOD:
                   SelectOptimizationMethod();
                   break;

              case BEGINOPTIMIZATION:
                   if (StartOptimization()) return 1;
                   break;

              default:
                   return 0;
       }           
    }   
 /*   return 0;*/
}

static int StartOptimization(void)
{
    BeginOptimization();
    
    if (IsRebootRequested()) ColdReboot();

    switch(ReportDefragDone())
    {
       case REBOOT_COMPUTER:
            ColdReboot();    /* Doesn't return */

       case EXIT_DEFRAG:
            return 1;
    }

    return 0;
}


static void ShowHelp (char switchchar)
{
     printf("FreeDOS defrag " VERSION "\n"
            "Optimizes file loading times by moving file fragments together.\n"
            "\n"
            "(C) 2000 by Imre Leber under the GNU General Public License.\n"
            "\n"
            "defrag [<drive>:] [{%cF|%cU}] [%cSorder[-]] [%cB] [%cX]\n"
            "\n"
            "drive : drive letter of drive to optimize.\n"
            "\n"
            "%cF : Fully optimizes specified drive.\n"
            "%cU : Unfragments files, possibly leaving space between files.\n"
            "%cS : Sort files by specified order.\n"
            "      order: N  by Name (alphabetic)            E by Extension (alphabetic)\n"
            "             D  by Date & time (earliest first) S by Size (smallest first)\n"
            "      - suffix to sort in descending order.\n"
            "%cB : Restarts computer after optimization.\n"
            "%cX : Allways automatically exits.\n"
            "\n"
            "Remarks:\n"
            "    Type defrag %cno-ops for a list of no-ops.\n"
            "    You can only specify floppy drives or hard disks.\n",
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar,
            switchchar);
}


static void ShowNoOps (char switchchar)
{
     printf("FreeDOS defrag " VERSION "\n"
            "Optimizes file loading times by moving file fragments together.\n"
            "\n"
            "(C) 2000 by Imre Leber under the GNU General Public License.\n"
            "\n"
            "List of no-ops included for MS-DOS compatibility.\n"
            "\n"
            "%cSKIPHIGH : this option doesn't do anything.\n"
            "%cLCD      : this option doesn't do anything either.\n"
            "%cBW       : nope, nothing!\n"
            "%cG0       : just forget about this one.\n",
            switchchar,
            switchchar,
            switchchar,
            switchchar);
}

static void OnExit()
{
      /* Reinitialise mouse-driver. */
      CloseMouse();

      DOSWipeScreen();

      /* Show the cursor. */
      RestoreDOSState();

      /* Reset interrupt handlers. */
      /* SetTimerOff(); */
}

static int OnCBreak ()
{
      return 1;
}
