/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __FS_CMDS_H__
#define __FS_CMDS_H__


/* External program strings, command & options */

/* 
Notes:
  each command is executed by concating #_COMMAND + " " + #_COMMAND_OPT
  where ? in option strings below replaced with selected drive letter 
  A command is disabled if #_COMMAND can not be found in search
  path (current dir, followed by those listed in PATH env var).
  Do NOT append extension to command, as it automatically appends
  .COM or .EXE depending on which found first.
  if #_COMMAND_OPT_MONO is defined, then if monochrome mode is active,
  the actual command used will be above with + " " + #_COMMAND_OPT_MONO 
  appended.
*/

// standard unconditional format
#define FORMAT_COMMAND  "FORMAT"
#define FORMAT_COMMAND_OPT  "?: /U /V:FREEDOS"

// standard quick format
#define QFORMAT_COMMAND "FORMAT"
#define QFORMAT_COMMAND_OPT "?: /Q /U /V:FREEDOS"

// std copy system files & store boot record
#define SYS_COMMAND "SYS"
#define SYS_COMMAND_OPT "?:"

// Ranish Partition Manager
#define PMANAGER_COMMAND "PART"
#define PMANAGER_COMMAND_OPT ""

// standard fdisk
#define FDISK_COMMAND "FDISK"
#define FDISK_COMMAND_OPT ""
#define FDISK_COMMAND_OPT_MONO "/MONO"

// fips, partitions resizer
#define FIPS_COMMAND "FIPS"
#define FIPS_COMMAND_OPT ""  /* note fips can be passed drive, buts its physical drive not letter */


/** These two are indicators of non-external commands **/

#define CONTINUE_COMMAND "*"
#define ABORT_COMMAND "#"


#endif /* __FS_CDS_H__ */
