/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
   "Choose a partition" section of INSTALL
*/

#include <stdlib.h>
#include "HDTBL.H"
#include "GDSKFREE.H"
#include "GLABEL.H"
#include "GLOBALS.H"
#include "INT24.H"


//////////// PART 2:  HD TABLE //////////////////////////////////////////


/* this will remove all entries in the list & reset it to NULL */
void clearlist (void)
{
	hdtbl *hd1, *hd2;

	for (hd1 = list; hd1 != NULL; )
	{
		hd2 = hd1->next;
		free(hd1);
		hd1 = hd2;
	}

	/* reset global variables */
	list = NULL;     // list of valid drives found
	maxhd = 0;       // count of valid drives found
	cursor = 1;      // currently selected drive index (1 based) in list
	base = 0;        // display base, offset (0 based) in list to start display
}


/* adds an entry to the list */
BOOL hdadd (BYTE dl, BYTE drv_type)
{
	hdtbl *hd = (hdtbl *) malloc(sizeof(/*hdtbl*/ struct data));

	if (hd) {
	   hd->letter = dl;
	   hd->drv_type = drv_type;

         // note: getlabel & getDiskFree may cause abort/retry/fail if drive unformatted
         autofail = 1;
         failed = 0;

	   getlabel (hd->label,dl);

         if (failed)
         {
             failed = 0;
             strcpy(hd->label, "unformated?");
         }

	   /*** Size ***/
#ifndef TEST_ALLDRVS
	   getDiskFree(dl, &(hd->size), &(hd->total));
         if (failed)
         {
            failed = 0;
            hd->size = 0UL;
         }
#else
	   hd->size = 0x00;
	   hd->total = 0xFD;
#endif

         // turn off autofail, since as far as we know other failures need user intervention
         autofail = 0;

	   /*** Update list links ***/
	   hd->next = list;
	   list = hd;
	   maxhd++;
	}
	return !!hd;
}

hdtbl *gethdrec (BYTE num, hdtbl *u)
{
	if (num == 1)
		return u;
	else
	if (u != NULL)
		return gethdrec (num-1, u->next);
	else
		return NULL;
}

// #define gethd(num) gethdrec(num, list)
#ifndef gethd
hdtbl *gethd (BYTE num)
{
	if (num == 1)
		return list;
	else
		return gethdrec(num, list);
}
#endif
