/* Copyright (C) 2002 kjd */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ISCDDRV_H__
#define __ISCDDRV_H__

#include "CExt.h"

/* Returns 0 if no CD drives, otherwise nonzero == # of drive letters used */
int areCDROMsInstalled (void);

/* Returns version, high byte is major, low byte minor.
   Prior to MSCDEX version 2.0 this is not implemented and returns
   0x00.  E.g. version 2.10 would be 0x020a
*/
WORD getCDEXVersion (void);

/* returns non zero if drive is reported as CDROM by MSCDEX or
   equivalent, FALSE otherwise.  
   Note: This requires MSCDEX v2.0 or higher to work correctly,
   and may return FALSE for lower versions when it should be TRUE.
   drivenum is 1=A:,2=B:,3=C:,...
   Note: this will call areCDROMsInstalled, so there is no
   need to test for CDROMs 1st before calling this function.
*/
BOOL isCDRomDrive (BYTE drivenum);

#endif /* __ISCDDRV_H__ */
