/*  Logon

    Copyright (c) Express Software 1997.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <conio.h>
#include <stdio.h>

// D E F I N E S ////////////////////////////////////////////////////////////

#define CTRL_Z 26

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.

        } // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    char letter, password[128], *fileargs[64], *optargs[64];
    int i=0, n_options, help_flag=0, index;

    n_options = classify_args(argc, argv, fileargs, optargs);
    for (index=0;index<n_options;index++)
        {
        if (optargs[index][0] == '?') help_flag=1;
        else
            {
            printf("Invalid parameter - /%s\n", strupr(optargs[index]));
            return 0;
            } // end else.

        } // end for.

    if (help_flag)
        {
        printf("Asks the user for a password and won't let them in until it gets the right one.\n\n"
               "Syntax: LOGON [/?]\n"
               "  /? Displays this help message\n");
        return 0;
        } // end if.

rtrn:
    printf("Enter password: ");
    while (((letter = getch()) != CTRL_Z) && (letter != '\r'))
        password[i++] = letter;

    password[i] = NULL;
    if (strstr(password, "Joe") != NULL)
        {
        printf("\nPassword accepted.\n");
        return 0;
        } // end if.
    else
        {
        printf("\nAccess denied.\n");
        goto rtrn;
        } // end else.

    return 0;

} // end main.
