/*  Scandisk header file

    Copyright (c) Joe Cosentino 2000.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

#ifndef SCANDISK_H_
#define SCANDISK_H_

#define FALSE 0
#define TRUE  1

void logit(char *);
int classify_args(int, char *[], char *[], char *[]);
int GetCurrentTime(void);
void OnExit();
int OnCBreak();
void get_descriptor(int, int);
void main_routine(void);
void pause(void);
void read_ini(void);

#endif

#ifndef SCANDISK

typedef struct
{
    int monochrome;                     // Environment settings.
    int mouse;
    int screen_color;
    int no_screen;
    int timeout;
    int labelcheck;
    int spacecheck;

    int drivesum;                       // Custom settings.
    int allsum;
    int surface;
    int append;
    int overwrite;

} Flags;

extern Flags flags;

#endif

