#include <errno.h>
#include <cv/fnutil.h>
#include "process.h"


#define FILE_ATTR	(_A_RDONLY | _A_HIDDEN | _A_SYSTEM | _A_ARCH)
#define ALL_ATTR	(_A_SUBDIR | FILE_ATTR)
#define NAME_LEN	arraySize(((find_t*)NULL)->name)


extern dosdate_t currdt;
extern dostime_t currtm;
extern PCStr	date_s, time_s, attr_s;
extern ACT	act;
extern bool	invert,
		dirFind,
		recurse;
extern count	attr_on, attr_off;


PCStr	target;
char	path[256], wildname[256];
PStr	pathend;
count	found;
bool	wildcards;


//=========================================================
RETCODE doList(PCStr name){
	//---  䠩; ⮩ 㬥 砥 ⠭ 室
	int handle = 0;
{	PCStr nm = name;
	if(*nm && _dos_open(nm, O_RDONLY | SH_DENYNONE, &handle)){
		sayerror("open", nm); return RET_IOERR;
}	}

	RETCODE ret = RET_SUCCESS;
	size_t fill = 0, read;
	do{	static char buf[4 * 1024u + 1]; PStr p = buf;
		if(_dos_read(handle, &p[fill], sizeof(buf) - 1 - fill, &read)){
			sayerror("read", name);
			if(ret < RET_IOERR) ret = RET_IOERR; break;
		}
		for(fill += read;;){
			//--- १ 騥 ࠢ騥   ஡
			while(fill && byte(*p) <= ' ') p++, fill--;

			//--- ᫨ ⠫ ,    ⥭ 
			//--- 䠩 - 
			if(fill == 0 || fill < sizeof(path) && read) break;

			//--- 뤥 ப  ய 墮⮢ ஡
			register PCStr start = p; PStr stop;
			do{	if(*p != ' ') stop = p;
				p++, fill--;
			}while(fill && byte(*p) >= ' ');

			//--- ࠡ 뤥 ப
			stop[1] = EOS; RETCODE last = doTarget(start);
			if(ret < last) ret = last;
		}
		memcopy(buf, p, fill);
	}while(read);
{	int h = handle; if(h) _dos_close(h);
}	return ret;
}

//=========================================================
// ࠡ 䠩  ⠫, ᮮ⢥騥 楫; ᫨ 楫 ᮤন
// ⮫쪮    䠩/⠫,   楫  "*.*"; ᫨
// 楫 砥   ⨯,     "." (".*"  砥
// ⠨)

//--- !!! Non-portable trick !!! ==	((addr)[0] = (b1), (addr)[1] = (b2))
#define setChar2(addr, b1, b2)		(*((word*)addr) = makeword(b1, b2))

RETCODE doTarget(CStr target){
	::target = target;

	//---  楫    /⠨
	count plen, wlen = fnCutName(target, plen = checklen(target));
	if(plen >= arraySize(path) - 1 || wlen >= arraySize(wildname) - 2){
		_doserrno = EINVAL; sayerror("target", target);
		return RET_BADARG;
	}
	memcopy(path, target, plen + 1); fnUppercase(path, plen);
{	PStr pend = &path[plen - wlen]; memcopy(wildname, pend, wlen);

	//--- ଠ :   ᥣ   ᨬ
	//--- ࠧ⥫, ᫨   ⮩
	if(pend > path) { char ch = pend[-1]; if(!isDirChar(ch)) *pend++ = '\\'; }
	::pathend = pend;
}
	//--- ⮥  ࠧ㬥 "*"
{	PStr wnmend = &wildname[wlen];
	if(wlen == 0) { *wnmend++ = '*', wlen++; }

	//--- ।,    ⠨
	wildcards = bool(memcspan(wildname, wlen, '*')
				- memcspan(wildname, wlen, '?'));

	//--- ଠ   ᫥ ࠢ  ᮮ⢥⢨ 
	//--- ࠢ MS-DOS:  "."    ⨯ (".*" 
	//--- ⠨)  ८ࠧ  孨 ॣ
	if(memcspan(wildname, wlen, '.') == wlen){
		*wnmend++ = '.';
		if(wildcards) *wnmend++ = '*';
	}
	*wnmend = EOS;
}
	//--- ᫨  ⠨,  ᮮ⢥ 䠩  - 訡
{	found = 0; RETCODE ret = doSubdirs();
	if(!(found | wildcards)){
		_doserrno = ENOFILE; sayerror("find", target);
		if(ret < RET_IOERR) ret = RET_IOERR;
	}
	return ret;
}	}

//=========================================================
// ᨢ 室 ॢ ⠫

char dirNameTbl[44 * 1024u];
PStr top = dirNameTbl + NAME_LEN;

RETCODE doSubdirs(){
	PStr oldtop = top, oldpath = pathend;

	//--- ஢ઠ  ९ ப 
	if(oldpath >= &path[arraySize(path) - NAME_LEN]){
		_doserrno = ENOMEM; *oldpath = EOS;
		sayerror("too deep", path); return RET_INTERNAL;
	}

	//--- ࠡ  ⠫  ᮡ ᯨ᮪  ⠫
	RETCODE ret = doDir();
	if(top > &dirNameTbl[arraySize(dirNameTbl) - NAME_LEN]){
		_doserrno = ENOMEM; *oldpath = EOS;
		sayerror("recurse", path);
		if(ret < RET_INTERNAL) ret = RET_INTERNAL;
	}
	while(top > oldtop){
		count len = memrcspan(top - NAME_LEN, NAME_LEN - 1, EOS);
		PStr p = (PStr)memcopy(oldpath, top -= len + 1, len);
		*p++ = '\\'; pathend = p;
		RETCODE last = doSubdirs(); if(ret < last) ret = last;
	}
	pathend = oldpath; return ret;
}

//=========================================================
// ࠡ⪠  䠩  , ᮮ⢥ ᪥;  䨪樨 
// ⠨ ⠫  롮ન ᪫; ᫨ 楫  
// ,   ⢨ ᮮ⢥饣 䠩 頥 訡, 
// ⨢ 砥  訡  ⠥

RETCODE doDir(){
	//---  
{	PStr p = pathend; setChar2(p, '*', '.'); setChar2(&p[2], '*', EOS);
}	find_t fi; int last = _dos_findfirst(path, ALL_ATTR, &fi);

	//--- ॡ  
	RETCODE ret = RET_SUCCESS;
	for(; !last; last = _dos_findnext(&fi)){
	    //--- ᪫  "."  ".."
	    count nlen = checklen(fi.name, NAME_LEN);
{	    PStr p = fi.name;
	    if(nlen < 3 && p[0] == '.' && p[nlen - 1] == '.') continue;
	    memcopy(pathend, p, nlen + 1);
}	    fnUppercase(pathend, nlen);

	    //---  ᪥  ⠨, ᫨  㪠 ,
	    //--- ⠫  ᪫
	    if(fi.attrib & _A_SUBDIR){
		//---  ⠫  ⠡  ᫥饣
		//--- ४ᨢ 室
		PStr p = top;
		if(recurse && p <= &dirNameTbl[arraySize(dirNameTbl) - NAME_LEN])
			top = (PStr)memcopy(p, pathend, nlen + 1);
		if(wildcards && !dirFind) continue;
	    }

	    //---     ࠢ  室
	    //--- ; ᪫ ,  ᮮ⢥騥 ᪥
	    if(memcspan(pathend, nlen, '.') == nlen)
		setChar2(&pathend[nlen], '.', EOS);
	    if(wildcmp(wildname, pathend)){
	 	pathend[nlen] = EOS; found++;
		RETCODE last = doEntry(path, fi.wr_date, fi.wr_time, fi.attrib);
		if(ret < last) ret = last;
	}   }

	if(last != ENMFILE){
		sayerror("find", target);
		if(ret < RET_IOERR) ret = RET_IOERR;
	}
	return ret;
}

//=========================================================
RETCODE doEntry(CStr name, unsigned fdt, unsigned ftm, int attr){
	DATE filedt, argdt;
	TIME filetm, argtm;

	//--- ᯮ 㬥
	PCStr arg = date_s; if(arg){
		unpackdate(fdt, filedt); assigndt(argdt, currdt);
		if(parsedate(arg, filedt, argdt)){
			packdate(fdt, argdt); arg = NULL;
	}	}
	if(arg == NULL){ arg = time_s; if(arg){
		unpacktime(ftm, filetm); assigntm(argtm, currtm);
		if(parsetime(arg, filetm, argtm)){
			packtime(ftm, argtm); arg = NULL;
	}   }	}
	error_(bool(arg), RET_BADARG, 0, "Bad argument", NULL, arg);

	//---  , ६ / 稥 ਡ 䠩
	int on = attr_on, off = attr_off; arg = name;
	if(invert) { assigndt(filedt, currdt); assigntm(filetm, currtm); }
	if(act == CHANGE){
		off |= _A_SUBDIR; on |= attr; off = ~off; on &= off;
		if(attr_s && _chmod(arg, 1, on) == -1){
			sayerror("set attributes", arg); return RET_IOERR;
		}
		int handle;
		if((bool(date_s) | bool(time_s)) &&
		   (_dos_open(arg, O_RDONLY | SH_DENYNONE, &handle) ||
		    (_dos_setftime(handle, fdt, ftm) | _dos_close(handle)))){
			sayerror("set date/time", arg); return RET_IOERR;
		}

	//--- ࠢ , ६ / 稥 ਡ
	}else{	off |= on; off &= attr;
		if(attr_s && off != on) return RET_NONCOMPARE;
		if(date_s){
#pragma warn -eas
#ifdef STD
			unsigned cdt; packdate(cdt, filedt);
			ACT cmp = EQUAL;
			if(fdt > cdt) cmp += GREATER - EQUAL;
			if(fdt < cdt) cmp -= EQUAL - LESSER;
#else
			ACT cmp; DATECMP(cmp, argdt, filedt);
#endif
			if(cmp != act) return RET_NONCOMPARE;
		}
		if(time_s){
#ifdef STD
			unsigned ctm; packtime(ctm, filetm);
			ACT cmp = EQUAL;
			if(ftm > ctm) cmp += GREATER - EQUAL;
			if(ftm < ctm) cmp -= EQUAL - LESSER;
#else
			ACT cmp; TIMECMP(cmp, argtm, filetm);
#endif
#pragma warn .eas
			if(cmp != act) return RET_NONCOMPARE;
	}	}
	return RET_SUCCESS;
}
