// stamp.cpp - 樨 ⮩/६  ਡ⠬ 䠩
//
// History:
//  1.0b (16.02.98) - ࢠ ।
//  1.1  (19.02.98) - : প 㬥⮢ 権 /६ 
//			ଠ, ᮮ⢥ ன COUNTRY
//  1.2  (21.02.98) - :  ய饭  
//			㬥⮢ 権 /६
//		    - :  -a  ⠭ ਡ⮢ 䠩 
//			⠫
//  1.3  (21.02.98) - : প ᪮쪨 楫   
//		    - : ࠢ  ࠢ⢮ ਡ⮢
//  1.4  (26.02.98) - ࠢ: ⥯ ᯮ  뢠 
//			訡,  த  ᫥饩 楫
//		    - ࠢ:  ७ࠢ  䠩 뢮 ⥯
//			 ᮫  㡫
//		    - :  -@ २  -c
//		    - : ࠢ  /६ ⠫
//		    - : প ⠨  ⢥ 楫
//		    - :  -r  祭  ⠫ 
//			  ⠨
//  1.41 (28.02.98) - : ᨬ 権 롨ࠥ  ࢮ
//			宦 ᨬ '/'  '-'
//		    - : 筠  ᨬ 権 ("--" 
//			"//") ४頥 쭥訩  権
//		    - :  ᨬ 権  㪠
//			⠭⭮ 室
//		    - ࠭: ⥯  ᨬ 権 । ,
//			稭騬  ⠪  ,  । 
//			  㬥⮢, 맮 ᮮ饭  訡;
//			 ।   室 ࠭  
//			ப 㪠   ᨬ 権
//  1.5  (14.03.98) - ࠢ:   ᫮  㪠
//			⨬ 祭  30  31 ⢥࣠
//		    - ࠢ: ⥯  楫 ८ࠧ  孥
//			ॣ  ᮮ⢥⢨  ன COUNTRY
//		    - :  /s  ४ᨢ ᪠ 䠩 
//			⠫  ᥬ ⠫
//  2.0  (14.04.98) - ࠢ:  ⥭ ६ 䠩  訩
//			  ᥪ㭤
//		    - :  /@  ⥭ ᯨ᪠ 楫  䠩
//		    - :  ᨬ 権 ⥯ 㪠뢠
//			⠭ 室 ⮫쪮  㬥 樨 /@
//

// "Standard stack frame" & "Check for stack overflow" off for BC++ 3.1
#pragma option -k- -N-

#include <fcntl.h>
#include <io.h>
#include <share.h>
#include "parsearg.h"
#include "process.h"


dosdate_t currdt;	//--- 騥   ६
dostime_t currtm;
PCStr	date_s = NULL,	//--- 㬥 権 
	time_s = NULL,	//---  , ६  ਡ⮢
	attr_s = NULL;
ACT	act = CHANGE;	//--- 믮塞 ⢨
bool	invert = false,	//--- ࠢ  ⥪騬 ⮩/६
	dirFind = false,//--- ᪠  ⠨ ⠪  ⠫
	recurse = false;//--- ᨢ 室 ⠫
count	attr_on,	//--- ਡ,  १ 樨
	attr_off;


//---------------------------------------------------------
const char copyright[] =
"STAMP - Files attributes manipulation, Version 2.0, (c)1998 Arkady Belousov\n\n"
"Syntax: STAMP [/a<a>] [/d[<d>]] [/t[<t>]] {path | /@[list]}...\n"
"\tSTAMP [/a<a>] [/d[<d>]] [/t[<t>]] <compare> {path | /@[list]}...\n"
"Options:\n"
"    /r\t- Include directories when search by wildcards\n"
"    /s\t- Process files in all subdirectories of specified targets\n"
"Arguments:\n"
"    <a>\t- Union of attributes (ARHSD) with '+' or '-' prefix; prefixes can\n"
"\t  be ommited (i.e. /aha-sr works as /a+h+a-s-r), ommited argument\n"
"\t  clears RHS attributes (i.e. /a works as /a-rhs)\n"
"    <d>\t- Date in [[[c]y]m]d (century, year, month, day) format*\n"
"    <t>\t- Time in h[m[s]] (hour, minute, second) format*\n"
"Compare options:\n"
"    /e\t- Check if given date, time and/or attributes equal to file\n"
"    /g\t- Check if given date and/or time greater than file\n"
"    /l\t- Check if given date and/or time lesser than file\n"
"    /c\t- Compare given date/time with current, not file date/time (i.e.\n"
"\t  \"/d!!!! file /g /c\" works same as \"/d /l file\")\n\n"
"* Ommited option don't touch corresponding attribute\n"
"* Fields must be '@' (gets value from current date/time), '!' (from file\n"
"  date/time) or 2-digit numbers; ommited argument mean current date/time\n"
"  (i.e. /d and /t works as /d@@@@ and /t@@@), ommited field mean '@' for\n"
"  date (unless century, which mean '!' if year represented by '!') and 0\n"
"  for time (i.e. /d!@@ and /t! works as /d!!@@ and /t!0000)\n"
"* Date and time can be presented in formats, that conforms COUNTRY\n"
"  settings (i.e. for USA /d3-19-! works as /d!!1903)\n";


//=========================================================
#define HELP()			{ say(copyright); return RET_SUCCESS; }
#define setOpt(cond, var, arg)	{ duplicate = bool(cond); var = arg; }
#define setTrue(var)		{ duplicate = var; var++; }
#define setFalse(var)		{ duplicate = bool(!var); var = duplicate; }

int STD_ main(int argc, char *argv[]){
	_alwaysconsole = false;
	if(argc < 2) HELP();

	//--- ஢  ப
	char optchar = 0; PCStr arg, msg;
	for(count i = 1; i < argc; i++){
		//--- 롮 ᨬ  権
		arg = argv[i]; char ch = *arg;
		if(optchar == 0 && (ch == '/' || ch == '-')) optchar = ch;
		if(ch != optchar) continue;
/*-?*/		arg++; ch = *arg; if(ch == '?') HELP();
/*-*/		if(ch == EOS || ch == '@') continue;

		//---  権
		bool duplicate = false; msg = NULL;
		PCStr arg1 = arg + 1; _dolower(ch);
/*-d*/		  if(ch == 'd') setOpt(date_s, date_s, arg1)
/*-t*/		elif(ch == 't') setOpt(time_s, time_s, arg1)
/*-a*/		elif(ch == 'a') setOpt(attr_s, attr_s, arg1)
		elif(arg[1] == EOS){
#pragma warn -eas
/*-c*/			  if(ch == 'c') setTrue(invert)
/*-s*/			elif(ch == 's') setTrue(recurse)
/*-r*/			elif(ch == 'r') setTrue(dirFind)
#pragma warn .eas
/*-g*/			elif(ch == 'g') setOpt(act - CHANGE, act, GREATER)
/*-e*/			elif(ch == 'e') setOpt(act - CHANGE, act, EQUAL)
/*-l*/			elif(ch == 'l') setOpt(act - CHANGE, act, LESSER)
/*--*/			elif(*arg == optchar) break;
			else	msg = "Invalid option";
		}else	msg = "Invalid option";
		if(duplicate) msg = "Duplicated option";
		error_(bool(msg), RET_BADOPT, 0, msg, NULL, arg);
	}

	//--- ⥫쭠 ஢ઠ ⠭ 権
	bool notCHANGE = bool(act - CHANGE),
	     ftime = bool(bool(date_s) | bool(time_s));
	arg = attr_s; msg = "Can't modify directories date/time";
	if(!dirFind || !ftime || notCHANGE){
		msg = "/c only when compare date/time";
		if(!invert || notCHANGE && !arg){
			msg = "No date/time or attributes option";
			if(!notCHANGE || (bool(arg) | ftime)) msg = NULL;
	}	}
	error_(bool(msg), RET_BADARG, 0, msg);
	if(arg && (!parseattr(arg, attr_on, attr_off) || (attr_on & attr_off)))
		error_(bool(arg), RET_BADARG, 0, "Bad argument", NULL, arg);

	//--- ࠡ⪠ 楫
	_dos_getdate(&currdt); _dos_gettime(&currtm);
	RETCODE ret = RET_SUCCESS;
	bool notargets = true, skipOpt = false;
	for(count i = 1; i < argc; i++){
		arg = argv[i]; char ch1 = arg[1]; RETCODE last;
		if(skipOpt || arg[0] != optchar || ch1 == EOS)
			last = doTarget(arg);
		else{
			arg++; arg++; char ch2 = *arg;
#pragma warn -eas
			if(ch1 == optchar && ch2 == EOS) skipOpt++;
#pragma warn .eas
			if(ch1 != '@') continue;
			if(ch2 == optchar && arg[1] == EOS) arg++;
			last = doList(arg);
		}
		if(last > ret) ret = last;
		notargets = false;
	}
	if(notargets){
		if(!invert || (fileref(date_s) | fileref(time_s)))
			error_(true, RET_BADARG, 0, "No targets");
		ret = doEntry(NULL, 0, 0, 0);
	}
	return ret;
}

//=========================================================
#include "parsattr.inc"
#include "parsdate.inc"
#include "parstime.inc"
#include "process.inc"
#include "util.inc"
