;
;     Free DOS Alternative Kernel;  FDBOOT v. 1.10 (01-06-98)
;
;     =              Extended  Bootstrap                    =
;
;               by Yury Semenov (yury@ultra.paco.net)
;

INCLUDE FDBOOT.INC

DrType	EQU BootMes + 1
DrNum	EQU BootMes + 5
PartNum	EQU BootMes + 10

putch	MACRO ch
        mov	ax,0e00h OR ch
        call	int10
        ENDM

DELAY         EQU 30h

BootRecord    EQU 3

INCLUDE FDFUNC.INC

XBOOT SEGMENT
ASSUME CS:XBOOT
        int	19h      ; Somebody tries to load XBOOT.SYS as Kernel ;-)
	DB	"XB"     ; Extended Boot Signature
 START:                  ; XBoot entry point
        jmp	short INI
        jmp	XLoad
 INI:	mov	ax, ds:BootRecord.PhysDrive[LOADED]
        mov	ds:DrType[XBOOTADDR],'F'
        mov	ds:HD_flag[XBOOTADDR],0
 	test	al,80h
        jz	fdd
        mov	ds:DrType[XBOOTADDR],'H'
        mov	ds:HD_flag[XBOOTADDR],1
 fdd:   and	al,7fh
        call	PrepByte
        xchg	al,ah
        mov	word ptr ds:DrNum[XBOOTADDR], ax
        mov	bx,offset BootRecord.OEM[LOADED]
        mov	cx,8
        call	putn
        putc	' '
        mov	di,TIMER_LOW
        mov	ax,es:[di]
        add	ax,DELAY
        sti
 Wait3: test	byte ptr es:[di+SHIFT_STATUS-TIMER_LOW],0fh
 	jz	nSK
        jmp	SelKern
 nSK: 	cmp	ax,es:[di]
        jae	Wait3            ; Waiting approximately 3 sec or any shift key
        call	MkBootMes
        mov	bx,DefaultKernel
        mov	cx,8
        call	putn
        putc	'.'
        mov	cx,3
        call	putn
        call	newline
        jmp	DefKernLoad0      ; Nothing to do: starting default kernel

HD_flag		DB	0    ;
NewDrive	DW	'00' ;
NewPart		DB	'0'  ;

ChgDrive:
        call	newline
        mov	bx,offset BootRecord.OEM[LOADED]
        mov	cx,8
        call	putn
        putc	' '
        mov	cx,11
        mov	bx,0
 clrfname:
        mov	byte ptr [si+bx],' '
        inc	bx
        loop	clrfname
        call	MkBootMes
        mov	cx,19
  sftleft:
        mov	al,8
        put_al
        loop	sftleft
        xor	bx,bx
GetDr:
        xor	ah,ah
        int	16h
        cmp	al,27
        jz	startx
        cmp	al,':'
        jz	ChgDrive
        cmp	al,13
        jz	LoadSect1
        cmp	al,10
        jz	LoadSect1
        cmp	al," "
        jz	Show1
        cmp	al,9
        jz	Show1
        or	bx,bx
        jnz	C2
        and	al, NOT 20h
        mov	byte ptr ds:HD_flag[XBOOTADDR], 0
        mov	ds:DrType[XBOOTADDR],'F'
        cmp	al,'F'
        jz	DrOk
        cmp	al,'H'
        jnz	GetDr
        mov	byte ptr ds:HD_flag[XBOOTADDR], 1
        mov	ds:DrType[XBOOTADDR],'H'
 DrOk:  put_al
        push	bx
        mov	bx,offset BootMes[XBOOTADDR + 2]
        mov	cx,3
        call	putn
        pop	bx
        jmp	short COk
startx:	jmp	start1
Show1:	jmp	Show
LoadSect1:
	jmp	LoadSect

  C2:	cmp	bx,2
        ja	C3
  C2a:  cmp	al, '0'
        jb	GetDr
        cmp	al, '9'
        ja	GetDr
 C2b:   mov	byte ptr ds:HD_flag[bx+XBOOTADDR], al
	put_al
        cmp	bx,3
        jnz	C22
        mov	ds:PartNum[XBOOTADDR],al
        jmp	COk
 C22:   cmp	bx,2
        jnz	COk
        mov	ax,ds:NewDrive[XBOOTADDR]
        mov	word ptr ds:DrNum[XBOOTADDR],ax
        push	bx
        mov	bx,offset BootMes[XBOOTADDR + 7]
        mov	cx,3
        call	putn
        pop	bx
        jmp	short COk
        jmp	short COk

  C3:	cmp	bx,3
        ja	GetDr1
        cmp	al,'*'
        jnz	C2a
        jmp	C2b

  COk:	inc	bx
  	jmp	GetDr

Show:
GetDr1:	jmp	GetDr

LoadSect:
	mov	bx,offset B_sect[XBOOTADDR]
        mov	word ptr ds:[bx + 510], 0
        mov	cx,1
        mov	dx,ds:NewDrive[XBOOTADDR]
        xchg	dh,dl
        sub	dx,3030h
        cmp	byte ptr ds:HD_flag[XBOOTADDR], 0
        jz	L1
        or	dl,80h
 L1:    push	bp
	mov	bp,DRV_TRY
 DRVretry:
        MOV	AX,201H
        INT	13H
        JNC	B_Ok
        dec	bp
        jnz	DRVretry
        stc
 B_Ok:	pop	bp
 	; Must be error message?
        jc	start2
        cmp	word ptr ds:[bx + 510], 0aa55h
        jnz	start3
        push	bx
	mov	bx, offset S0[XBOOTADDR]
        call	puts
        pop	si
        mov	di,offset LOADED
        push	di
        mov	cx,512
        cld
        rep	movsb
        ret


start2:	mov	bx, offset S1[XBOOTADDR]
	call	puts
	jmp	start1
start3: mov	bx, offset S2[XBOOTADDR]
	jmp	start1

S0	DB	13,10,"Pass control to selected loader",13,10,0
S1	DB	13,10,"Read failure",13,10,0
S2	DB	13,10,"No bootable signature",13,10,0

ToSelKern:
        call	newline
        mov	bx,offset BootRecord.OEM[LOADED]
        mov	cx,8
        call	putn
        putc	' '
 SelKern:
        call	MkBootMes

        mov	di,DATAWIN       ; Preparing buffer for filename editor
        push	di
        mov	cx,11
        push	cx
        mov	al," "
        cld
        rep	stosb
        pop	cx
        pop	si
        inc	cx
        xor	bx,bx
; * Simple Filename Editor ;-)
;   Control keys: ESC,BS,ENTER,'.',':'
 gloop: xor	ah,ah
 	int	16h
        cmp	al,27
        jnz	not27
start1:
        call	newline
        jmp	START            ; ESC action: XBOOT restart

B_Sp:   or	bx,bx            ; BS  action: delete left char
	jz	gloop
        cmp	bl,8
        jnz	nodot1
        putc	8
 nodot1:push	bx
 	push	cx
        mov	bx,offset BkSp[XBOOTADDR]
        call	puts
        pop	cx
        pop	bx
        dec	bx
        inc	cx
        or	bx,bx
        jz	FirstChar
        cmp	byte ptr [si+bx-1],' '
FirstChar:
        mov	byte ptr [si+bx],' '
        jz	B_Sp
gloop1: jmp	gloop

ToExt:  cmp	cl,4             ; .   action: jump to extention
	jbe	gloop
        sub	cl,4
 xloop: putc	' '
 	loop	xloop
        mov	cl,5
        mov	bl,8
	jmp	mkdot

 not27: cmp	al,8
 	jz	B_Sp
        cmp	al,13
        jz	X_gl
        cmp	cl,1
        jz	gloop
        cmp	al,'.'
        jz	ToExt
        cmp	al,':'
        jnz	nocdr
        jmp	ChgDrive
 nocdr: cmp	al,' '
        jbe	gloop
        cmp	al,127
        jae	gloop
        cmp	al,'a'
        jb	chok
        cmp	al,'z'
        ja	chok
        sub	al,20h
 chok:  mov	byte ptr [si+bx],al
 	inc	bx
        put_al
        cmp	bl,8
        jnz	nodot
 mkdot: putc	'.'
 nodot: loop	gloop1
  X_gl:	call	newline          ; ENTER action: accept filename
        ; Now Kernel "FCB" in DS:SI
        mov	di,DefaultKernel
        mov	cx,11
        rep	movsb
        call	newline
DefKernLoad0:
        mov	word ptr ds:[XBOOTADDR+2],'bx'  ; Change "XB" to "xb" signature
        jmp	RESCAN

MkBootMes PROC NEAR
        mov	bx,offset BootMes[XBOOTADDR]
putavt	LABEL NEAR
	mov	cx,-1
putn    LABEL NEAR
	push	bp
 putn0:
        push	cx
	mov	al,[bx]
        or	al,al
        jz	putz
        inc	bx
        cmp	al,25
        jz	counter
	push	bx
        put_al
toloop:
        pop	bx
        pop	cx
        loop	putn0
        pop	bp
        ret
putz:	pop	cx
	pop	bp
	ret
counter:
	mov	ax,[bx]
        mov	cl,ah
        xor	ch,ch
        add	bx,2
        push	bx
 yloop:
        push	cx
        push	ax
        put_al
        pop	ax
        pop	cx
        loop	yloop
        jmp	short toloop
MkBootMes ENDP

newline PROC NEAR
        mov	bx,offset CRLF[XBOOTADDR]
        jmp	puts
newline ENDP

int10	PROC
	push	bp
        int	10h
        pop	bp
        ret
int10	ENDP

BootMes	 DB	"[FDD 00 | *] Boot: [",25," ",8,".   ]",25,8,13,0
BkSp	 DB 8,' ',8,0
CRLF     DB     13,10,0

XLoad: 

        mov	bx,offset Win[XBOOTADDR]
        call	puts
        mov	di,KernOfs
        mov	ax,[di].F_cluster
        push	ax
        mov	bx,DATAWIN
        mov	cl,4     ;???
        call	LoadHead
        pop	di

        DB	0eah
        DB	0
W95     DB	2    ; Here must be 0 for usual kernel and 2 for W'95!
        DB	70h
        DB	0


Win	DB	"MZ sigmature detected",13,10,0

INCLUDE PREPBYTE.INC

printbyte PROC
                call	prepbyte
                push	ax
                mov	al,ah
                mov	ah,0eh
                int	10h
                pop	ax
                mov	ah,0eh
                int	10h
                ret
printbyte ENDP

printword PROC
                push	ax
                push	ax
                mov	al,ah
                call	printbyte
                pop	ax
                call	printbyte
                mov	ax,0e20h
                int	10h
                pop	ax
		ret
printword ENDP

B_sect	LABEL	BYTE

XBOOT ENDS

	END START
