/*
 * Copyright (c) 2024 Alberto Mardegan <mardy@users.sourceforge.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * MANUEL BACHMANN BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <gctypes.h>

typedef struct {
    u16 width;
    u16 height;
    u8 hot_x;
    u8 hot_y;
    u8 bytes_per_pixel;
    u8 pixel_data[];
} FgOgcCursor;

static const FgOgcCursor OGC_cursor_hand = {
  37, 52, 11, 0, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Q\000"
  "\000\000\262\000\000\000\337\000\000\000\345\000\000\000\313\000\000\000\203\000\000\000\032\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005"
  "\000\000\000\224\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\330\000\000\000\062\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\177\000\000\000\377\000\000\000\377\026\026\026\377bbb\377ttt\377"
  "<<<\377\000\000\000\377\000\000\000\377\000\000\000\334\000\000\000\030\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000%\000\000\000\364\000\000\000\377...\377\327\327"
  "\327\377\377\377\377\377\377\377\377\377\373\373\373\377\177\177\177\377"
  "\000\000\000\377\000\000\000\377\000\000\000\206\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000n\000\000\000\377\005\005\005\377\277\277\277\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377BBB\377\000"
  "\000\000\377\000\000\000\323\000\000\000\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\225\000\000\000\377###\377\366\366\366\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\206\206\206\377\000\000"
  "\000\377\000\000\000\356\000\000\000\033\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\231\000\000\000\377+++\377\370\370\370\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\217\217\217\377\000\000\000\377"
  "\000\000\000\361\000\000\000\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\230\000\000\000\377***\377\367\367\367\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\215\215\215\377\000\000\000\377\000"
  "\000\000\360\000\000\000\037\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230"
  "\000\000\000\377***\377\367\367\367\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\215\215\215\377\000\000\000\377\000\000\000"
  "\360\000\000\000\037\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000"
  "\000\000\377***\377\367\367\367\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\215\215\215\377\000\000\000\377\000\000\000\360"
  "\000\000\000\037\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\000"
  "\377***\377\367\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\215\215\215\377\000\000\000\377\000\000\000\360\000\000"
  "\000\037\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\000\377"
  "***\377\367\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\215\215\215\377\000\000\000\377\000\000\000\360\000\000\000\037"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\000\377***\377"
  "\367\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\215\215\215\377\000\000\000\377\000\000\000\360\000\000\000\037\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\000\377***\377\367"
  "\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\215\215\215\377\000\000\000\377\000\000\000\357\000\000\000\026\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\000\377***\377\367\367"
  "\367\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\215\215\215\377\000\000\000\377\000\000\000\370\000\000\000\244\000\000\000\223"
  "\000\000\000e\000\000\000\032\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\000\377***\377\367\367"
  "\367\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\215\215\215\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\340\000\000\000Z\000\000\000\000\000\000\000\003\000\000\000\022\000\000\000\006\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\000\377***\377\367"
  "\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\215\215\215\377\000\000\000\377\001\001\001\377%%%\377\036\036\036"
  "\377\000\000\000\377\000\000\000\377\000\000\000\373\000\000\000\244\000\000\000\310\000\000\000\341\000\000\000\320"
  "\000\000\000\220\000\000\000*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\230\000\000\000"
  "\377***\377\367\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\210\210\210\377\022\022\022\377\270\270\270"
  "\377\356\356\356\377\351\351\351\377\236\236\236\377\022\022\022\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\357\000\000\000[\000\000\000"
  "\030\000\000\000<\000\000\000B\000\000\000(\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\227\000\000\000\377***\377\367\367\367\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\202\202\202\377\065\065\065\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\246\246\246\377\001\001\001\377\003\003\003\377@@@\377iii\377DD"
  "D\377\002\002\002\377\000\000\000\377\000\000\000\372\000\000\000\342\000\000\000\375\000\000\000\377\000\000\000\360"
  "\000\000\000\264\000\000\000:\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\233\000\000\000\377***\377\367\367\367\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\203\203\203\377\061\061\061"
  "\377\375\375\375\377\377\377\377\377\377\377\377\377\377\377\377\377\372"
  "\372\372\377\036\036\036\377kkk\377\375\375\375\377\377\377\377\377\377\377"
  "\377\377\253\253\253\377\015\015\015\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\366\000\000\000U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016"
  "\000\000\000n\000\000\000\272\000\000\000\360\000\000\000\377***\377\367\367\367\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\203"
  "\203\203\377\061\061\061\377\375\375\375\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\376\376\376\377\063\063\063\377\211\211\211\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\177\177\177\377\000\000"
  "\000\377AAA\377\236\236\236\377\256\256\256\377lll\377\011\011\011\377\000\000\000\377"
  "\000\000\000\360\000\000\000)\000\000\000\000\000\000\000!\000\000\000\304\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377***\377\367\367\367\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\203\203\203\377\061\061\061\377\375"
  "\375\375\377\377\377\377\377\377\377\377\377\377\377\377\377\375\375\375"
  "\377\061\061\061\377\203\203\203\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\304\304\304\377\011\011\011\377\327\327\327\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\247\247\247\377\006\006\006\377\000"
  "\000\000\377\000\000\000\225\000\000\000\016\000\000\000\312\000\000\000\377\000\000\000\377(((\377aaa\377\067"
  "\067\067\377'''\377\366\366\366\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\203\203\203\377\061\061\061\377\375"
  "\375\375\377\377\377\377\377\377\377\377\377\377\377\377\377\375\375\375"
  "\377\061\061\061\377\203\203\203\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\313\313\313\377\015\015\015\377\323\323\323\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377NNN\377\000\000\000"
  "\377\000\000\000\324\000\000\000s\000\000\000\377\000\000\000\377fff\377\357\357\357\377\377\377"
  "\377\377\244\244\244\377###\377\365\365\365\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377|||\377&&&\377\375\375"
  "\375\377\377\377\377\377\377\377\377\377\377\377\377\377\375\375\375\377"
  "&&&\377|||\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\306\306\306\377\001\001\001\377\317\317\317\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\200\200\200\377\000\000\000\377\000\000\000\345"
  "\000\000\000\305\000\000\000\377\062\062\062\377\371\371\371\377\377\377\377\377\377\377"
  "\377\377\235\235\235\377###\377\365\365\365\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\274\274\274\377\221"
  "\221\221\377\376\376\376\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\376\376\376\377\221\221\221\377\274\274\274\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\342\342\340\377\200\200\200"
  "\377\347\347\347\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\202\202\202\377\000\000\000\377\000\000\000\345\000\000\000\342\000\000\000\377www\377"
  "\377\377\377\377\376\376\376\377\377\377\377\377\235\235\235\377!##\377\365"
  "\365\365\377\377\377\377\377\374\376\376\377\374\376\376\377\374\376\376"
  "\377\374\376\376\377\377\377\377\377\377\377\377\377\374\376\376\377\374"
  "\376\376\377\374\376\376\377\374\376\376\377\374\376\376\377\377\377\377"
  "\377\377\377\377\377\374\376\376\377\374\376\376\377\374\376\376\377\374"
  "\376\376\377\377\377\377\377\377\377\377\377\377\377\377\377\374\376\376"
  "\377\374\376\376\377\374\376\376\377\377\377\377\377\201\201\201\377\000\000"
  "\000\377\000\000\000\345\000\000\000\346\000\000\000\377\203\203\203\377\377\377\377\377\375"
  "\373\375\377\377\377\377\377\233\233\235\377!!#\377\363\363\365\377\377\377"
  "\377\377\373\373\376\377\373\373\376\377\373\373\376\377\373\373\376\377"
  "\373\373\376\377\373\373\376\377\373\373\376\377\373\373\375\377\373\373"
  "\376\377\373\373\376\377\373\373\376\377\373\373\375\377\373\373\376\377"
  "\373\373\376\377\373\373\376\377\373\373\376\377\373\373\376\377\373\373"
  "\376\377\373\373\375\377\373\373\375\377\373\373\375\377\373\373\376\377"
  "\373\374\376\377\377\377\377\377\201\201\201\377\000\000\000\377\000\000\000\345\000\000"
  "\000\345\000\000\000\377\177\201\201\377\377\377\377\377\371\373\376\377\377\377"
  "\377\377\233\233\235\377\"\"\"\377\361\363\366\377\375\377\377\377\371\373"
  "\376\377\371\373\376\377\371\373\376\377\367\372\376\377\367\372\376\377"
  "\371\371\376\377\371\371\376\377\371\373\376\377\371\373\376\377\371\373"
  "\376\377\371\373\376\377\367\372\376\377\367\372\376\377\371\373\376\377"
  "\367\372\376\377\367\372\376\377\371\373\376\377\367\372\376\377\371\373"
  "\376\377\371\373\376\377\367\372\376\377\367\372\376\377\371\373\376\377"
  "\377\377\377\377\177\201\201\377\000\000\000\377\000\000\000\345\000\000\000\345\000\000\000\377"
  "\177\177\201\377\377\377\377\377\365\370\377\377\377\377\377\377\234\234"
  "\234\377\"\"\"\377\356\361\365\377\372\375\377\377\365\370\375\377\365\370"
  "\375\377\365\370\375\377\365\370\375\377\365\370\375\377\365\370\375\377"
  "\365\370\375\377\365\370\375\377\365\370\375\377\365\370\375\377\365\370"
  "\375\377\365\370\375\377\365\370\375\377\365\370\375\377\365\370\375\377"
  "\365\370\375\377\365\370\375\377\365\370\375\377\365\370\375\377\365\370"
  "\375\377\365\370\375\377\365\370\375\377\366\371\376\377\377\377\377\377"
  "\177\177\201\377\000\000\000\377\000\000\000\345\000\000\000\345\000\000\000\377}\200\202\377\377"
  "\377\377\377\363\366\375\377\377\377\377\377\232\234\234\377\"\"\"\377\355"
  "\357\364\377\370\372\377\377\363\366\375\377\363\366\375\377\363\366\375"
  "\377\363\366\375\377\363\366\375\377\363\366\375\377\363\366\375\377\363"
  "\366\375\377\363\366\375\377\363\366\375\377\363\366\375\377\363\366\375"
  "\377\363\366\375\377\363\366\375\377\363\366\375\377\363\366\375\377\363"
  "\366\375\377\363\366\375\377\363\366\375\377\363\366\375\377\363\366\375"
  "\377\363\366\375\377\364\367\376\377\377\377\377\377~\177\201\377\000\000\000\377"
  "\000\000\000\345\000\000\000\345\000\000\000\377|~\201\377\377\377\377\377\357\362\374\377"
  "\377\377\377\377\231\232\234\377\"\"\"\377\352\355\364\377\364\370\377\377"
  "\357\362\374\377\357\364\374\377\357\364\374\377\357\364\374\377\357\362"
  "\374\377\357\364\374\377\357\364\374\377\357\364\374\377\357\364\374\377"
  "\357\362\374\377\357\364\374\377\357\364\374\377\357\364\374\377\357\364"
  "\374\377\357\364\374\377\357\364\374\377\357\364\374\377\357\364\374\377"
  "\357\364\374\377\357\364\374\377\357\362\374\377\357\364\374\377\360\363"
  "\375\377\377\377\377\377|~\201\377\000\000\000\377\000\000\000\345\000\000\000\345\000\000\000\377"
  "z|\201\377\377\377\377\377\353\360\374\377\375\377\377\377\230\232\235\377"
  "\"\"\"\377\347\352\364\377\360\364\377\377\353\360\374\377\355\360\374\377"
  "\355\360\374\377\355\360\374\377\353\360\374\377\355\360\374\377\353\360"
  "\374\377\353\360\374\377\353\360\374\377\355\360\374\377\355\360\374\377"
  "\355\360\374\377\355\362\374\377\355\360\374\377\353\360\374\377\353\360"
  "\374\377\355\360\374\377\353\360\374\377\355\360\374\377\355\360\374\377"
  "\355\360\374\377\353\360\374\377\355\362\374\377\377\377\377\377z|\201\377"
  "\000\000\000\377\000\000\000\345\000\000\000\345\000\000\000\377y{\201\377\377\377\377\377\351\356"
  "\372\377\373\377\377\377\220\223\230\377\026\026\026\377\344\351\363\377\353"
  "\362\377\377\350\357\374\377\350\357\372\377\350\357\372\377\350\357\374"
  "\377\350\357\374\377\350\357\372\377\350\357\374\377\350\357\372\377\350"
  "\357\372\377\350\357\374\377\350\357\374\377\350\357\374\377\350\357\372"
  "\377\350\357\372\377\350\357\372\377\350\357\374\377\350\357\374\377\350"
  "\357\372\377\350\357\372\377\350\357\372\377\350\357\372\377\350\357\372"
  "\377\351\360\373\377\377\377\377\377y{\201\377\000\000\000\377\000\000\000\345\000\000\000"
  "\345\000\000\000\377xz\200\377\375\377\377\377\346\354\373\377\352\362\376\377"
  "\304\313\325\377\226\233\243\377\343\353\370\377\345\355\374\377\345\355"
  "\372\377\345\355\372\377\345\353\372\377\345\353\372\377\345\355\372\377"
  "\345\355\372\377\345\353\372\377\345\353\372\377\345\353\372\377\345\355"
  "\372\377\345\355\372\377\345\353\372\377\345\353\372\377\345\353\372\377"
  "\345\353\372\377\345\353\372\377\345\353\372\377\345\353\372\377\345\353"
  "\372\377\345\353\372\377\345\353\372\377\345\353\372\377\344\354\373\377"
  "\375\377\377\377xz\200\377\000\000\000\377\000\000\000\345\000\000\000\345\000\000\000\377ux\201"
  "\377\373\377\377\377\342\352\373\377\340\350\371\377\350\360\377\377\362"
  "\370\377\377\341\351\373\377\341\351\372\377\341\351\372\377\341\351\372"
  "\377\341\351\372\377\341\351\372\377\341\351\372\377\341\351\372\377\341"
  "\351\372\377\341\351\372\377\341\351\372\377\341\351\372\377\341\351\372"
  "\377\341\351\372\377\341\351\372\377\341\351\372\377\341\351\372\377\341"
  "\351\372\377\341\351\372\377\341\351\372\377\341\351\372\377\341\351\372"
  "\377\341\351\372\377\341\351\372\377\342\352\373\377\373\377\377\377ux\201"
  "\377\000\000\000\377\000\000\000\345\000\000\000\345\000\000\000\377ty\200\377\367\375\377\377\336"
  "\346\372\377\334\346\372\377\334\346\372\377\334\346\370\377\335\345\371"
  "\377\335\345\371\377\335\345\371\377\335\345\371\377\335\345\371\377\335"
  "\345\371\377\335\345\371\377\335\345\371\377\335\345\371\377\335\345\371"
  "\377\335\345\371\377\335\345\371\377\335\345\371\377\334\346\372\377\335"
  "\345\371\377\335\345\371\377\335\345\371\377\335\345\371\377\335\345\371"
  "\377\335\345\371\377\335\345\371\377\334\346\372\377\335\345\371\377\335"
  "\345\371\377\335\347\373\377\367\375\377\377ty\200\377\000\000\000\377\000\000\000\345"
  "\000\000\000\345\000\000\000\377sx\200\377\366\373\377\377\334\344\372\377\331\344\370"
  "\377\330\343\371\377\331\344\370\377\330\343\371\377\330\343\371\377\331"
  "\344\370\377\331\344\370\377\331\344\370\377\331\344\370\377\330\343\371"
  "\377\331\344\370\377\331\344\370\377\331\344\370\377\331\344\370\377\331"
  "\344\370\377\330\343\371\377\330\343\371\377\330\343\371\377\331\344\370"
  "\377\331\344\370\377\331\344\370\377\330\343\371\377\330\342\371\377\331"
  "\344\370\377\331\343\370\377\331\344\370\377\331\343\370\377\334\344\370"
  "\377\366\373\377\377sx\200\377\000\000\000\377\000\000\000\345\000\000\000\346\000\000\000\377QV"
  "[\377\365\373\377\377\334\346\372\377\325\341\370\377\325\337\370\377\325"
  "\341\370\377\325\341\370\377\325\341\370\377\325\341\370\377\325\341\370"
  "\377\325\341\370\377\325\341\370\377\325\341\370\377\325\341\370\377\325"
  "\341\370\377\325\341\370\377\325\341\370\377\325\341\370\377\325\341\370"
  "\377\325\341\370\377\325\341\370\377\325\341\370\377\325\341\370\377\325"
  "\341\370\377\325\341\370\377\325\341\370\377\325\341\370\377\325\341\370"
  "\377\324\341\370\377\324\341\370\377\334\346\372\377\365\373\377\377PU\\"
  "\377\000\000\000\377\000\000\000\346\000\000\000\314\000\000\000\377\012\012\014\377\254\264\301\377"
  "\362\370\377\377\325\341\370\377\321\335\367\377\320\335\370\377\320\335"
  "\370\377\320\335\370\377\320\335\370\377\320\335\370\377\320\335\370\377"
  "\320\335\370\377\320\335\370\377\321\335\367\377\320\335\370\377\320\335"
  "\370\377\320\335\370\377\320\335\370\377\320\335\370\377\321\335\367\377"
  "\321\335\367\377\320\335\370\377\320\335\370\377\320\335\370\377\320\335"
  "\370\377\320\335\370\377\321\335\367\377\320\335\370\377\321\335\367\377"
  "\326\340\371\377\362\370\377\377\254\264\301\377\012\012\014\377\000\000\000\377\000"
  "\000\000\314\000\000\000d\000\000\000\377\000\000\000\377\024\025\027\377\262\274\314\377\355\365"
  "\377\377\323\336\367\377\315\334\366\377\315\334\366\377\314\333\367\377"
  "\315\334\366\377\314\333\367\377\314\333\367\377\314\333\367\377\314\333"
  "\367\377\316\333\367\377\314\333\367\377\314\333\367\377\315\334\366\377"
  "\315\334\366\377\315\334\366\377\316\333\367\377\316\333\367\377\314\333"
  "\367\377\314\333\367\377\315\334\366\377\315\334\366\377\314\333\367\377"
  "\314\333\367\377\314\333\367\377\323\340\367\377\356\365\377\377\262\274"
  "\314\377\024\025\027\377\000\000\000\377\000\000\000\377\000\000\000d\000\000\000\002\000\000\000\220\000\000\000"
  "\377\000\000\000\377\025\027\032\377\261\273\315\377\352\362\377\377\317\333\367\377"
  "\311\326\366\377\311\330\366\377\311\330\366\377\311\330\366\377\311\330"
  "\366\377\311\330\366\377\311\330\366\377\311\330\366\377\311\330\366\377"
  "\311\330\366\377\311\330\366\377\311\330\366\377\311\330\366\377\311\330"
  "\366\377\311\330\366\377\311\330\366\377\311\330\366\377\311\330\366\377"
  "\311\330\366\377\311\330\366\377\311\330\366\377\317\333\367\377\352\362"
  "\377\377\261\271\315\377\025\027\032\377\000\000\000\377\000\000\000\377\000\000\000\220\000\000\000"
  "\002\000\000\000\000\000\000\000\002\000\000\000\224\000\000\000\377\000\000\000\377\025\030\032\377\257\272\320"
  "\377\346\356\377\377\313\330\366\377\305\325\365\377\305\324\365\377\305"
  "\324\365\377\305\325\365\377\305\324\365\377\305\324\365\377\305\325\365"
  "\377\305\325\365\377\305\324\365\377\305\325\365\377\305\325\365\377\305"
  "\324\365\377\305\325\365\377\305\325\365\377\305\325\365\377\305\325\365"
  "\377\305\325\365\377\305\324\365\377\305\324\365\377\313\332\366\377\346"
  "\356\377\377\257\272\320\377\025\027\032\377\000\000\000\377\000\000\000\377\000\000\000\224\000"
  "\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\235\000\000\000\377\000\000\000\377\031\032"
  "\034\377\267\304\335\377\327\345\377\377\307\326\365\377\302\322\365\377\302"
  "\322\365\377\302\322\365\377\302\322\365\377\302\322\365\377\302\322\365"
  "\377\302\322\365\377\302\322\365\377\302\322\365\377\302\322\365\377\302"
  "\322\365\377\302\322\365\377\302\322\365\377\302\322\365\377\302\322\365"
  "\377\302\322\365\377\302\322\365\377\305\326\367\377\327\343\377\377\267"
  "\304\335\377\031\032\034\377\000\000\000\377\000\000\000\377\000\000\000\235\000\000\000\004\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\000\000\000\241\000\000\000\377\000\000\000\377GJV\377"
  "\327\345\377\377\311\330\367\377\275\317\365\377\276\317\365\377\276\320"
  "\365\377\276\320\365\377\276\320\365\377\276\320\365\377\276\320\365\377"
  "\276\320\365\377\276\320\365\377\276\320\365\377\276\320\365\377\276\320"
  "\365\377\276\320\365\377\276\320\365\377\276\320\365\377\276\320\365\377"
  "\275\317\365\377\311\330\367\377\326\345\377\377GJV\377\000\000\000\377\000\000\000\377"
  "\000\000\000\241\000\000\000\006\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\011\000\000\000\313\000\000\000\377\015\015\017\377\270\305\341\377\312\334\374"
  "\377\271\315\364\377\272\314\364\377\272\316\364\377\272\316\364\377\272"
  "\316\364\377\272\316\364\377\272\316\364\377\272\316\364\377\272\316\364"
  "\377\272\316\364\377\272\316\364\377\272\316\364\377\272\316\364\377\272"
  "\316\364\377\272\316\364\377\272\316\364\377\271\316\364\377\312\334\374"
  "\377\270\305\341\377\015\015\017\377\000\000\000\377\000\000\000\313\000\000\000\011\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000s\000\000"
  "\000\377\004\004\006\377\254\270\324\377\311\332\376\377\267\313\364\377\270\312"
  "\363\377\270\314\363\377\270\314\363\377\270\314\363\377\270\314\363\377"
  "\270\312\363\377\270\312\363\377\270\314\363\377\270\314\363\377\270\314"
  "\363\377\270\314\363\377\270\312\363\377\270\314\363\377\270\314\363\377"
  "\270\314\363\377\267\313\364\377\311\332\376\377\254\270\324\377\004\004\006\377"
  "\000\000\000\377\000\000\000s\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000a\000\000\000\377\005\005\007\377\253\270\324\377\306\332"
  "\376\377\263\310\363\377\264\311\363\377\264\311\363\377\264\311\363\377"
  "\264\311\363\377\264\311\363\377\264\311\364\377\264\311\364\377\264\311"
  "\363\377\264\311\363\377\264\311\363\377\264\311\363\377\264\311\363\377"
  "\264\311\363\377\264\311\364\377\264\311\364\377\263\310\363\377\306\332"
  "\376\377\253\270\324\377\005\005\007\377\000\000\000\377\000\000\000a\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000d\000\000\000\377"
  "\005\005\007\377\255\274\332\377\306\330\376\377\261\306\363\377\262\307\362\377"
  "\262\307\362\377\262\307\362\377\262\307\362\377\262\307\362\377\262\307"
  "\362\377\262\307\362\377\262\307\362\377\262\307\362\377\262\307\362\377"
  "\262\307\362\377\262\307\362\377\262\307\362\377\262\307\362\377\262\307"
  "\362\377\261\306\363\377\306\330\376\377\255\274\332\377\005\005\007\377\000\000\000"
  "\377\000\000\000d\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000W\000\000\000\377\002\002\002\377\205\220\251\377\341\354\377"
  "\377\313\333\377\377\311\333\377\377\311\333\377\377\311\333\377\377\311"
  "\333\377\377\311\333\377\377\311\333\377\377\311\333\377\377\311\333\377"
  "\377\311\333\377\377\310\332\377\377\311\333\377\377\311\333\377\377\311"
  "\333\377\377\310\332\377\377\310\332\377\377\313\333\377\377\340\354\377"
  "\377\205\220\251\377\002\002\002\377\000\000\000\377\000\000\000W\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\034\000\000\000\354"
  "\000\000\000\377\020\022\025\377RZi\377]ev\377Zdt\377Zdt\377[ct\377[ct\377Zdt\377"
  "Zdt\377Zdt\377[ct\377[ct\377Zds\377[ct\377[ct\377Zdt\377[cr\377Zds\377]e"
  "v\377RZi\377\020\022\025\377\000\000\000\377\000\000\000\354\000\000\000\034\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000f\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000f\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R\000\000\000\275\000"
  "\000\000\344\000\000\000\345\000\000\000\344\000\000\000\344\000\000\000\344\000\000\000\344\000\000\000\344\000\000"
  "\000\344\000\000\000\344\000\000\000\344\000\000\000\344\000\000\000\344\000\000\000\344\000\000\000\344\000\000\000"
  "\344\000\000\000\344\000\000\000\344\000\000\000\345\000\000\000\344\000\000\000\275\000\000\000R\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};

static const FgOgcCursor OGC_cursor_arrow = {
  24, 31, 0, 0, 4,
  "\002\002\002\337\000\000\000\224\000\000\000\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\000\000\000\377"
  "\005\005\005\321\000\000\000$\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377ddd\377\037\037\037\373\003\003\003\364"
  "\000\000\000V\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\377\225\225\225\377\361\361\361\377VVV\376\000\000\000\377"
  "\002\002\002\243\000\000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\377\225\225\225\377\377\377\377\377\377\377\377\377\241"
  "\241\241\377\007\007\007\375\005\005\005\322\000\000\000%\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\225\225\225\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\315\315\315\377!!!\373\003\003\003\365\000\000\000Y\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\225\225\225\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362\362\362\377"
  "WWW\376\000\000\000\377\002\002\002\243\000\000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\377\225\225\225\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\241\241\241\377\007\007\007\375\005"
  "\005\005\331\000\000\000+\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\225\225\225\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\316\316\316\377!!!\373\003\003\003\365\000\000\000Z"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\377\225\225\225\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\362\362\362\377XXX\376\000\000\000\377\002\002\002\243\000\000\000"
  "\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\377\225\225\225\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\375\375\377\377\373\374\376\377\235\236\240\377\007\007\007\374\005"
  "\005\005\331\000\000\000+\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\377\225\225\225\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\375\375\377\377"
  "\373\374\376\377\371\373\376\377\367\371\376\377\366\370\375\377\305\310"
  "\314\377\037!\"\373\003\003\003\366\000\000\000[\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\377\225\225\225\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\375\375\377\377\373\374\376\377\371"
  "\373\376\377\367\371\376\377\366\370\375\377\364\367\375\377\362\365\375"
  "\377\360\364\374\377\342\347\357\377QSW\376\000\000\000\377\002\002\002\243\000\000\000\012"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\225\225\225\377\377\377"
  "\377\377\377\377\377\377\375\375\377\377\373\374\376\377\371\373\376\377"
  "\367\371\376\377\366\370\375\377\364\367\375\377\362\365\375\377\360\364"
  "\374\377\356\363\374\377\354\362\374\377\353\360\374\377\351\357\373\377"
  "\222\226\236\377\007\007\007\374\004\005\005\331\000\000\000+\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\377\225\225\225\377\375\375\377\377\373\374\376\377\371\373\376"
  "\377\367\371\376\377\366\370\375\377\364\367\375\377\362\365\375\377\360"
  "\364\374\377\356\363\374\377\354\362\374\377\353\360\374\377\351\357\373"
  "\377\347\356\373\377\345\354\373\377\343\353\372\377\275\303\321\377#%'\373"
  "\003\003\003\366\000\000\000[\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\223\223\224\377\371\373"
  "\376\377\367\371\376\377\366\370\375\377\364\367\375\377\362\365\375\377"
  "\360\364\374\377\356\363\374\377\354\362\374\377\353\360\374\377\351\357"
  "\373\377\347\356\373\377\345\354\373\377\343\353\372\377\342\352\372\377"
  "\340\350\372\377\336\347\371\377\321\332\354\377LOW\376\000\000\000\377\002\002\002\243"
  "\000\000\000\012\000\000\000\000\000\000\000\377\220\221\224\377\366\370\375\377\364\367\375\377"
  "\362\365\375\377\360\364\374\377\356\363\374\377\354\362\374\377\353\360"
  "\374\377\351\357\373\377\347\356\373\377\345\354\373\377\343\353\372\377"
  "\342\352\372\377\340\350\372\377\336\347\371\377\334\346\371\377\332\344"
  "\371\377\330\343\370\377\327\342\370\377\206\215\235\377\006\006\007\374\004\004\005"
  "\332\000\000\000,\000\000\000\377\217\220\224\377\362\365\375\377\360\364\374\377\356"
  "\363\374\377\354\361\374\377\353\360\374\377\351\357\373\377\347\356\373"
  "\377\345\354\373\377\343\353\372\377\342\352\372\377\340\350\372\377\336"
  "\347\371\377\334\346\371\377\332\344\371\377\330\343\370\377\327\342\370"
  "\377\325\340\370\377\323\337\370\377\321\336\367\377pw\206\377\000\000\000\377"
  "\001\001\001\347\000\000\000\377\214\217\223\377\356\363\374\377\354\361\374\377\353"
  "\360\374\377\351\357\373\377\347\356\373\377\345\354\373\377\343\353\372"
  "\377\342\352\372\377\340\350\372\377\336\347\371\377\334\346\371\377\332"
  "\344\371\377\330\343\370\377\327\342\370\377\325\340\370\377\323\337\370"
  "\377\321\336\367\377\225\236\261\377,/\065\374\000\000\000\377\004\004\005\316\000\000\000F"
  "\000\000\000\377\212\215\223\377\353\360\374\377\351\357\373\377\347\356\373\377"
  "\345\354\373\377\343\353\372\377\342\352\372\377\340\350\372\377\336\347"
  "\371\377\334\346\371\377\332\344\371\377\330\343\370\377\327\342\370\377"
  "\325\340\370\377\323\337\370\377\321\336\367\377\236\250\275\377\062\065<\374"
  "\000\000\000\377\002\004\004\323\000\000\000U\000\000\000\001\000\000\000\000\000\000\000\377\210\214\223\377\347"
  "\356\373\377\345\354\373\377\343\353\372\377\342\352\372\377\340\350\372"
  "\377\336\347\371\377\334\346\371\377\332\344\371\377\330\343\370\377\327"
  "\342\370\377\325\340\370\377\323\337\370\377\321\336\367\377\230\241\265"
  "\377,/\064\374\000\000\000\377\002\004\004\323\000\000\000U\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\377\206\212\223\377\343\353\372\377\341\352\372\377\340\350\372\377"
  "\336\347\371\377\334\346\371\377\332\344\371\377\330\343\370\377\327\342"
  "\370\377\325\340\370\377\323\337\370\377\321\336\367\377\317\334\367\377"
  "DHQ\374\000\000\000\377\004\004\004\314\000\000\000J\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\377\203\211\222\377\340\350\372\377\336\347\371\377\334"
  "\346\371\377\332\344\371\377\330\343\370\377\327\342\370\377\325\340\370"
  "\377\323\337\370\377\321\336\367\377\317\334\367\377\315\333\367\377\314"
  "\332\366\377JOZ\376\002\002\003\362\000\000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\202\207\221\377\334\346\371\377\332\344"
  "\371\377\330\343\370\377\327\342\370\377\325\340\370\377\323\337\370\377"
  "\321\336\367\377\316\333\366\377\315\333\367\377\314\332\366\377\312\330"
  "\366\377\310\327\366\377\250\266\320\377\002\002\002\376\000\000\000r\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\177\205\221\377\330\343"
  "\370\377\327\342\370\377\325\340\370\377\323\337\370\377\321\336\367\377"
  "\223\234\257\377),\062\374\036\040$\374\306\324\361\377\310\327\366\377\306"
  "\326\365\377\304\324\365\377\303\323\365\377FLX\376\003\003\004\354\000\000\000\012\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377~\204\221\377\325"
  "\340\370\377\323\337\370\377\321\336\367\377\222\233\256\377)-\063\374\000\000"
  "\000\377\002\004\004\321\000\000\000\376y\203\226\377\304\324\365\377\303\323\365\377\301"
  "\322\364\377\277\320\364\377\242\261\321\377\001\002\002\376\000\000\000s\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377{\202\221\377\321\336\367\377"
  "\222\233\256\377),\062\374\000\000\000\377\004\004\005\313\000\000\000I\000\000\000\000\001\001\003\263\026"
  "\030\034\373\275\316\357\377\277\320\364\377\275\317\364\377\273\316\364\377"
  "\271\314\363\377CJY\376\003\003\004\354\000\000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\377INW\377)+\061\373\000\000\000\377\004\004\004\312\000\000\000H\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\062\000\000\000\376t\177\225\377\273\316\364\377\271\314\363"
  "\377\270\313\363\377\212\232\271\377(,\066\375\000\000\000\377\000\000\000F\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\000\000\000\377\004\004\004\311\000\000\000H\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\003\003\262\025\027\034\373\264\307"
  "\356\377\212\232\271\377.\063>\374\000\000\000\377\004\004\005\330\000\000\000V\000\000\000\001\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000t\000\000\000G\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\062\000\000\000\376\032\035$\375"
  "\000\000\000\377\004\004\005\327\000\000\000V\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\003\003\247\004\004\005\325\000\000\000U\000\000\000\002\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};

