Memstore
========

_A high-level interface for the memcached and membase servers_

Written by Kevin M. Rosenberg <kevin@rosenberg.net>

Downloads
---------

* The web site for memstore is [http://memstore.b9.com/](http://memstore.b9.com/)
* A git repository is available at [http://gitpub.b9.com/memstore.git](http://gitpub.b9.com/memstore.git)
* Releases are available for download at [http://files.b9.com/memstore/](http://files.b9.com/memstore/)

Prerequisites
-------------

This library incorporates a heavily modified version of `cl-memcached`
version 0.4.1. The primary need for the modification is to support the
`flags` field supported by the memcached server. The flag field is
used to store information required to deserialize the object data from
memcached. In addition to adding the `flags` field, the library has
been heavily refactored. For more information on the changes in
memcache, see [memcache](memcache.html).

This library also requires Common Lisp libraries of 
[kmrcl](http://gitpub.b9.com/kmrcl.git),
[cl-store](http://common-lisp.net/project/cl-store/),
[flexi-streams](http://weitz.de/flexi-streams/),
and [zlib](http://common-lisp.net/project/zlib/).

Overview
--------

Memstore allows efficient storing of simple objects as well as
easy storing of complex objects and optional compression.

When storing an object, if the object is a string then that is
directly written to the memcached server. For non-strings, an attempt
to made to write the object to a string with `*print-readably*` bound
to `t`. If that succeeds, then the string is converted to a vector of
octets. If that fails, the `cl-store` is used to serialize that object
to a vector of octets.

Next, optional compression is applied to the octets. First, the
`*compression-enabled*` flag is checked to see if compression is
enabled. Next, the length of the objects is compared to
`*compression-threshold*`. Only objects larger than
`*compression-threshold*` will be compressed. For objects that qualify
for compression, the size of the compressed object is compared to the
length of the uncompressed object to decide if the object is shrunk
enough to make the compression worthwhile.

The `flags` parameter to cl-memcached stores whether cl-store or
write-to-string is used to serialize the object and whether
compression is applied. `mem-restore` uses those flags to determine
how to reconstruct the object.
