;; -*- Mode: Common-Lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FILE IDENTIFICATION
;;
;; Name:          package.lisp
;; Purpose:       Package definition for memstore package
;; Date Started:  July 2011
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package #:cl-user)

(defpackage #:memstore
  (:nicknames #:ms)
  (:use #:common-lisp #:kmrcl)
  (:documentation "This is the main memstore package.")
  (:import-from #:memcache #:*memcache* #:*use-pool* #:mc-get #:mc-store
                #:mc-del #:mc-incr #:mc-decr)
  (:import-from #:flexi-streams #:make-in-memory-input-stream
                #:make-in-memory-output-stream
                #:get-output-stream-sequence #:octet)
  (:export
   #:*compression-threshold*
   #:*compression-enabled*
   #:*compression-savings*
   #:*namespace*
   #:ms-serialize
   #:ms-deserialize
   #:ms-store
   #:ms-restore
   #:ms-del
   #:ms-incr
   #:ms-decr))
