###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for nmap MDKA-2007:005 (nmap)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830225);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDKA", value: "2007:005");
  script_name( "Mandriva Update for nmap MDKA-2007:005 (nmap)");
  desc = "

  Vulnerability Insight:

  The version of nmap shipped with Mandriva Linux 2007 was built against
  the system copies of the libpcap and libdnet libraries. However, nmap
  actually requires changes to be made to these libraries which have not
  yet been made to the upstream versions, and consequently should be
  compiled against its own built-in copies of these libraries. This
  problem causes nmap not to work as the root user: it would simply
  freeze up. The updated package fixes this problem. It also fixes the
  menu entry for the package.

  Affected Software/OS:
  nmap on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00013.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nmap");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"nmap", rpm:"nmap~4.11~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nmap-frontend", rpm:"nmap-frontend~4.11~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}