#
# This script was written by Noam Rathaus
#
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(15715);
 script_version("$Revision: 7516 $");
 script_tag(name:"risk_factor", value:"High");
 script_name("Nortel Default Username and Password");
	     

 desc = "
The username/password combination 'ro/ro' or 'rwa/rwa' are valid.

These username and password are the default ones for many of
Nortel's network devices.

Solution : Set a strong password for the account
Risk Factor : High";

 script_description(desc);
 
 script_summary("Logs into the remote host");

 script_category(ACT_GATHER_INFO);

 script_family("Privilege escalation");
 
 script_copyright("This script is Copyright (C) 2004 Noam Rathaus");
 
 script_dependencie("find_service.nes");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

#
# The script code starts here : 
#
include("ssh_func.inc");

port = kb_ssh_transport();
if ( ! port || !get_port_state(port) ) exit(0);

soc = open_sock_tcp(port);
if ( ! soc ) exit(0);
ret = ssh_login(socket:soc, login:"ro", password:"ro");
close(soc);
if ( ret == 0 ) security_hole(port);

soc = open_sock_tcp(port);
if ( ! soc ) exit(0);
ret = ssh_login(socket:soc, login:"rwa", password:"rwa");
close(soc);
if ( ret == 0 ) security_hole(port);

