###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_document_location_dos_vuln.nasl 4348 2009-08-28 11:47:33Z aug $
#
# Mozilla Firefox 'document.location' Denial Of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900831);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2975");
  script_name("Mozilla Firefox 'document.location' Denial Of Service Vulnerability");
  desc = "
  Overview: The host is installed with Firefox browser on Windows XP and is
  prone to Denial of Service vulnerability.

  Vulnerability Insight:
  The flaw is due to an incompletely configured protocol handler that does not
  properly implement setting of the 'document.location' property to a value
  specifying a protocol associated with an external application, which can
  be caused via vectors involving a series of function calls that set this
  property, as demonstrated by the 'chromehtml:' and 'aim:' protocols.

  Impact:
  Successful exploitation will let the attackers to cause excessive memory
  consumption in the affected application and results in Denial of Service
  condition.

  Impact Level: System/Application

  Affected Software/OS:
  Mozilla Firefox version 3.5.2 on Windows XP.

  Fix: Upgrade to Mozilla Firefox version 3.6.3 or later
  For updates refer, http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://archives.neohapsis.com/archives/bugtraq/2009-08/0246.html
  http://archives.neohapsis.com/archives/bugtraq/2009-08/0234.html
  http://archives.neohapsis.com/archives/bugtraq/2009-08/0236.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("secpod_reg.inc");
include("version_func.inc");

if(hotfix_check_sp(xp:4) <= 0){
  exit(0);
}

# Get for Firefox Version
ffVer = get_kb_item("Firefox/Win/Ver");

if(isnull(ffVer))
{
  exit(0);
}

# Check for Firefox version 3.5.2
if(version_is_equal(version:ffVer, test_version:"3.5.2")){
  security_warning(0);
}
