##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_otrs_mult_sql_inj_vuln.nasl 7203 2010-02-19 12:33:29 feb $
#
# Open Ticket Request System (OTRS) Multiple SQL Injection Vulnerabilities
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################i###############################################

if(description)
{
  script_id(902016);
  script_version("$Revision: 8288 $: 1.0");
  script_tag(name:"cvss_base", value:"6.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2010-0438");
  script_bugtraq_id(38146);
  script_name("Open Ticket Request System (OTRS) Multiple SQL Injection Vulnerabilities");
  desc = "
  Overview: This host is running Open Ticket Request System (OTRS) and is prone
  to multiple SQL injection vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to error in 'Kernel/System/Ticket.pm' in 'OTRS-Core'.
  It fails to sufficiently sanitize user-supplied data before using it in SQL
  queries.

  Impact:
  Successful exploitation will allow attackers to manipulate SQL queries to
  read or modify records in the database, could also allow access to more
  administrator permissions.

  Impact Level: Application.

  Affected Software :
  Open Ticket Request System (OTRS) version prior to 2.1.9, 2.2.9,2.3.5 and 2.4.7

  Fix: Upgarde to Open Ticket Request System (OTRS) 2.1.9, 2.2010.9, 2.3.5, 2.4.7
  For updates refer, http://otrs.org/download/

  References:
  http://otrs.org/advisory/OSA-2010-01-en/
  http://www.security-database.com/detail.php?alert=CVE-2010-0438

  CVSS Score:
    CVSS Base Score      : 6.5 (AV:N/AC:L/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score  : 4.8
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Open Ticket Request System (OTRS)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyrightopyright (c) 2010 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_otrs_detect.nasl");
  exit(0);
}


include("version_func.inc");
include("http_func.inc");

otrsPort = get_http_port(default:80);
if(!otrsPort){
  exit(0);
}

otrsVer = get_kb_item("www/" + otrsPort + "/OTRS");
if(!otrsVer){
  exit(0);
}

otrsVer = eregmatch(pattern:"^(.+) under (/.*)$", string:otrsVer);
if(isnull(otrsVer[1])){
  exit(0);
}

if(version_in_range(version:otrsVer[1], test_version:"2.1.0", test_version2:"2.1.8") ||
   version_in_range(version:otrsVer[1], test_version:"2.2.0", test_version2:"2.2.8") ||
   version_in_range(version:otrsVer[1], test_version:"2.3.0", test_version2:"2.3.4") ||
   version_in_range(version:otrsVer[1], test_version:"2.4.0", test_version2:"2.4.6")) {
  security_warning(otrsPort);
}
