package Poker::Score::Chinese;
use Moo;
use Algorithm::Combinatorics qw(combinations);

=head1 NAME

Poker::Score::Chinese - Identify and score Chinese poker hand. 

=head1 VERSION

Version 0.08

=cut

our $VERSION = '0.08';

=head1 INTRODUCTION

Three card scoring system used in Chinese poker.

=head1 SYNOPSIS

See Poker::Score for code example.

=cut


extends 'Poker::Score';

sub _build_hands {}

sub stringify_cards {
  my ( $self, $cards ) = @_;
  my $flat = join( '',
    sort { $b <=> $a }
    map { sprintf( "%02d", $self->rank_val( $_->rank ) ) } @$cards );
  return $flat;
}

sub _build_hand_lookup {
  my $self = shift;
  $self->_hand_lookup(

    {
      '040302' => 0.82,
      '050302' => 0.83,
      '050402' => 0.84,
      '050403' => 0.85,
      '060302' => 0.86,
      '060402' => 0.87,
      '060403' => 0.88,
      '060502' => 0.89,
      '060503' => 0.9,
      '060504' => 0.91,
      '070302' => 0.92,
      '070402' => 0.93,
      '070403' => 0.94,
      '070502' => 0.95,
      '070503' => 0.96,
      '070504' => 0.97,
      '070602' => 0.98,
      '070603' => 0.99,
      '070604' => 1,
      '070605' => 2,
      '080302' => 3.95,
      '080402' => 3.96,
      '080403' => 3.97,
      '080502' => 3.98,
      '080503' => 3.99,
      '080504' => 4,
      '080602' => 4.98,
      '080603' => 4.99,
      '080604' => 5,
      '080605' => 6,
      '080702' => 8.98,
      '080703' => 8.99,
      '080704' => 9,
      '080705' => 10,
      '080706' => 13,
      '090302' => 17.95,
      '090402' => 17.96,
      '090403' => 17.97,
      '090502' => 17.98,
      '090503' => 17.99,
      '090504' => 18,
      '090602' => 18.98,
      '090603' => 18.99,
      '090604' => 19,
      '090605' => 20,
      '090702' => 22.98,
      '090703' => 22.99,
      '090704' => 23,
      '090705' => 24,
      '090706' => 27,
      '090802' => 32.98,
      '090803' => 32.99,
      '090804' => 33,
      '090805' => 34,
      '090806' => 37,
      '090807' => 43,
      '100302' => 51.95,
      '100402' => 51.96,
      '100403' => 51.97,
      '100502' => 51.98,
      '100503' => 51.99,
      '100504' => 52,
      '100602' => 52.98,
      '100603' => 52.99,
      '100604' => 53,
      '100605' => 54,
      '100702' => 56.98,
      '100703' => 56.99,
      '100704' => 57,
      '100705' => 58,
      '100706' => 61,
      '100802' => 66.98,
      '100803' => 66.99,
      '100804' => 67,
      '100805' => 68,
      '100806' => 71,
      '100807' => 77,
      '100902' => 86.98,
      '100903' => 86.99,
      '100904' => 87,
      '100905' => 88,
      '100906' => 91,
      '100907' => 97,
      '100908' => 107,
      '110402' => 120.96,
      '110403' => 120.97,
      '110502' => 120.98,
      '110503' => 120.99,
      '110504' => 121,
      '110602' => 121.98,
      '110603' => 121.99,
      '110604' => 122,
      '110605' => 123,
      '110702' => 125.98,
      '110703' => 125.99,
      '110704' => 126,
      '110705' => 127,
      '110302' => 129.95,
      '110706' => 130,
      '110802' => 135.98,
      '110803' => 135.99,
      '110804' => 136,
      '110805' => 137,
      '110806' => 140,
      '110807' => 146,
      '110904' => 156,
      '110902' => 156.98,
      '110903' => 156.99,
      '110905' => 157,
      '110906' => 160,
      '110907' => 166,
      '110908' => 176,
      '111002' => 190.98,
      '111003' => 190.99,
      '111004' => 191,
      '111005' => 192,
      '111006' => 195,
      '111007' => 201,
      '111008' => 211,
      '111009' => 226,
      '120302' => 245.95,
      '120402' => 245.96,
      '120403' => 245.97,
      '120502' => 245.98,
      '120503' => 245.99,
      '120504' => 246,
      '120602' => 246.98,
      '120603' => 246.99,
      '120604' => 247,
      '120605' => 248,
      '120702' => 250.98,
      '120703' => 250.99,
      '120704' => 251,
      '120705' => 252,
      '120706' => 255,
      '120802' => 260.98,
      '120803' => 260.99,
      '120804' => 261,
      '120805' => 262,
      '120806' => 265,
      '120807' => 271,
      '120902' => 280.98,
      '120903' => 280.99,
      '120904' => 281,
      '120905' => 282,
      '120906' => 285,
      '120907' => 291,
      '120908' => 301,
      '121002' => 315.98,
      '121003' => 315.99,
      '121004' => 316,
      '121005' => 317,
      '121006' => 320,
      '121007' => 326,
      '121008' => 336,
      '121009' => 351,
      '121102' => 371.98,
      '121103' => 371.99,
      '121104' => 372,
      '121105' => 373,
      '121106' => 376,
      '121107' => 382,
      '121108' => 392,
      '121109' => 407,
      '121110' => 428,
      '130302' => 454.95,
      '130402' => 454.96,
      '130403' => 454.97,
      '130502' => 454.98,
      '130503' => 454.99,
      '130504' => 455,
      '130602' => 455.98,
      '130603' => 455.99,
      '130604' => 456,
      '130605' => 457,
      '130702' => 459.98,
      '130703' => 459.99,
      '130704' => 460,
      '130705' => 461,
      '130706' => 464,
      '130802' => 469.98,
      '130803' => 469.99,
      '130804' => 470,
      '130805' => 471,
      '130806' => 474,
      '130807' => 480,
      '130902' => 489.98,
      '130903' => 489.99,
      '130904' => 490,
      '130905' => 491,
      '130906' => 494,
      '130907' => 500,
      '130908' => 510,
      '131002' => 524.98,
      '131003' => 524.99,
      '131004' => 525,
      '131005' => 526,
      '131006' => 529,
      '131007' => 535,
      '131008' => 545,
      '131009' => 560,
      '131102' => 580.98,
      '131103' => 580.99,
      '131104' => 581,
      '131105' => 582,
      '131106' => 585,
      '131107' => 591,
      '131108' => 601,
      '131109' => 616,
      '131110' => 637,
      '131203' => 664.99,
      '131202' => 664.99,
      '131204' => 665,
      '131205' => 666,
      '131206' => 669,
      '131207' => 675,
      '131208' => 685,
      '131209' => 700,
      '131210' => 721,
      '131211' => 749,
      '140503' => 783.99,
      '140603' => 783.99,
      '140403' => 783.99,
      '140602' => 783.99,
      '140302' => 783.99,
      '140502' => 783.99,
      '140504' => 783.99,
      '140402' => 783.99,
      '140604' => 784,
      '140605' => 785,
      '140702' => 787.98,
      '140703' => 787.99,
      '140704' => 788,
      '140705' => 789,
      '140706' => 792,
      '140802' => 797.98,
      '140803' => 797.99,
      '140804' => 798,
      '140805' => 799,
      '140806' => 802,
      '140807' => 808,
      '140902' => 817.98,
      '140903' => 817.99,
      '140904' => 818,
      '140905' => 819,
      '140906' => 822,
      '140907' => 828,
      '140908' => 838,
      '141002' => 852.98,
      '141003' => 852.99,
      '141004' => 853,
      '141005' => 854,
      '141006' => 857,
      '141007' => 863,
      '141008' => 873,
      '141009' => 888,
      '141102' => 908.98,
      '141103' => 908.99,
      '141104' => 909,
      '141105' => 910,
      '141106' => 913,
      '141107' => 919,
      '141108' => 929,
      '141109' => 944,
      '141110' => 965,
      '141202' => 992.98,
      '141203' => 992.99,
      '141204' => 993,
      '141205' => 994,
      '141206' => 997,
      '141207' => 1003,
      '141208' => 1013,
      '141209' => 1028,
      '141210' => 1049,
      '141211' => 1077,
      '141302' => 1112.98,
      '141303' => 1112.99,
      '141304' => 1113,
      '141305' => 1114,
      '141306' => 1117,
      '141307' => 1123,
      '141308' => 1133,
      '141309' => 1148,
      '141310' => 1169,
      '141311' => 1197,
      '141312' => 1233,
      '030202' => 1276.98,
      '040202' => 1276.99,
      '050202' => 1277,
      '060202' => 1278,
      '070202' => 1281,
      '080202' => 1287,
      '090202' => 1297,
      '100202' => 1312,
      '110202' => 1333,
      '120202' => 1361,
      '130202' => 1397,
      '140202' => 1442,
      '030302' => 1496.98,
      '040303' => 1496.99,
      '050303' => 1497,
      '060303' => 1498,
      '070303' => 1501,
      '080303' => 1507,
      '090303' => 1517,
      '100303' => 1532,
      '110303' => 1553,
      '120303' => 1581,
      '130303' => 1617,
      '140303' => 1662,
      '040402' => 1716.98,
      '040403' => 1716.98,
      '050404' => 1717,
      '060404' => 1718,
      '070404' => 1721,
      '080404' => 1727,
      '090404' => 1737,
      '100404' => 1752,
      '110404' => 1773,
      '120404' => 1801,
      '130404' => 1837,
      '140404' => 1882,
      '050502' => 1936.98,
      '050503' => 1936.99,
      '050504' => 1937,
      '060505' => 1938,
      '070505' => 1941,
      '080505' => 1947,
      '090505' => 1957,
      '100505' => 1972,
      '110505' => 1993,
      '120505' => 2021,
      '130505' => 2057,
      '140505' => 2102,
      '060602' => 2156.98,
      '060603' => 2156.99,
      '060604' => 2157,
      '060605' => 2158,
      '070606' => 2161,
      '080606' => 2167,
      '090606' => 2177,
      '100606' => 2192,
      '110606' => 2213,
      '120606' => 2241,
      '130606' => 2277,
      '140606' => 2322,
      '070702' => 2376.99,
      '070703' => 2376.99,
      '070704' => 2377,
      '070705' => 2378,
      '070706' => 2381,
      '080707' => 2387,
      '090707' => 2397,
      '100707' => 2412,
      '110707' => 2433,
      '120707' => 2461,
      '130707' => 2497,
      '140707' => 2542,
      '080802' => 2596.98,
      '080803' => 2596.99,
      '080804' => 2597,
      '080805' => 2598,
      '080806' => 2601,
      '080807' => 2607,
      '090808' => 2617,
      '100808' => 2632,
      '110808' => 2653,
      '120808' => 2681,
      '130808' => 2717,
      '140808' => 2762,
      '090902' => 2816.98,
      '090903' => 2816.99,
      '090904' => 2817,
      '090905' => 2818,
      '090906' => 2821,
      '090907' => 2827,
      '090908' => 2837,
      '100909' => 2852,
      '110909' => 2873,
      '120909' => 2901,
      '130909' => 2937,
      '140909' => 2982,
      '101002' => 3036.98,
      '101003' => 3036.99,
      '101004' => 3037,
      '101005' => 3038,
      '101006' => 3041,
      '101007' => 3047,
      '101008' => 3057,
      '101009' => 3072,
      '111010' => 3093,
      '121010' => 3121,
      '131010' => 3157,
      '141010' => 3202,
      '111102' => 3256.98,
      '111103' => 3256.99,
      '111104' => 3257,
      '111105' => 3258,
      '111106' => 3261,
      '111107' => 3267,
      '111108' => 3277,
      '111109' => 3292,
      '111110' => 3313,
      '121111' => 3341,
      '131111' => 3377,
      '141111' => 3422,
      '121202' => 3476.98,
      '121203' => 3476.99,
      '121204' => 3477,
      '121205' => 3478,
      '121206' => 3481,
      '121207' => 3487,
      '121208' => 3497,
      '121209' => 3512,
      '121210' => 3533,
      '121211' => 3561,
      '131212' => 3597,
      '141212' => 3642,
      '131302' => 3696.98,
      '131303' => 3696.99,
      '131304' => 3697,
      '131305' => 3698,
      '131306' => 3701,
      '131307' => 3707,
      '131308' => 3717,
      '131309' => 3732,
      '131310' => 3753,
      '131311' => 3781,
      '131312' => 3817,
      '141313' => 3862,
      '141402' => 3916.98,
      '141403' => 3916.99,
      '141404' => 3917,
      '141405' => 3918,
      '141406' => 3921,
      '141407' => 3927,
      '141408' => 3937,
      '141409' => 3952,
      '141410' => 3973,
      '141411' => 4001,
      '141412' => 4037,
      '141413' => 4082,
      '020202' => 4995,
      '030303' => 5061,
      '040404' => 5127,
      '050505' => 5193,
      '060606' => 5259,
      '070707' => 5325,
      '080808' => 5391,
      '090909' => 5457,
      '101010' => 5523,
      '111111' => 5589,
      '121212' => 5655,
      '131313' => 5721,
      '141414' => 5787,
    }
  );
}

=head1 AUTHOR

Nathaniel Graham, C<< <ngraham at cpan.org> >>

=head1 LICENSE AND COPYRIGHT

Copyright 2016 Nathaniel Graham.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

=cut

1;
